/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.widget.LinearLayout;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.ArrowDirection;
import com.mapbox.mapboxsdk.annotations.Bubble;

public class BubbleLayout
extends LinearLayout {
    public static final float DEFAULT_STROKE_WIDTH = -1.0f;
    private ArrowDirection arrowDirection;
    private float arrowWidth;
    private float arrowHeight;
    private float arrowPosition;
    private float cornersRadius;
    private Bubble bubble;
    private int bubbleColor;
    private float strokeWidth;
    private int strokeColor;

    public BubbleLayout(Context context) {
        this(context, null, 0);
    }

    public BubbleLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BubbleLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.mapbox_BubbleLayout);
        int location = a.getInt(R.styleable.mapbox_BubbleLayout_mapbox_bl_arrowDirection, 0);
        this.arrowDirection = new ArrowDirection(location);
        this.arrowWidth = a.getDimension(R.styleable.mapbox_BubbleLayout_mapbox_bl_arrowWidth, BubbleLayout.convertDpToPixel(8.0f, context));
        this.arrowHeight = a.getDimension(R.styleable.mapbox_BubbleLayout_mapbox_bl_arrowHeight, BubbleLayout.convertDpToPixel(8.0f, context));
        this.arrowPosition = a.getDimension(R.styleable.mapbox_BubbleLayout_mapbox_bl_arrowPosition, BubbleLayout.convertDpToPixel(12.0f, context));
        this.cornersRadius = a.getDimension(R.styleable.mapbox_BubbleLayout_mapbox_bl_cornersRadius, 0.0f);
        this.bubbleColor = a.getColor(R.styleable.mapbox_BubbleLayout_mapbox_bl_bubbleColor, -1);
        this.strokeWidth = a.getDimension(R.styleable.mapbox_BubbleLayout_mapbox_bl_strokeWidth, -1.0f);
        this.strokeColor = a.getColor(R.styleable.mapbox_BubbleLayout_mapbox_bl_strokeColor, -7829368);
        a.recycle();
        this.initPadding();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.initDrawable(0, this.getWidth(), 0, this.getHeight());
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.bubble != null) {
            this.bubble.draw(canvas);
        }
        super.dispatchDraw(canvas);
    }

    static float convertDpToPixel(float dp, Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return dp * (float)(metrics.densityDpi / 160);
    }

    public ArrowDirection getArrowDirection() {
        return this.arrowDirection;
    }

    public BubbleLayout setArrowDirection(ArrowDirection arrowDirection) {
        this.resetPadding();
        this.arrowDirection = arrowDirection;
        this.initPadding();
        return this;
    }

    public float getArrowWidth() {
        return this.arrowWidth;
    }

    public BubbleLayout setArrowWidth(float arrowWidth) {
        this.resetPadding();
        this.arrowWidth = arrowWidth;
        this.initPadding();
        return this;
    }

    public float getArrowHeight() {
        return this.arrowHeight;
    }

    public BubbleLayout setArrowHeight(float arrowHeight) {
        this.resetPadding();
        this.arrowHeight = arrowHeight;
        this.initPadding();
        return this;
    }

    public float getArrowPosition() {
        return this.arrowPosition;
    }

    public BubbleLayout setArrowPosition(float arrowPosition) {
        this.resetPadding();
        this.arrowPosition = arrowPosition;
        this.initPadding();
        return this;
    }

    public float getCornersRadius() {
        return this.cornersRadius;
    }

    public BubbleLayout setCornersRadius(float cornersRadius) {
        this.cornersRadius = cornersRadius;
        this.requestLayout();
        return this;
    }

    public int getBubbleColor() {
        return this.bubbleColor;
    }

    public BubbleLayout setBubbleColor(int bubbleColor) {
        this.bubbleColor = bubbleColor;
        this.requestLayout();
        return this;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public BubbleLayout setStrokeWidth(float strokeWidth) {
        this.resetPadding();
        this.strokeWidth = strokeWidth;
        this.initPadding();
        return this;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public BubbleLayout setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        this.requestLayout();
        return this;
    }

    private void initPadding() {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        switch (this.arrowDirection.getValue()) {
            case 0: {
                paddingLeft = (int)((float)paddingLeft + this.arrowWidth);
                break;
            }
            case 1: {
                paddingRight = (int)((float)paddingRight + this.arrowWidth);
                break;
            }
            case 2: {
                paddingTop = (int)((float)paddingTop + this.arrowHeight);
                break;
            }
            case 3: {
                paddingBottom = (int)((float)paddingBottom + this.arrowHeight);
            }
        }
        if (this.strokeWidth > 0.0f) {
            paddingLeft = (int)((float)paddingLeft + this.strokeWidth);
            paddingRight = (int)((float)paddingRight + this.strokeWidth);
            paddingTop = (int)((float)paddingTop + this.strokeWidth);
            paddingBottom = (int)((float)paddingBottom + this.strokeWidth);
        }
        this.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    private void initDrawable(int left, int right, int top, int bottom) {
        if (right < left || bottom < top) {
            return;
        }
        RectF rectF = new RectF((float)left, (float)top, (float)right, (float)bottom);
        this.bubble = new Bubble(rectF, this.arrowDirection, this.arrowWidth, this.arrowHeight, this.arrowPosition, this.cornersRadius, this.bubbleColor, this.strokeWidth, this.strokeColor);
    }

    private void resetPadding() {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        switch (this.arrowDirection.getValue()) {
            case 0: {
                paddingLeft = (int)((float)paddingLeft - this.arrowWidth);
                break;
            }
            case 1: {
                paddingRight = (int)((float)paddingRight - this.arrowWidth);
                break;
            }
            case 2: {
                paddingTop = (int)((float)paddingTop - this.arrowHeight);
                break;
            }
            case 3: {
                paddingBottom = (int)((float)paddingBottom - this.arrowHeight);
            }
        }
        if (this.strokeWidth > 0.0f) {
            paddingLeft = (int)((float)paddingLeft - this.strokeWidth);
            paddingRight = (int)((float)paddingRight - this.strokeWidth);
            paddingTop = (int)((float)paddingTop - this.strokeWidth);
            paddingBottom = (int)((float)paddingBottom - this.strokeWidth);
        }
        this.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }
}

