/*
 * Decompiled with CFR 0.152.
 */
package com.almeros.android.multitouch.gesturedetectors;

import android.content.Context;
import android.view.MotionEvent;
import com.almeros.android.multitouch.gesturedetectors.TwoFingerGestureDetector;

public class RotateGestureDetector
extends TwoFingerGestureDetector {
    private final OnRotateGestureListener listener;
    private boolean sloppyGesture;

    public RotateGestureDetector(Context context, OnRotateGestureListener listener) {
        super(context);
        this.listener = listener;
    }

    @Override
    protected void handleStartProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 5: {
                this.resetState();
                this.prevEvent = MotionEvent.obtain((MotionEvent)event);
                this.timeDelta = 0L;
                this.updateStateByEvent(event);
                this.sloppyGesture = this.isSloppyGesture(event);
                if (this.sloppyGesture) break;
                this.gestureInProgress = this.listener.onRotateBegin(this);
                break;
            }
            case 2: {
                if (!this.sloppyGesture) break;
                this.sloppyGesture = this.isSloppyGesture(event);
                if (this.sloppyGesture) break;
                this.gestureInProgress = this.listener.onRotateBegin(this);
                break;
            }
            case 6: {
                if (this.sloppyGesture) break;
            }
        }
    }

    @Override
    protected void handleInProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 6: {
                this.updateStateByEvent(event);
                if (!this.sloppyGesture) {
                    this.listener.onRotateEnd(this);
                }
                this.resetState();
                break;
            }
            case 3: {
                if (!this.sloppyGesture) {
                    this.listener.onRotateEnd(this);
                }
                this.resetState();
                break;
            }
            case 2: {
                boolean updatePrevious;
                this.updateStateByEvent(event);
                if (!(this.currPressure / this.prevPressure > 0.67f) || !(updatePrevious = this.listener.onRotate(this))) break;
                this.prevEvent.recycle();
                this.prevEvent = MotionEvent.obtain((MotionEvent)event);
            }
        }
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.sloppyGesture = false;
    }

    public float getRotationDegreesDelta() {
        double diffRadians = Math.atan2(this.prevFingerDiffY, this.prevFingerDiffX) - Math.atan2(this.currFingerDiffY, this.currFingerDiffX);
        return (float)(diffRadians * 180.0 / Math.PI);
    }

    public static class SimpleOnRotateGestureListener
    implements OnRotateGestureListener {
        @Override
        public boolean onRotate(RotateGestureDetector detector) {
            return false;
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector detector) {
            return true;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector detector) {
        }
    }

    public static interface OnRotateGestureListener {
        public boolean onRotate(RotateGestureDetector var1);

        public boolean onRotateBegin(RotateGestureDetector var1);

        public void onRotateEnd(RotateGestureDetector var1);
    }
}

