/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.util.AttributeSet;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.Arrays;

public class MapboxMapOptions
implements Parcelable {
    private static final float FOUR_DP = 4.0f;
    private static final float NINETY_TWO_DP = 92.0f;
    private static final int UNDEFINED_COLOR = -1;
    private CameraPosition cameraPosition;
    private boolean debugActive;
    private boolean compassEnabled = true;
    private boolean fadeCompassFacingNorth = true;
    private int compassGravity = 8388661;
    private int[] compassMargins;
    private Drawable compassImage;
    private boolean logoEnabled = true;
    private int logoGravity = 8388691;
    private int[] logoMargins;
    @ColorInt
    private int attributionTintColor = -1;
    private boolean attributionEnabled = true;
    private int attributionGravity = 80;
    private int[] attributionMargins;
    private double minZoom = 0.0;
    private double maxZoom = 25.5;
    private boolean rotateGesturesEnabled = true;
    private boolean scrollGesturesEnabled = true;
    private boolean tiltGesturesEnabled = true;
    private boolean zoomGesturesEnabled = true;
    private boolean zoomControlsEnabled = false;
    private boolean doubleTapGesturesEnabled = true;
    private boolean myLocationEnabled;
    private Drawable myLocationForegroundDrawable;
    private Drawable myLocationForegroundBearingDrawable;
    private Drawable myLocationBackgroundDrawable;
    @ColorInt
    private int myLocationForegroundTintColor = -1;
    @ColorInt
    private int myLocationBackgroundTintColor = -1;
    private int[] myLocationBackgroundPadding;
    private int myLocationAccuracyTintColor;
    private int myLocationAccuracyAlpha;
    private float myLocationAccuracyThreshold;
    private boolean prefetchesTiles = true;
    private boolean zMediaOverlay = false;
    private String apiBaseUrl;
    private String style;
    public static final Parcelable.Creator<MapboxMapOptions> CREATOR = new Parcelable.Creator<MapboxMapOptions>(){

        public MapboxMapOptions createFromParcel(Parcel in) {
            return new MapboxMapOptions(in);
        }

        public MapboxMapOptions[] newArray(int size) {
            return new MapboxMapOptions[size];
        }
    };

    public MapboxMapOptions() {
    }

    private MapboxMapOptions(Parcel in) {
        Bitmap backgroundBitmap;
        Bitmap foregroundBearingBitmap;
        this.cameraPosition = (CameraPosition)in.readParcelable(CameraPosition.class.getClassLoader());
        this.debugActive = in.readByte() != 0;
        this.compassEnabled = in.readByte() != 0;
        this.compassGravity = in.readInt();
        this.compassMargins = in.createIntArray();
        this.fadeCompassFacingNorth = in.readByte() != 0;
        Bitmap compassBitmap = (Bitmap)in.readParcelable(this.getClass().getClassLoader());
        if (compassBitmap != null) {
            this.compassImage = new BitmapDrawable(compassBitmap);
        }
        this.logoEnabled = in.readByte() != 0;
        this.logoGravity = in.readInt();
        this.logoMargins = in.createIntArray();
        this.attributionEnabled = in.readByte() != 0;
        this.attributionGravity = in.readInt();
        this.attributionMargins = in.createIntArray();
        this.attributionTintColor = in.readInt();
        this.minZoom = in.readDouble();
        this.maxZoom = in.readDouble();
        this.rotateGesturesEnabled = in.readByte() != 0;
        this.scrollGesturesEnabled = in.readByte() != 0;
        this.tiltGesturesEnabled = in.readByte() != 0;
        this.zoomControlsEnabled = in.readByte() != 0;
        this.zoomGesturesEnabled = in.readByte() != 0;
        this.doubleTapGesturesEnabled = in.readByte() != 0;
        this.myLocationEnabled = in.readByte() != 0;
        Bitmap foregroundBitmap = (Bitmap)in.readParcelable(this.getClass().getClassLoader());
        if (foregroundBitmap != null) {
            this.myLocationForegroundDrawable = new BitmapDrawable(foregroundBitmap);
        }
        if ((foregroundBearingBitmap = (Bitmap)in.readParcelable(this.getClass().getClassLoader())) != null) {
            this.myLocationForegroundBearingDrawable = new BitmapDrawable(foregroundBearingBitmap);
        }
        if ((backgroundBitmap = (Bitmap)in.readParcelable(this.getClass().getClassLoader())) != null) {
            this.myLocationBackgroundDrawable = new BitmapDrawable(backgroundBitmap);
        }
        this.myLocationForegroundTintColor = in.readInt();
        this.myLocationBackgroundTintColor = in.readInt();
        this.myLocationBackgroundPadding = in.createIntArray();
        this.myLocationAccuracyAlpha = in.readInt();
        this.myLocationAccuracyTintColor = in.readInt();
        this.myLocationAccuracyThreshold = in.readFloat();
        this.style = in.readString();
        this.apiBaseUrl = in.readString();
        this.prefetchesTiles = in.readByte() != 0;
        this.zMediaOverlay = in.readByte() != 0;
    }

    static Bitmap getBitmapFromDrawable(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapboxMapOptions createFromAttributes(@NonNull Context context, @Nullable AttributeSet attrs) {
        MapboxMapOptions mapboxMapOptions = new MapboxMapOptions();
        float pxlRatio = context.getResources().getDisplayMetrics().density;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.mapbox_MapView, 0, 0);
        try {
            Drawable backgroundDrawable;
            Drawable foregroundBearingDrawable;
            mapboxMapOptions.camera(new CameraPosition.Builder(typedArray).build());
            mapboxMapOptions.styleUrl(typedArray.getString(R.styleable.mapbox_MapView_mapbox_styleUrl));
            mapboxMapOptions.apiBaseUrl(typedArray.getString(R.styleable.mapbox_MapView_mapbox_apiBaseUrl));
            mapboxMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiZoomGestures, true));
            mapboxMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiScrollGestures, true));
            mapboxMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiRotateGestures, true));
            mapboxMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiTiltGestures, true));
            mapboxMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiZoomControls, false));
            mapboxMapOptions.doubleTapGesturesEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiDoubleTapGestures, true));
            mapboxMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraZoomMax, 25.5f));
            mapboxMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraZoomMin, 0.0f));
            mapboxMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiCompass, true));
            mapboxMapOptions.compassGravity(typedArray.getInt(R.styleable.mapbox_MapView_mapbox_uiCompassGravity, 8388661));
            mapboxMapOptions.compassMargins(new int[]{(int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiCompassMarginLeft, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiCompassMarginTop, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiCompassMarginRight, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiCompassMarginBottom, 4.0f * pxlRatio)});
            mapboxMapOptions.compassFadesWhenFacingNorth(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiCompassFadeFacingNorth, true));
            Drawable compassDrawable = typedArray.getDrawable(R.styleable.mapbox_MapView_mapbox_uiCompassDrawable);
            if (compassDrawable == null) {
                compassDrawable = ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.drawable.mapbox_compass_icon, null);
            }
            mapboxMapOptions.compassImage(compassDrawable);
            mapboxMapOptions.logoEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiLogo, true));
            mapboxMapOptions.logoGravity(typedArray.getInt(R.styleable.mapbox_MapView_mapbox_uiLogoGravity, 8388691));
            mapboxMapOptions.logoMargins(new int[]{(int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginLeft, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginTop, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginRight, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginBottom, 4.0f * pxlRatio)});
            mapboxMapOptions.attributionTintColor(typedArray.getColor(R.styleable.mapbox_MapView_mapbox_uiAttributionTintColor, -1));
            mapboxMapOptions.attributionEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiAttribution, true));
            mapboxMapOptions.attributionGravity(typedArray.getInt(R.styleable.mapbox_MapView_mapbox_uiAttributionGravity, 80));
            mapboxMapOptions.attributionMargins(new int[]{(int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginLeft, 92.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginTop, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginRight, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginBottom, 4.0f * pxlRatio)});
            mapboxMapOptions.locationEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_myLocation, false));
            mapboxMapOptions.myLocationForegroundTintColor(typedArray.getColor(R.styleable.mapbox_MapView_mapbox_myLocationTintColor, -1));
            mapboxMapOptions.myLocationBackgroundTintColor(typedArray.getColor(R.styleable.mapbox_MapView_mapbox_myLocationBackgroundTintColor, -1));
            Drawable foregroundDrawable = typedArray.getDrawable(R.styleable.mapbox_MapView_mapbox_myLocationDrawable);
            if (foregroundDrawable == null) {
                foregroundDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.mapbox_mylocation_icon_default);
            }
            if ((foregroundBearingDrawable = typedArray.getDrawable(R.styleable.mapbox_MapView_mapbox_myLocationBearingDrawable)) == null) {
                foregroundBearingDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.mapbox_mylocation_icon_bearing);
            }
            if ((backgroundDrawable = typedArray.getDrawable(R.styleable.mapbox_MapView_mapbox_myLocationBackgroundDrawable)) == null) {
                backgroundDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.mapbox_mylocation_bg_shape);
            }
            mapboxMapOptions.myLocationForegroundDrawables(foregroundDrawable, foregroundBearingDrawable);
            mapboxMapOptions.myLocationBackgroundDrawable(backgroundDrawable);
            mapboxMapOptions.myLocationBackgroundPadding(new int[]{(int)(typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_myLocationBackgroundMarginLeft, 0.0f) * pxlRatio), (int)(typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_myLocationBackgroundMarginTop, 0.0f) * pxlRatio), (int)(typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_myLocationBackgroundMarginRight, 0.0f) * pxlRatio), (int)(typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_myLocationBackgroundMarginBottom, 0.0f) * pxlRatio)});
            mapboxMapOptions.myLocationAccuracyAlpha(typedArray.getInt(R.styleable.mapbox_MapView_mapbox_myLocationAccuracyAlpha, 100));
            mapboxMapOptions.myLocationAccuracyTint(typedArray.getColor(R.styleable.mapbox_MapView_mapbox_myLocationAccuracyTintColor, ColorUtils.getPrimaryColor(context)));
            mapboxMapOptions.myLocationAccuracyThreshold(typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_myLocationAccuracyThreshold, 0.0f));
            mapboxMapOptions.setPrefetchesTiles(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_enableTilePrefetch, true));
            mapboxMapOptions.renderSurfaceOnTop(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_enableZMediaOverlay, false));
        }
        finally {
            typedArray.recycle();
        }
        return mapboxMapOptions;
    }

    public MapboxMapOptions apiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
        return this;
    }

    public MapboxMapOptions camera(CameraPosition cameraPosition) {
        this.cameraPosition = cameraPosition;
        return this;
    }

    public MapboxMapOptions styleUrl(String styleUrl) {
        this.style = styleUrl;
        return this;
    }

    public MapboxMapOptions debugActive(boolean enabled) {
        this.debugActive = enabled;
        return this;
    }

    public MapboxMapOptions minZoomPreference(double minZoom) {
        this.minZoom = minZoom;
        return this;
    }

    public MapboxMapOptions maxZoomPreference(double maxZoom) {
        this.maxZoom = maxZoom;
        return this;
    }

    public MapboxMapOptions compassEnabled(boolean enabled) {
        this.compassEnabled = enabled;
        return this;
    }

    public MapboxMapOptions compassGravity(int gravity) {
        this.compassGravity = gravity;
        return this;
    }

    public MapboxMapOptions compassMargins(int[] margins) {
        this.compassMargins = margins;
        return this;
    }

    public MapboxMapOptions compassFadesWhenFacingNorth(boolean compassFadeWhenFacingNorth) {
        this.fadeCompassFacingNorth = compassFadeWhenFacingNorth;
        return this;
    }

    public MapboxMapOptions compassImage(Drawable compass) {
        this.compassImage = compass;
        return this;
    }

    public MapboxMapOptions logoEnabled(boolean enabled) {
        this.logoEnabled = enabled;
        return this;
    }

    public MapboxMapOptions logoGravity(int gravity) {
        this.logoGravity = gravity;
        return this;
    }

    public MapboxMapOptions logoMargins(int[] margins) {
        this.logoMargins = margins;
        return this;
    }

    public MapboxMapOptions attributionEnabled(boolean enabled) {
        this.attributionEnabled = enabled;
        return this;
    }

    public MapboxMapOptions attributionGravity(int gravity) {
        this.attributionGravity = gravity;
        return this;
    }

    public MapboxMapOptions attributionMargins(int[] margins) {
        this.attributionMargins = margins;
        return this;
    }

    public MapboxMapOptions attributionTintColor(@ColorInt int color2) {
        this.attributionTintColor = color2;
        return this;
    }

    public MapboxMapOptions rotateGesturesEnabled(boolean enabled) {
        this.rotateGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions scrollGesturesEnabled(boolean enabled) {
        this.scrollGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions tiltGesturesEnabled(boolean enabled) {
        this.tiltGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions zoomControlsEnabled(boolean enabled) {
        this.zoomControlsEnabled = enabled;
        return this;
    }

    public MapboxMapOptions zoomGesturesEnabled(boolean enabled) {
        this.zoomGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions doubleTapGesturesEnabled(boolean enabled) {
        this.doubleTapGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions locationEnabled(boolean locationEnabled) {
        this.myLocationEnabled = locationEnabled;
        return this;
    }

    public MapboxMapOptions myLocationForegroundDrawables(Drawable myLocationForegroundDrawable, Drawable myLocationBearingDrawable) {
        this.myLocationForegroundDrawable = myLocationForegroundDrawable;
        this.myLocationForegroundBearingDrawable = myLocationBearingDrawable;
        return this;
    }

    public MapboxMapOptions myLocationForegroundDrawable(Drawable myLocationForegroundDrawable) {
        this.myLocationForegroundDrawable = myLocationForegroundDrawable;
        return this;
    }

    public MapboxMapOptions myLocationBackgroundDrawable(Drawable myLocationBackgroundDrawable) {
        this.myLocationBackgroundDrawable = myLocationBackgroundDrawable;
        return this;
    }

    public MapboxMapOptions myLocationForegroundTintColor(@ColorInt int myLocationForegroundTintColor) {
        this.myLocationForegroundTintColor = myLocationForegroundTintColor;
        return this;
    }

    public MapboxMapOptions myLocationBackgroundTintColor(@ColorInt int myLocationBackgroundTintColor) {
        this.myLocationBackgroundTintColor = myLocationBackgroundTintColor;
        return this;
    }

    public MapboxMapOptions myLocationBackgroundPadding(int[] myLocationBackgroundPadding) {
        this.myLocationBackgroundPadding = myLocationBackgroundPadding;
        return this;
    }

    public MapboxMapOptions myLocationAccuracyTint(@ColorInt int myLocationAccuracyTintColor) {
        this.myLocationAccuracyTintColor = myLocationAccuracyTintColor;
        return this;
    }

    public MapboxMapOptions myLocationAccuracyAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.myLocationAccuracyAlpha = alpha;
        return this;
    }

    public MapboxMapOptions myLocationAccuracyThreshold(float myLocationAccuracyThreshold) {
        this.myLocationAccuracyThreshold = myLocationAccuracyThreshold;
        return this;
    }

    public MapboxMapOptions setPrefetchesTiles(boolean enable) {
        this.prefetchesTiles = enable;
        return this;
    }

    public boolean getPrefetchesTiles() {
        return this.prefetchesTiles;
    }

    public void renderSurfaceOnTop(boolean renderOnTop) {
        this.zMediaOverlay = renderOnTop;
    }

    public boolean getRenderSurfaceOnTop() {
        return this.zMediaOverlay;
    }

    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public CameraPosition getCamera() {
        return this.cameraPosition;
    }

    public double getMinZoomPreference() {
        return this.minZoom;
    }

    public double getMaxZoomPreference() {
        return this.maxZoom;
    }

    public boolean getCompassEnabled() {
        return this.compassEnabled;
    }

    public int getCompassGravity() {
        return this.compassGravity;
    }

    public int[] getCompassMargins() {
        return this.compassMargins;
    }

    public boolean getCompassFadeFacingNorth() {
        return this.fadeCompassFacingNorth;
    }

    public Drawable getCompassImage() {
        return this.compassImage;
    }

    public boolean getLogoEnabled() {
        return this.logoEnabled;
    }

    public int getLogoGravity() {
        return this.logoGravity;
    }

    public int[] getLogoMargins() {
        return this.logoMargins;
    }

    public String getStyle() {
        return this.style;
    }

    public boolean getRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    public boolean getScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    public boolean getTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    public boolean getZoomControlsEnabled() {
        return this.zoomControlsEnabled;
    }

    public boolean getZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    public boolean getDoubleTapGesturesEnabled() {
        return this.doubleTapGesturesEnabled;
    }

    public boolean getAttributionEnabled() {
        return this.attributionEnabled;
    }

    public int getAttributionGravity() {
        return this.attributionGravity;
    }

    public int[] getAttributionMargins() {
        return this.attributionMargins;
    }

    @ColorInt
    public int getAttributionTintColor() {
        return this.attributionTintColor;
    }

    public boolean getLocationEnabled() {
        return this.myLocationEnabled;
    }

    public Drawable getMyLocationForegroundDrawable() {
        return this.myLocationForegroundDrawable;
    }

    public Drawable getMyLocationForegroundBearingDrawable() {
        return this.myLocationForegroundBearingDrawable;
    }

    public Drawable getMyLocationBackgroundDrawable() {
        return this.myLocationBackgroundDrawable;
    }

    @ColorInt
    public int getMyLocationForegroundTintColor() {
        return this.myLocationForegroundTintColor;
    }

    @ColorInt
    public int getMyLocationBackgroundTintColor() {
        return this.myLocationBackgroundTintColor;
    }

    public int[] getMyLocationBackgroundPadding() {
        return this.myLocationBackgroundPadding;
    }

    public int getMyLocationAccuracyTintColor() {
        return this.myLocationAccuracyTintColor;
    }

    public int getMyLocationAccuracyAlpha() {
        return this.myLocationAccuracyAlpha;
    }

    public float getMyLocationAccuracyThreshold() {
        return this.myLocationAccuracyThreshold;
    }

    public boolean getDebugActive() {
        return this.debugActive;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.cameraPosition, flags);
        dest.writeByte((byte)(this.debugActive ? 1 : 0));
        dest.writeByte((byte)(this.compassEnabled ? 1 : 0));
        dest.writeInt(this.compassGravity);
        dest.writeIntArray(this.compassMargins);
        dest.writeByte((byte)(this.fadeCompassFacingNorth ? 1 : 0));
        dest.writeParcelable((Parcelable)(this.compassImage != null ? MapboxMapOptions.getBitmapFromDrawable(this.compassImage) : null), flags);
        dest.writeByte((byte)(this.logoEnabled ? 1 : 0));
        dest.writeInt(this.logoGravity);
        dest.writeIntArray(this.logoMargins);
        dest.writeByte((byte)(this.attributionEnabled ? 1 : 0));
        dest.writeInt(this.attributionGravity);
        dest.writeIntArray(this.attributionMargins);
        dest.writeInt(this.attributionTintColor);
        dest.writeDouble(this.minZoom);
        dest.writeDouble(this.maxZoom);
        dest.writeByte((byte)(this.rotateGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.scrollGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.tiltGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.zoomControlsEnabled ? 1 : 0));
        dest.writeByte((byte)(this.zoomGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.doubleTapGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.myLocationEnabled ? 1 : 0));
        dest.writeParcelable((Parcelable)(this.myLocationForegroundDrawable != null ? MapboxMapOptions.getBitmapFromDrawable(this.myLocationForegroundDrawable) : null), flags);
        dest.writeParcelable((Parcelable)(this.myLocationForegroundBearingDrawable != null ? MapboxMapOptions.getBitmapFromDrawable(this.myLocationForegroundBearingDrawable) : null), flags);
        dest.writeParcelable((Parcelable)(this.myLocationBackgroundDrawable != null ? MapboxMapOptions.getBitmapFromDrawable(this.myLocationBackgroundDrawable) : null), flags);
        dest.writeInt(this.myLocationForegroundTintColor);
        dest.writeInt(this.myLocationBackgroundTintColor);
        dest.writeIntArray(this.myLocationBackgroundPadding);
        dest.writeInt(this.myLocationAccuracyAlpha);
        dest.writeInt(this.myLocationAccuracyTintColor);
        dest.writeFloat(this.myLocationAccuracyThreshold);
        dest.writeString(this.style);
        dest.writeString(this.apiBaseUrl);
        dest.writeByte((byte)(this.prefetchesTiles ? 1 : 0));
        dest.writeByte((byte)(this.zMediaOverlay ? 1 : 0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapboxMapOptions options = (MapboxMapOptions)o;
        if (this.debugActive != options.debugActive) {
            return false;
        }
        if (this.compassEnabled != options.compassEnabled) {
            return false;
        }
        if (this.fadeCompassFacingNorth != options.fadeCompassFacingNorth) {
            return false;
        }
        if (this.compassImage != null ? !this.compassImage.equals(options.compassImage) : options.compassImage != null) {
            return false;
        }
        if (this.compassGravity != options.compassGravity) {
            return false;
        }
        if (this.logoEnabled != options.logoEnabled) {
            return false;
        }
        if (this.logoGravity != options.logoGravity) {
            return false;
        }
        if (this.attributionTintColor != options.attributionTintColor) {
            return false;
        }
        if (this.attributionEnabled != options.attributionEnabled) {
            return false;
        }
        if (this.attributionGravity != options.attributionGravity) {
            return false;
        }
        if (Double.compare(options.minZoom, this.minZoom) != 0) {
            return false;
        }
        if (Double.compare(options.maxZoom, this.maxZoom) != 0) {
            return false;
        }
        if (this.rotateGesturesEnabled != options.rotateGesturesEnabled) {
            return false;
        }
        if (this.scrollGesturesEnabled != options.scrollGesturesEnabled) {
            return false;
        }
        if (this.tiltGesturesEnabled != options.tiltGesturesEnabled) {
            return false;
        }
        if (this.zoomGesturesEnabled != options.zoomGesturesEnabled) {
            return false;
        }
        if (this.zoomControlsEnabled != options.zoomControlsEnabled) {
            return false;
        }
        if (this.doubleTapGesturesEnabled != options.doubleTapGesturesEnabled) {
            return false;
        }
        if (this.myLocationEnabled != options.myLocationEnabled) {
            return false;
        }
        if (this.myLocationForegroundTintColor != options.myLocationForegroundTintColor) {
            return false;
        }
        if (this.myLocationBackgroundTintColor != options.myLocationBackgroundTintColor) {
            return false;
        }
        if (this.myLocationAccuracyTintColor != options.myLocationAccuracyTintColor) {
            return false;
        }
        if (this.myLocationAccuracyAlpha != options.myLocationAccuracyAlpha) {
            return false;
        }
        if (this.myLocationAccuracyThreshold != options.myLocationAccuracyThreshold) {
            return false;
        }
        if (this.cameraPosition != null ? !this.cameraPosition.equals(options.cameraPosition) : options.cameraPosition != null) {
            return false;
        }
        if (!Arrays.equals(this.compassMargins, options.compassMargins)) {
            return false;
        }
        if (!Arrays.equals(this.logoMargins, options.logoMargins)) {
            return false;
        }
        if (!Arrays.equals(this.attributionMargins, options.attributionMargins)) {
            return false;
        }
        if (this.myLocationForegroundDrawable != null ? !this.myLocationForegroundDrawable.equals(options.myLocationForegroundDrawable) : options.myLocationForegroundDrawable != null) {
            return false;
        }
        if (this.myLocationForegroundBearingDrawable != null ? !this.myLocationForegroundBearingDrawable.equals(options.myLocationForegroundBearingDrawable) : options.myLocationForegroundBearingDrawable != null) {
            return false;
        }
        if (this.myLocationBackgroundDrawable != null ? !this.myLocationBackgroundDrawable.equals(options.myLocationBackgroundDrawable) : options.myLocationBackgroundDrawable != null) {
            return false;
        }
        if (!Arrays.equals(this.myLocationBackgroundPadding, options.myLocationBackgroundPadding)) {
            return false;
        }
        if (this.style != null ? !this.style.equals(options.style) : options.style != null) {
            return false;
        }
        if (this.apiBaseUrl != null ? !this.apiBaseUrl.equals(options.apiBaseUrl) : options.apiBaseUrl != null) {
            return false;
        }
        if (this.prefetchesTiles != options.prefetchesTiles) {
            return false;
        }
        if (this.zMediaOverlay != options.zMediaOverlay) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = this.cameraPosition != null ? this.cameraPosition.hashCode() : 0;
        result = 31 * result + (this.debugActive ? 1 : 0);
        result = 31 * result + (this.compassEnabled ? 1 : 0);
        result = 31 * result + (this.fadeCompassFacingNorth ? 1 : 0);
        result = 31 * result + this.compassGravity;
        result = 31 * result + (this.compassImage != null ? this.compassImage.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.compassMargins);
        result = 31 * result + (this.logoEnabled ? 1 : 0);
        result = 31 * result + this.logoGravity;
        result = 31 * result + Arrays.hashCode(this.logoMargins);
        result = 31 * result + this.attributionTintColor;
        result = 31 * result + (this.attributionEnabled ? 1 : 0);
        result = 31 * result + this.attributionGravity;
        result = 31 * result + Arrays.hashCode(this.attributionMargins);
        long temp = Double.doubleToLongBits(this.minZoom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxZoom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.rotateGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.scrollGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.tiltGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.zoomGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.zoomControlsEnabled ? 1 : 0);
        result = 31 * result + (this.doubleTapGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.myLocationEnabled ? 1 : 0);
        result = 31 * result + (this.myLocationForegroundDrawable != null ? this.myLocationForegroundDrawable.hashCode() : 0);
        result = 31 * result + (this.myLocationForegroundBearingDrawable != null ? this.myLocationForegroundBearingDrawable.hashCode() : 0);
        result = 31 * result + (this.myLocationBackgroundDrawable != null ? this.myLocationBackgroundDrawable.hashCode() : 0);
        result = 31 * result + this.myLocationForegroundTintColor;
        result = 31 * result + this.myLocationBackgroundTintColor;
        result = 31 * result + Arrays.hashCode(this.myLocationBackgroundPadding);
        result = 31 * result + this.myLocationAccuracyTintColor;
        result = 31 * result + this.myLocationAccuracyAlpha;
        result = 31 * result + (this.myLocationAccuracyThreshold != 0.0f ? Float.floatToIntBits(this.myLocationAccuracyThreshold) : 0);
        result = 31 * result + (this.apiBaseUrl != null ? this.apiBaseUrl.hashCode() : 0);
        result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
        result = 31 * result + (this.prefetchesTiles ? 1 : 0);
        result = 31 * result + (this.zMediaOverlay ? 1 : 0);
        return result;
    }
}

