/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.util.ArrayList;
import java.util.List;

class CameraChangeDispatcher
implements MapboxMap.OnCameraMoveStartedListener,
MapboxMap.OnCameraMoveListener,
MapboxMap.OnCameraMoveCanceledListener,
MapboxMap.OnCameraIdleListener {
    private boolean idle = true;
    private final List<MapboxMap.OnCameraMoveStartedListener> onCameraMoveStartedListenerList = new ArrayList<MapboxMap.OnCameraMoveStartedListener>();
    private final List<MapboxMap.OnCameraMoveCanceledListener> onCameraMoveCanceledListenerList = new ArrayList<MapboxMap.OnCameraMoveCanceledListener>();
    private final List<MapboxMap.OnCameraMoveListener> onCameraMoveListenerList = new ArrayList<MapboxMap.OnCameraMoveListener>();
    private final List<MapboxMap.OnCameraIdleListener> onCameraIdleListenerList = new ArrayList<MapboxMap.OnCameraIdleListener>();
    private MapboxMap.OnCameraMoveStartedListener onCameraMoveStartedListener;
    private MapboxMap.OnCameraMoveCanceledListener onCameraMoveCanceledListener;
    private MapboxMap.OnCameraMoveListener onCameraMoveListener;
    private MapboxMap.OnCameraIdleListener onCameraIdleListener;

    CameraChangeDispatcher() {
    }

    void setOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener onCameraMoveStartedListener) {
        this.onCameraMoveStartedListener = onCameraMoveStartedListener;
    }

    void setOnCameraMoveCanceledListener(MapboxMap.OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        this.onCameraMoveCanceledListener = onCameraMoveCanceledListener;
    }

    void setOnCameraMoveListener(MapboxMap.OnCameraMoveListener onCameraMoveListener) {
        this.onCameraMoveListener = onCameraMoveListener;
    }

    void setOnCameraIdleListener(MapboxMap.OnCameraIdleListener onCameraIdleListener) {
        this.onCameraIdleListener = onCameraIdleListener;
    }

    @Override
    public void onCameraMoveStarted(int reason) {
        if (!this.idle) {
            return;
        }
        this.idle = false;
        if (this.onCameraMoveStartedListener != null) {
            this.onCameraMoveStartedListener.onCameraMoveStarted(reason);
        }
        if (!this.onCameraMoveStartedListenerList.isEmpty()) {
            for (MapboxMap.OnCameraMoveStartedListener cameraMoveStartedListener : this.onCameraMoveStartedListenerList) {
                cameraMoveStartedListener.onCameraMoveStarted(reason);
            }
        }
    }

    @Override
    public void onCameraMove() {
        if (this.onCameraMoveListener != null && !this.idle) {
            this.onCameraMoveListener.onCameraMove();
        }
        if (!this.onCameraMoveListenerList.isEmpty()) {
            for (MapboxMap.OnCameraMoveListener cameraMoveListener : this.onCameraMoveListenerList) {
                cameraMoveListener.onCameraMove();
            }
        }
    }

    @Override
    public void onCameraMoveCanceled() {
        if (this.onCameraMoveCanceledListener != null && !this.idle) {
            this.onCameraMoveCanceledListener.onCameraMoveCanceled();
        }
        if (!this.onCameraMoveCanceledListenerList.isEmpty()) {
            for (MapboxMap.OnCameraMoveCanceledListener cameraMoveCanceledListener : this.onCameraMoveCanceledListenerList) {
                cameraMoveCanceledListener.onCameraMoveCanceled();
            }
        }
    }

    @Override
    public void onCameraIdle() {
        if (!this.idle) {
            this.idle = true;
            if (this.onCameraIdleListener != null) {
                this.onCameraIdleListener.onCameraIdle();
            }
            if (!this.onCameraIdleListenerList.isEmpty()) {
                for (MapboxMap.OnCameraIdleListener cameraIdleListener : this.onCameraIdleListenerList) {
                    cameraIdleListener.onCameraIdle();
                }
            }
        }
    }

    void addOnCameraIdleListener(@NonNull MapboxMap.OnCameraIdleListener listener) {
        this.onCameraIdleListenerList.add(listener);
    }

    void removeOnCameraIdleListener(@NonNull MapboxMap.OnCameraIdleListener listener) {
        if (this.onCameraIdleListenerList.contains(listener)) {
            this.onCameraIdleListenerList.remove(listener);
        }
    }

    void addOnCameraMoveCancelListener(MapboxMap.OnCameraMoveCanceledListener listener) {
        this.onCameraMoveCanceledListenerList.add(listener);
    }

    void removeOnCameraMoveCancelListener(MapboxMap.OnCameraMoveCanceledListener listener) {
        if (this.onCameraMoveCanceledListenerList.contains(listener)) {
            this.onCameraMoveCanceledListenerList.remove(listener);
        }
    }

    void addOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener listener) {
        this.onCameraMoveStartedListenerList.add(listener);
    }

    void removeOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener listener) {
        if (this.onCameraMoveStartedListenerList.contains(listener)) {
            this.onCameraMoveStartedListenerList.remove(listener);
        }
    }

    void addOnCameraMoveListener(MapboxMap.OnCameraMoveListener listener) {
        this.onCameraMoveListenerList.add(listener);
    }

    void removeOnCameraMoveListener(MapboxMap.OnCameraMoveListener listener) {
        if (this.onCameraMoveListenerList.contains(listener)) {
            this.onCameraMoveListenerList.remove(listener);
        }
    }
}

