/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.functions;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.style.functions.CameraFunction;
import com.mapbox.mapboxsdk.style.functions.CompositeFunction;
import com.mapbox.mapboxsdk.style.functions.SourceFunction;
import com.mapbox.mapboxsdk.style.functions.stops.CategoricalStops;
import com.mapbox.mapboxsdk.style.functions.stops.ExponentialStops;
import com.mapbox.mapboxsdk.style.functions.stops.IdentityStops;
import com.mapbox.mapboxsdk.style.functions.stops.IntervalStops;
import com.mapbox.mapboxsdk.style.functions.stops.Stop;
import com.mapbox.mapboxsdk.style.functions.stops.Stops;
import java.util.Map;
import timber.log.Timber;

public class Function<I, O> {
    static final String PROPERTY_KEY = "property";
    static final String DEFAULT_VALUE_KEY = "default";
    private final Stops<I, O> stops;

    public static <Z extends Number, O> CameraFunction<Z, O> zoom(@NonNull ExponentialStops<Z, O> stops) {
        return new CameraFunction<Z, O>(stops);
    }

    public static <Z extends Number, O> CameraFunction<Z, O> zoom(@NonNull IntervalStops<Z, O> stops) {
        return new CameraFunction<Z, O>(stops);
    }

    public static <I, O> SourceFunction<I, O> property(@NonNull String property, @NonNull ExponentialStops<I, O> stops) {
        return new SourceFunction<I, O>(property, stops);
    }

    public static <T> SourceFunction<T, T> property(@NonNull String property, @NonNull IdentityStops<T> stops) {
        return new SourceFunction(property, stops);
    }

    public static <I, O> SourceFunction<I, O> property(@NonNull String property, @NonNull IntervalStops<I, O> stops) {
        return new SourceFunction<I, O>(property, stops);
    }

    public static <I, O> SourceFunction<I, O> property(@NonNull String property, @NonNull CategoricalStops<I, O> stops) {
        return new SourceFunction<I, O>(property, stops);
    }

    public static <Z extends Number, I, O> CompositeFunction<Z, I, O> composite(@NonNull String property, @NonNull CategoricalStops<Stop.CompositeValue<Z, I>, O> stops) {
        return new CompositeFunction<Z, I, O>(property, stops);
    }

    public static <Z extends Number, I, O> CompositeFunction<Z, I, O> composite(@NonNull String property, @NonNull ExponentialStops<Stop.CompositeValue<Z, I>, O> stops) {
        return new CompositeFunction<Z, I, O>(property, stops);
    }

    public static <Z extends Number, I, O> CompositeFunction<Z, I, O> composite(@NonNull String property, @NonNull IntervalStops<Stop.CompositeValue<Z, I>, O> stops) {
        return new CompositeFunction<Z, I, O>(property, stops);
    }

    Function(@NonNull Stops<I, O> stops) {
        this.stops = stops;
    }

    public Stops getStops() {
        return this.stops;
    }

    @Nullable
    public <S extends Stops> S getStopsAs() {
        try {
            return (S)this.stops;
        }
        catch (ClassCastException exception) {
            Timber.e((String)String.format("Stops: %s is a different type: %s", this.stops.getClass(), exception), (Object[])new Object[0]);
            return null;
        }
    }

    public Map<String, Object> toValueObject() {
        return this.stops.toValueObject();
    }

    public String toString() {
        return String.format("%s: %s", this.getClass().getSimpleName(), this.stops);
    }
}

