/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.text.TextUtils;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.MapboxConfigurationException;
import com.mapbox.mapboxsdk.location.LocationSource;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.services.android.telemetry.MapboxTelemetry;
import com.mapbox.services.android.telemetry.location.LocationEngine;
import timber.log.Timber;

public final class Mapbox {
    private static Mapbox INSTANCE;
    private Context context;
    private String accessToken;
    private Boolean connected;
    private LocationSource locationSource;

    @UiThread
    public static synchronized Mapbox getInstance(@NonNull Context context, @NonNull String accessToken) {
        if (INSTANCE == null) {
            Context appContext = context.getApplicationContext();
            INSTANCE = new Mapbox(appContext, accessToken, new LocationSource(appContext));
            LocationSource locationEngine = new LocationSource(appContext);
            locationEngine.setPriority(0);
            try {
                MapboxTelemetry.getInstance().initialize(appContext, accessToken, "MapboxEventsAndroid/5.1.2", (LocationEngine)locationEngine);
            }
            catch (Exception exception) {
                Timber.e((Throwable)exception, (String)"Unable to instantiate Mapbox telemetry", (Object[])new Object[0]);
            }
            ConnectivityReceiver.instance(appContext);
        }
        return INSTANCE;
    }

    Mapbox(@NonNull Context context, @NonNull String accessToken, LocationSource locationSource) {
        this.context = context;
        this.accessToken = accessToken;
        this.locationSource = locationSource;
    }

    public static String getAccessToken() {
        Mapbox.validateMapbox();
        Mapbox.validateAccessToken();
        return Mapbox.INSTANCE.accessToken;
    }

    private static void validateMapbox() throws MapboxConfigurationException {
        if (INSTANCE == null) {
            throw new MapboxConfigurationException();
        }
    }

    private static void validateAccessToken() throws MapboxConfigurationException {
        String accessToken = Mapbox.INSTANCE.accessToken;
        if (TextUtils.isEmpty((CharSequence)accessToken) || !accessToken.toLowerCase(MapboxConstants.MAPBOX_LOCALE).startsWith("pk.") && !accessToken.toLowerCase(MapboxConstants.MAPBOX_LOCALE).startsWith("sk.")) {
            throw new MapboxConfigurationException();
        }
    }

    public static Context getApplicationContext() {
        return Mapbox.INSTANCE.context;
    }

    public static synchronized void setConnected(Boolean connected) {
        Mapbox.INSTANCE.connected = connected;
    }

    public static synchronized Boolean isConnected() {
        if (Mapbox.INSTANCE.connected != null) {
            return Mapbox.INSTANCE.connected;
        }
        ConnectivityManager cm = (ConnectivityManager)Mapbox.INSTANCE.context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    public static LocationSource getLocationSource() {
        return Mapbox.INSTANCE.locationSource;
    }
}

