/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mapbox.mapboxsdk.annotations.InfoWindow;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.util.ArrayList;
import java.util.List;

class InfoWindowManager {
    private List<InfoWindow> infoWindows = new ArrayList<InfoWindow>();
    private MapboxMap.InfoWindowAdapter infoWindowAdapter;
    private boolean allowConcurrentMultipleInfoWindows;
    private MapboxMap.OnInfoWindowClickListener onInfoWindowClickListener;
    private MapboxMap.OnInfoWindowLongClickListener onInfoWindowLongClickListener;
    private MapboxMap.OnInfoWindowCloseListener onInfoWindowCloseListener;

    InfoWindowManager() {
    }

    void update() {
        for (InfoWindow infoWindow : this.infoWindows) {
            infoWindow.update();
        }
    }

    void setInfoWindowAdapter(@Nullable MapboxMap.InfoWindowAdapter infoWindowAdapter) {
        this.infoWindowAdapter = infoWindowAdapter;
    }

    MapboxMap.InfoWindowAdapter getInfoWindowAdapter() {
        return this.infoWindowAdapter;
    }

    void setAllowConcurrentMultipleOpenInfoWindows(boolean allow) {
        this.allowConcurrentMultipleInfoWindows = allow;
    }

    boolean isAllowConcurrentMultipleOpenInfoWindows() {
        return this.allowConcurrentMultipleInfoWindows;
    }

    List<InfoWindow> getInfoWindows() {
        return this.infoWindows;
    }

    boolean isInfoWindowValidForMarker(@NonNull Marker marker) {
        return !TextUtils.isEmpty((CharSequence)marker.getTitle()) || !TextUtils.isEmpty((CharSequence)marker.getSnippet());
    }

    void setOnInfoWindowClickListener(@Nullable MapboxMap.OnInfoWindowClickListener listener) {
        this.onInfoWindowClickListener = listener;
    }

    MapboxMap.OnInfoWindowClickListener getOnInfoWindowClickListener() {
        return this.onInfoWindowClickListener;
    }

    void setOnInfoWindowLongClickListener(@Nullable MapboxMap.OnInfoWindowLongClickListener listener) {
        this.onInfoWindowLongClickListener = listener;
    }

    MapboxMap.OnInfoWindowLongClickListener getOnInfoWindowLongClickListener() {
        return this.onInfoWindowLongClickListener;
    }

    void setOnInfoWindowCloseListener(@Nullable MapboxMap.OnInfoWindowCloseListener listener) {
        this.onInfoWindowCloseListener = listener;
    }

    MapboxMap.OnInfoWindowCloseListener getOnInfoWindowCloseListener() {
        return this.onInfoWindowCloseListener;
    }

    public void add(InfoWindow infoWindow) {
        this.infoWindows.add(infoWindow);
    }
}

