/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.Bitmap;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.IconFactory;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.exceptions.IconBitmapChangedException;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import java.util.ArrayList;
import java.util.List;

class IconManager {
    private NativeMapView nativeMapView;
    private List<Icon> icons;
    private int averageIconHeight;
    private int averageIconWidth;

    IconManager(NativeMapView nativeMapView) {
        this.nativeMapView = nativeMapView;
        this.icons = new ArrayList<Icon>();
        this.loadIcon(IconFactory.recreate("com.mapbox.icons.icon_marker_view", IconFactory.ICON_MARKERVIEW_BITMAP));
    }

    Icon loadIconForMarker(Marker marker) {
        Icon icon = marker.getIcon();
        if (icon == null) {
            icon = this.loadDefaultIconForMarker(marker);
        } else {
            this.updateAverageIconSize(icon);
        }
        this.addIcon(icon);
        return icon;
    }

    void loadIconForMarkerView(MarkerView marker) {
        Icon icon = marker.getIcon();
        Bitmap bitmap = icon.getBitmap();
        this.updateAverageIconSize(bitmap);
        this.addIcon(icon, false);
    }

    int getTopOffsetPixelsForIcon(Icon icon) {
        return (int)(this.nativeMapView.getTopOffsetPixelsForAnnotationSymbol(icon.getId()) * (double)this.nativeMapView.getPixelRatio());
    }

    int getAverageIconHeight() {
        return this.averageIconHeight;
    }

    int getAverageIconWidth() {
        return this.averageIconWidth;
    }

    private Icon loadDefaultIconForMarker(Marker marker) {
        Icon icon = IconFactory.getInstance(Mapbox.getApplicationContext()).defaultMarker();
        Bitmap bitmap = icon.getBitmap();
        this.updateAverageIconSize(bitmap.getWidth(), bitmap.getHeight() / 2);
        marker.setIcon(icon);
        return icon;
    }

    private void addIcon(Icon icon) {
        this.addIcon(icon, true);
    }

    private void addIcon(Icon icon, boolean addIconToMap) {
        if (!this.icons.contains(icon)) {
            this.icons.add(icon);
            if (addIconToMap) {
                this.loadIcon(icon);
            }
        } else {
            this.validateIconChanged(icon);
        }
    }

    private void updateAverageIconSize(Icon icon) {
        this.updateAverageIconSize(icon.getBitmap());
    }

    private void updateAverageIconSize(Bitmap bitmap) {
        this.updateAverageIconSize(bitmap.getWidth(), bitmap.getHeight());
    }

    private void updateAverageIconSize(int width, int height) {
        int iconSize = this.icons.size() + 1;
        this.averageIconHeight += (height - this.averageIconHeight) / iconSize;
        this.averageIconWidth += (width - this.averageIconWidth) / iconSize;
    }

    private void loadIcon(Icon icon) {
        Bitmap bitmap = icon.getBitmap();
        this.nativeMapView.addAnnotationIcon(icon.getId(), bitmap.getWidth(), bitmap.getHeight(), icon.getScale(), icon.toBytes());
    }

    void reloadIcons() {
        for (Icon icon : this.icons) {
            this.loadIcon(icon);
        }
    }

    private void validateIconChanged(Icon icon) {
        Icon oldIcon = this.icons.get(this.icons.indexOf(icon));
        if (!oldIcon.getBitmap().sameAs(icon.getBitmap())) {
            throw new IconBitmapChangedException();
        }
    }

    void ensureIconLoaded(Marker marker, MapboxMap mapboxMap) {
        Icon icon = marker.getIcon();
        if (icon == null) {
            icon = this.loadDefaultIconForMarker(marker);
        }
        this.addIcon(icon);
        this.setTopOffsetPixels(marker, mapboxMap, icon);
    }

    private void setTopOffsetPixels(Marker marker, MapboxMap mapboxMap, Icon icon) {
        Marker previousMarker;
        Marker marker2 = previousMarker = marker.getId() != -1L ? (Marker)mapboxMap.getAnnotation(marker.getId()) : null;
        if (previousMarker == null || previousMarker.getIcon() == null || previousMarker.getIcon() != marker.getIcon()) {
            marker.setTopOffsetPixels(this.getTopOffsetPixelsForIcon(icon));
        }
    }
}

