/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ZoomButtonsController;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.AttributionDialogManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.MapGestureDetector;
import com.mapbox.mapboxsdk.maps.MapKeyListener;
import com.mapbox.mapboxsdk.maps.MapZoomButtonController;
import com.mapbox.mapboxsdk.maps.MapboxEventWrapper;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.TrackingSettings;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.maps.widgets.CompassView;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationView;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationViewSettings;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.services.android.telemetry.MapboxTelemetry;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MapView
extends FrameLayout {
    private NativeMapView nativeMapView;
    private boolean textureMode;
    private boolean destroyed;
    private boolean hasSurface;
    private MapboxMap mapboxMap;
    private MapCallback mapCallback;
    private MapGestureDetector mapGestureDetector;
    private MapKeyListener mapKeyListener;
    private MapZoomButtonController mapZoomButtonController;
    public static final int REGION_WILL_CHANGE = 0;
    public static final int REGION_WILL_CHANGE_ANIMATED = 1;
    public static final int REGION_IS_CHANGING = 2;
    public static final int REGION_DID_CHANGE = 3;
    public static final int REGION_DID_CHANGE_ANIMATED = 4;
    public static final int WILL_START_LOADING_MAP = 5;
    public static final int DID_FINISH_LOADING_MAP = 6;
    public static final int DID_FAIL_LOADING_MAP = 7;
    public static final int WILL_START_RENDERING_FRAME = 8;
    public static final int DID_FINISH_RENDERING_FRAME = 9;
    public static final int DID_FINISH_RENDERING_FRAME_FULLY_RENDERED = 10;
    public static final int WILL_START_RENDERING_MAP = 11;
    public static final int DID_FINISH_RENDERING_MAP = 12;
    public static final int DID_FINISH_RENDERING_MAP_FULLY_RENDERED = 13;
    public static final int DID_FINISH_LOADING_STYLE = 14;
    public static final int SOURCE_DID_CHANGE = 15;

    @UiThread
    public MapView(@NonNull Context context) {
        super(context);
        this.initialise(context, MapboxMapOptions.createFromAttributes(context, null));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialise(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialise(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable MapboxMapOptions options) {
        super(context);
        this.initialise(context, options == null ? MapboxMapOptions.createFromAttributes(context, null) : options);
    }

    private void initialise(@NonNull Context context, @NonNull MapboxMapOptions options) {
        if (this.isInEditMode()) {
            LayoutInflater.from((Context)context).inflate(R.layout.mapbox_mapview_preview, (ViewGroup)this);
            return;
        }
        this.textureMode = options.getTextureMode();
        View view = LayoutInflater.from((Context)context).inflate(R.layout.mapbox_mapview_internal, (ViewGroup)this);
        CompassView compassView = (CompassView)view.findViewById(R.id.compassView);
        MyLocationView myLocationView = (MyLocationView)view.findViewById(R.id.userLocationView);
        ImageView attrView = (ImageView)view.findViewById(R.id.attributionView);
        this.setContentDescription(context.getString(R.string.mapbox_mapActionDescription));
        this.nativeMapView = new NativeMapView(this);
        FocalPointInvalidator focalPoint = new FocalPointInvalidator(compassView);
        RegisterTouchListener registerTouchListener = new RegisterTouchListener();
        CameraZoomInvalidator zoomInvalidator = new CameraZoomInvalidator();
        CameraChangeDispatcher cameraChangeDispatcher = new CameraChangeDispatcher();
        Projection proj = new Projection(this.nativeMapView);
        UiSettings uiSettings = new UiSettings(proj, focalPoint, compassView, attrView, view.findViewById(R.id.logoView));
        TrackingSettings trackingSettings = new TrackingSettings(myLocationView, uiSettings, focalPoint, zoomInvalidator);
        MyLocationViewSettings myLocationViewSettings = new MyLocationViewSettings(myLocationView, proj, focalPoint);
        MarkerViewManager markerViewManager = new MarkerViewManager((ViewGroup)this.findViewById(R.id.markerViewContainer));
        AnnotationManager annotations = new AnnotationManager(this.nativeMapView, this, markerViewManager);
        Transform transform = new Transform(this.nativeMapView, annotations.getMarkerViewManager(), trackingSettings, cameraChangeDispatcher);
        this.mapboxMap = new MapboxMap(this.nativeMapView, transform, uiSettings, trackingSettings, myLocationViewSettings, proj, registerTouchListener, annotations, cameraChangeDispatcher);
        this.mapGestureDetector = new MapGestureDetector(context, transform, proj, uiSettings, trackingSettings, annotations, cameraChangeDispatcher);
        this.mapKeyListener = new MapKeyListener(transform, trackingSettings, uiSettings);
        MapZoomControllerListener zoomListener = new MapZoomControllerListener(this.mapGestureDetector, uiSettings, transform);
        this.mapZoomButtonController = new MapZoomButtonController((View)this, uiSettings, zoomListener);
        compassView.setMapboxMap(this.mapboxMap);
        myLocationView.setMapboxMap(this.mapboxMap);
        attrView.setOnClickListener((View.OnClickListener)new AttributionDialogManager(context, this.mapboxMap));
        this.setClickable(true);
        this.setLongClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestDisallowInterceptTouchEvent(true);
        this.setWillNotDraw(false);
        this.nativeMapView.setReachability(ConnectivityReceiver.instance(context).isConnected(context));
        this.mapboxMap.initialise(context, options);
    }

    @UiThread
    public void onCreate(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            MapboxTelemetry.getInstance().pushEvent(MapboxEventWrapper.buildMapLoadEvent());
        } else if (savedInstanceState.getBoolean("mapbox_savedState")) {
            this.mapboxMap.onRestoreInstanceState(savedInstanceState);
        }
        this.initialiseDrawingSurface(this.textureMode);
        this.mapCallback = new MapCallback(this.mapboxMap);
        this.addOnMapChangedListener(this.mapCallback);
    }

    private void initialiseDrawingSurface(boolean textureMode) {
        this.nativeMapView.initializeDisplay();
        this.nativeMapView.initializeContext();
        if (textureMode) {
            TextureView textureView = new TextureView(this.getContext());
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)new SurfaceTextureListener());
            this.addView((View)textureView, 0);
        } else {
            SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.surfaceView);
            surfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceCallback());
            surfaceView.setVisibility(0);
        }
    }

    @UiThread
    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putBoolean("mapbox_savedState", true);
        this.mapboxMap.onSaveInstanceState(outState);
    }

    @UiThread
    public void onStart() {
        this.mapboxMap.onStart();
        ConnectivityReceiver.instance(this.getContext()).activate();
    }

    @UiThread
    public void onResume() {
    }

    @UiThread
    public void onPause() {
    }

    @UiThread
    public void onStop() {
        this.mapboxMap.onStop();
        ConnectivityReceiver.instance(this.getContext()).deactivate();
    }

    @UiThread
    public void onDestroy() {
        this.destroyed = true;
        this.nativeMapView.terminateContext();
        this.nativeMapView.terminateDisplay();
        this.nativeMapView.destroySurface();
        this.nativeMapView.destroy();
        this.nativeMapView = null;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.mapZoomButtonController.setVisible(true);
        }
        return this.mapGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.mapKeyListener.onKeyDown(keyCode, event) || super.onKeyDown(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return this.mapKeyListener.onKeyLongPress(keyCode, event) || super.onKeyLongPress(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.mapKeyListener.onKeyUp(keyCode, event) || super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return this.mapKeyListener.onTrackballEvent(event) || super.onTrackballEvent(event);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        return this.mapGestureDetector.onGenericMotionEvent(event) || super.onGenericMotionEvent(event);
    }

    public boolean onHoverEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 7: 
            case 9: {
                this.mapZoomButtonController.setVisible(true);
                return true;
            }
            case 10: {
                this.mapZoomButtonController.setVisible(false);
                return true;
            }
        }
        return false;
    }

    @UiThread
    public void onLowMemory() {
        this.nativeMapView.onLowMemory();
    }

    protected void onFpsChanged(final double fps) {
        final MapboxMap.OnFpsChangedListener listener = this.mapboxMap.getOnFpsChangedListener();
        if (listener != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    listener.onFpsChanged(fps);
                }
            });
        }
    }

    public void setStyleUrl(@NonNull String url) {
        if (this.destroyed) {
            return;
        }
        this.nativeMapView.setStyleUrl(url);
    }

    protected void onInvalidate() {
        this.postInvalidate();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            return;
        }
        if (this.destroyed) {
            return;
        }
        if (!this.hasSurface) {
            return;
        }
        this.nativeMapView.render();
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        if (this.destroyed) {
            return;
        }
        if (!this.isInEditMode()) {
            this.nativeMapView.resizeView(width, height);
        }
    }

    @CallSuper
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mapZoomButtonController != null) {
            this.mapZoomButtonController.setVisible(false);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        if (this.isInEditMode() || this.mapZoomButtonController == null) {
            return;
        }
        this.mapZoomButtonController.setVisible(visibility == 0);
    }

    public void addOnMapChangedListener(@Nullable OnMapChangedListener listener) {
        if (listener != null) {
            this.nativeMapView.addOnMapChangedListener(listener);
        }
    }

    public void removeOnMapChangedListener(@Nullable OnMapChangedListener listener) {
        if (listener != null) {
            this.nativeMapView.removeOnMapChangedListener(listener);
        }
    }

    @UiThread
    public void getMapAsync(OnMapReadyCallback callback) {
        if (!this.mapCallback.isInitialLoad() && callback != null) {
            callback.onMapReady(this.mapboxMap);
        } else if (callback != null) {
            this.mapCallback.addOnMapReadyCallback(callback);
        }
    }

    MapboxMap getMapboxMap() {
        return this.mapboxMap;
    }

    void setMapboxMap(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
    }

    private static class MapCallback
    implements OnMapChangedListener {
        private final MapboxMap mapboxMap;
        private final List<OnMapReadyCallback> onMapReadyCallbackList = new ArrayList<OnMapReadyCallback>();
        private boolean initialLoad = true;

        MapCallback(MapboxMap mapboxMap) {
            this.mapboxMap = mapboxMap;
        }

        @Override
        public void onMapChanged(int change) {
            if (change == 14 && this.initialLoad) {
                this.initialLoad = false;
                new Handler().post(new Runnable(){

                    @Override
                    public void run() {
                        MapCallback.this.mapboxMap.onPreMapReady();
                        MapCallback.this.onMapReady();
                        MapCallback.this.mapboxMap.onPostMapReady();
                    }
                });
            } else if (change == 9 || change == 10) {
                this.mapboxMap.onUpdateFullyRendered();
            } else if (change == 2 || change == 3 || change == 6) {
                this.mapboxMap.onUpdateRegionChange();
            }
        }

        private void onMapReady() {
            if (this.onMapReadyCallbackList.size() > 0) {
                Iterator<OnMapReadyCallback> iterator = this.onMapReadyCallbackList.iterator();
                while (iterator.hasNext()) {
                    OnMapReadyCallback callback = iterator.next();
                    callback.onMapReady(this.mapboxMap);
                    iterator.remove();
                }
            }
        }

        boolean isInitialLoad() {
            return this.initialLoad;
        }

        void addOnMapReadyCallback(OnMapReadyCallback callback) {
            this.onMapReadyCallbackList.add(callback);
        }
    }

    private class CameraZoomInvalidator
    implements TrackingSettings.CameraZoomInvalidator {
        private CameraZoomInvalidator() {
        }

        @Override
        public void zoomTo(double zoomLevel) {
            Transform transform = MapView.this.mapboxMap.getTransform();
            double currentZoomLevel = transform.getCameraPosition().zoom;
            if (currentZoomLevel < zoomLevel) {
                this.setZoom(zoomLevel, MapView.this.mapGestureDetector.getFocalPoint(), transform);
            }
        }

        private void setZoom(double zoomLevel, @Nullable PointF focalPoint, @NonNull Transform transform) {
            if (focalPoint != null) {
                transform.setZoom(zoomLevel, focalPoint);
            } else {
                PointF centerPoint = new PointF((float)(MapView.this.getMeasuredWidth() / 2), (float)(MapView.this.getMeasuredHeight() / 2));
                transform.setZoom(zoomLevel, centerPoint);
            }
        }
    }

    private class MapZoomControllerListener
    implements ZoomButtonsController.OnZoomListener {
        private final MapGestureDetector mapGestureDetector;
        private final UiSettings uiSettings;
        private final Transform transform;

        MapZoomControllerListener(MapGestureDetector detector, UiSettings uiSettings, Transform transform) {
            this.mapGestureDetector = detector;
            this.uiSettings = uiSettings;
            this.transform = transform;
        }

        public void onVisibilityChanged(boolean visible) {
        }

        public void onZoom(boolean zoomIn) {
            if (this.uiSettings.isZoomGesturesEnabled()) {
                this.onZoom(zoomIn, this.mapGestureDetector.getFocalPoint());
            }
        }

        private void onZoom(boolean zoomIn, @Nullable PointF focalPoint) {
            if (focalPoint != null) {
                this.transform.zoom(zoomIn, focalPoint);
            } else {
                PointF centerPoint = new PointF((float)(MapView.this.getMeasuredWidth() / 2), (float)(MapView.this.getMeasuredHeight() / 2));
                this.transform.zoom(zoomIn, centerPoint);
            }
        }
    }

    private class RegisterTouchListener
    implements MapboxMap.OnRegisterTouchListener {
        private RegisterTouchListener() {
        }

        @Override
        public void onRegisterMapClickListener(MapboxMap.OnMapClickListener listener) {
            MapView.this.mapGestureDetector.setOnMapClickListener(listener);
        }

        @Override
        public void onRegisterMapLongClickListener(MapboxMap.OnMapLongClickListener listener) {
            MapView.this.mapGestureDetector.setOnMapLongClickListener(listener);
        }

        @Override
        public void onRegisterScrollListener(MapboxMap.OnScrollListener listener) {
            MapView.this.mapGestureDetector.setOnScrollListener(listener);
        }

        @Override
        public void onRegisterFlingListener(MapboxMap.OnFlingListener listener) {
            MapView.this.mapGestureDetector.setOnFlingListener(listener);
        }
    }

    private class FocalPointInvalidator
    implements FocalPointChangeListener {
        private final FocalPointChangeListener[] focalPointChangeListeners;

        FocalPointInvalidator(FocalPointChangeListener ... listeners) {
            this.focalPointChangeListeners = listeners;
        }

        @Override
        public void onFocalPointChanged(PointF pointF) {
            MapView.this.mapGestureDetector.setFocalPoint(pointF);
            for (FocalPointChangeListener focalPointChangeListener : this.focalPointChangeListeners) {
                focalPointChangeListener.onFocalPointChanged(pointF);
            }
        }
    }

    public static interface OnMapChangedListener {
        public void onMapChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MapChange {
    }

    private class SurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        private Surface surface;

        private SurfaceTextureListener() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            this.surface = new Surface(surface);
            MapView.this.nativeMapView.createSurface(this.surface);
            MapView.this.nativeMapView.resizeFramebuffer(width, height);
            MapView.this.hasSurface = true;
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            MapView.this.hasSurface = false;
            if (MapView.this.nativeMapView != null) {
                MapView.this.nativeMapView.destroySurface();
            }
            this.surface.release();
            return true;
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            if (MapView.this.destroyed) {
                return;
            }
            MapView.this.nativeMapView.resizeFramebuffer(width, height);
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            if (MapView.this.destroyed) {
                return;
            }
            MapView.this.mapboxMap.onUpdateRegionChange();
        }
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private Surface surface;

        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            this.surface = holder.getSurface();
            MapView.this.nativeMapView.createSurface(this.surface);
            MapView.this.hasSurface = true;
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (MapView.this.destroyed) {
                return;
            }
            MapView.this.nativeMapView.resizeFramebuffer(width, height);
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            MapView.this.hasSurface = false;
            if (MapView.this.nativeMapView != null) {
                MapView.this.nativeMapView.destroySurface();
            }
            this.surface.release();
        }
    }
}

