/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.exceptions.ConversionException;
import com.mapbox.mapboxsdk.style.functions.Function;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import timber.log.Timber;

public class PropertyValue<T> {
    public final String name;
    public final T value;

    public PropertyValue(@NonNull String name, T value) {
        this.name = name;
        this.value = value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isFunction() {
        return !this.isNull() && this.value instanceof Function;
    }

    public boolean isValue() {
        return !this.isNull() && !this.isFunction();
    }

    @Nullable
    public Function<?, T> getFunction() {
        if (this.isFunction()) {
            return (Function)this.value;
        }
        Timber.w((String)"not a function, try value", (Object[])new Object[0]);
        return null;
    }

    @Nullable
    public T getValue() {
        if (this.isValue()) {
            return this.value;
        }
        Timber.w((String)"not a value, try function", (Object[])new Object[0]);
        return null;
    }

    @ColorInt
    @Nullable
    public Integer getColorInt() {
        if (!this.isValue() || !(this.value instanceof String)) {
            Timber.e((String)"%s is not a String value and can not be converted to a color it", (Object[])new Object[]{this.name});
            return null;
        }
        try {
            return ColorUtils.rgbaToColor((String)this.value);
        }
        catch (ConversionException ex) {
            Timber.e((String)"%s could not be converted to a Color int: %s", (Object[])new Object[]{this.name, ex.getMessage()});
            return null;
        }
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.value);
    }
}

