/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.offline.OfflineRegionError;
import com.mapbox.mapboxsdk.offline.OfflineRegionStatus;
import com.mapbox.mapboxsdk.storage.FileSource;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class OfflineRegion {
    private long nativePtr;
    private FileSource fileSource;
    private long id;
    private boolean isDeleted;
    private OfflineRegionDefinition definition;
    private byte[] metadata;
    private Handler handler;
    public static final int STATE_INACTIVE = 0;
    public static final int STATE_ACTIVE = 1;
    private int state = 0;
    private boolean deliverInactiveMessages = false;

    public boolean isDeliveringInactiveMessages() {
        return this.deliverInactiveMessages;
    }

    public void setDeliverInactiveMessages(boolean deliverInactiveMessages) {
        this.deliverInactiveMessages = deliverInactiveMessages;
    }

    private boolean deliverMessages() {
        if (this.state == 1) {
            return true;
        }
        return this.isDeliveringInactiveMessages();
    }

    private OfflineRegion(long offlineRegionPtr, FileSource fileSource, long id2, OfflineRegionDefinition definition, byte[] metadata) {
        this.fileSource = fileSource;
        this.id = id2;
        this.definition = definition;
        this.metadata = metadata;
        this.initialize(offlineRegionPtr, fileSource);
    }

    public long getID() {
        return this.id;
    }

    public OfflineRegionDefinition getDefinition() {
        return this.definition;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler(Looper.getMainLooper());
        }
        return this.handler;
    }

    public void setObserver(final @Nullable OfflineRegionObserver observer) {
        this.setOfflineRegionObserver(new OfflineRegionObserver(){

            @Override
            public void onStatusChanged(final OfflineRegionStatus status) {
                if (OfflineRegion.this.deliverMessages()) {
                    OfflineRegion.this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            if (observer != null) {
                                observer.onStatusChanged(status);
                            }
                        }
                    });
                }
            }

            @Override
            public void onError(final OfflineRegionError error) {
                if (OfflineRegion.this.deliverMessages()) {
                    OfflineRegion.this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            if (observer != null) {
                                observer.onError(error);
                            }
                        }
                    });
                }
            }

            @Override
            public void mapboxTileCountLimitExceeded(final long limit) {
                if (OfflineRegion.this.deliverMessages()) {
                    OfflineRegion.this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            if (observer != null) {
                                observer.mapboxTileCountLimitExceeded(limit);
                            }
                        }
                    });
                }
            }
        });
    }

    public void setDownloadState(int state) {
        this.state = state;
        this.setOfflineRegionDownloadState(state);
    }

    public void getStatus(final @NonNull OfflineRegionStatusCallback callback) {
        this.getOfflineRegionStatus(new OfflineRegionStatusCallback(){

            @Override
            public void onStatus(final OfflineRegionStatus status) {
                OfflineRegion.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onStatus(status);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineRegion.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(error);
                    }
                });
            }
        });
    }

    public void delete(final @NonNull OfflineRegionDeleteCallback callback) {
        if (!this.isDeleted) {
            this.deleteOfflineRegion(new OfflineRegionDeleteCallback(){

                @Override
                public void onDelete() {
                    OfflineRegion.this.isDeleted = true;
                    OfflineRegion.this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onDelete();
                            OfflineRegion.this.finalize();
                        }
                    });
                }

                @Override
                public void onError(final String error) {
                    OfflineRegion.this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(error);
                        }
                    });
                }
            });
        }
    }

    public void updateMetadata(@NonNull byte[] bytes, final @NonNull OfflineRegionUpdateMetadataCallback callback) {
        this.updateOfflineRegionMetadata(bytes, new OfflineRegionUpdateMetadataCallback(){

            @Override
            public void onUpdate(final byte[] metadata) {
                OfflineRegion.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineRegion.access$302(OfflineRegion.this, metadata);
                        callback.onUpdate(metadata);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineRegion.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(error);
                    }
                });
            }
        });
    }

    private native void initialize(long var1, FileSource var3);

    protected native void finalize();

    private native void setOfflineRegionObserver(OfflineRegionObserver var1);

    private native void setOfflineRegionDownloadState(int var1);

    private native void getOfflineRegionStatus(OfflineRegionStatusCallback var1);

    private native void deleteOfflineRegion(OfflineRegionDeleteCallback var1);

    private native void updateOfflineRegionMetadata(byte[] var1, OfflineRegionUpdateMetadataCallback var2);

    static /* synthetic */ byte[] access$302(OfflineRegion x0, byte[] x1) {
        x0.metadata = x1;
        return x1;
    }

    static {
        System.loadLibrary("mapbox-gl");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DownloadState {
    }

    public static interface OfflineRegionUpdateMetadataCallback {
        public void onUpdate(byte[] var1);

        public void onError(String var1);
    }

    public static interface OfflineRegionDeleteCallback {
        public void onDelete();

        public void onError(String var1);
    }

    public static interface OfflineRegionStatusCallback {
        public void onStatus(OfflineRegionStatus var1);

        public void onError(String var1);
    }

    public static interface OfflineRegionObserver {
        public void onStatusChanged(OfflineRegionStatus var1);

        public void onError(OfflineRegionError var1);

        public void mapboxTileCountLimitExceeded(long var1);
    }
}

