/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.FeatureCollection;
import com.mapbox.services.commons.geojson.Geometry;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UiThread
public class GeoJsonSource
extends Source {
    public GeoJsonSource(long nativePtr) {
        super(nativePtr);
    }

    public GeoJsonSource(String id) {
        this.initialize(id, null);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList()));
    }

    public GeoJsonSource(String id, GeoJsonOptions options) {
        this.initialize(id, options);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList()));
    }

    public GeoJsonSource(String id, String geoJson) {
        if (geoJson == null || geoJson.startsWith("http")) {
            throw new IllegalArgumentException("Expected a raw json body");
        }
        this.initialize(id, null);
        this.setGeoJson(geoJson);
    }

    public GeoJsonSource(String id, String geoJson, GeoJsonOptions options) {
        if (geoJson == null || geoJson.startsWith("http")) {
            throw new IllegalArgumentException("Expected a raw json body");
        }
        this.initialize(id, options);
        this.setGeoJson(geoJson);
    }

    public GeoJsonSource(String id, URL url) {
        this.initialize(id, null);
        this.nativeSetUrl(url.toExternalForm());
    }

    public GeoJsonSource(String id, URL url, GeoJsonOptions options) {
        this.initialize(id, options);
        this.nativeSetUrl(url.toExternalForm());
    }

    public GeoJsonSource(String id, FeatureCollection features) {
        this.initialize(id, null);
        this.setGeoJson(features);
    }

    public GeoJsonSource(String id, FeatureCollection features, GeoJsonOptions options) {
        this.initialize(id, options);
        this.setGeoJson(features);
    }

    public GeoJsonSource(String id, Feature feature) {
        this.initialize(id, null);
        this.setGeoJson(feature);
    }

    public GeoJsonSource(String id, Feature feature, GeoJsonOptions options) {
        this.initialize(id, options);
        this.setGeoJson(feature);
    }

    public GeoJsonSource(String id, Geometry geometry) {
        this.initialize(id, null);
        this.setGeoJson(geometry);
    }

    public GeoJsonSource(String id, Geometry geometry, GeoJsonOptions options) {
        this.initialize(id, options);
        this.setGeoJson(geometry);
    }

    public void setGeoJson(Feature feature) {
        this.nativeSetFeature(feature);
    }

    public void setGeoJson(Geometry<?> geometry) {
        this.nativeSetGeometry(geometry);
    }

    public void setGeoJson(FeatureCollection features) {
        this.nativeSetFeatureCollection(features);
    }

    public void setGeoJson(String json) {
        this.nativeSetGeoJsonString(json);
    }

    public void setUrl(URL url) {
        this.setUrl(url.toExternalForm());
    }

    public void setUrl(String url) {
        this.nativeSetUrl(url);
    }

    @NonNull
    public List<Feature> querySourceFeatures(@Nullable Filter.Statement filter) {
        Feature[] features = this.querySourceFeatures(filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    protected native void initialize(String var1, Object var2);

    protected native void nativeSetUrl(String var1);

    private native void nativeSetGeoJsonString(String var1);

    private native void nativeSetFeatureCollection(FeatureCollection var1);

    private native void nativeSetFeature(Feature var1);

    private native void nativeSetGeometry(Geometry<?> var1);

    private native Feature[] querySourceFeatures(Object[] var1);

    protected native void finalize() throws Throwable;
}

