/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.functions.stops;

import com.mapbox.mapboxsdk.style.functions.stops.IterableStops;
import com.mapbox.mapboxsdk.style.functions.stops.Stop;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class ExponentialStops<I, O>
extends IterableStops<I, O, Stop<I, O>> {
    private float base;
    private final Stop<I, O>[] stops;

    @SafeVarargs
    public ExponentialStops(Float base, Stop<I, O> ... stops) {
        this.base = base != null ? base.floatValue() : 1.0f;
        this.stops = stops;
    }

    @SafeVarargs
    public ExponentialStops(Stop<I, O> ... stops) {
        this((Float)null, stops);
    }

    public ExponentialStops<I, O> withBase(float base) {
        this.base = base;
        return this;
    }

    public float getBase() {
        return this.base;
    }

    @Override
    public Map<String, Object> toValueObject() {
        Map<String, Object> map = super.toValueObject();
        map.put("base", Float.valueOf(this.base));
        map.put("stops", this.toValueObjects(this.stops));
        return map;
    }

    @Override
    public String getTypeName() {
        return "exponential";
    }

    @Override
    public Iterator<Stop<I, O>> iterator() {
        return Arrays.asList(this.stops).iterator();
    }

    @Override
    public int size() {
        return this.stops.length;
    }
}

