/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.widgets;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.LocationSource;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.services.android.telemetry.location.LocationEngine;
import com.mapbox.services.android.telemetry.location.LocationEngineListener;
import java.lang.ref.WeakReference;

public class MyLocationView
extends View {
    private MyLocationBehavior myLocationBehavior;
    private MapboxMap mapboxMap;
    private Projection projection;
    private float[] projectedCoordinate = new float[2];
    private float projectedX;
    private float projectedY;
    private float contentPaddingX;
    private float contentPaddingY;
    private LatLng latLng;
    private Location location;
    private long locationUpdateTimestamp;
    private float previousDirection;
    private float accuracy;
    private Paint accuracyPaint;
    private ValueAnimator locationChangeAnimator;
    private ValueAnimator accuracyAnimator;
    private ValueAnimator directionAnimator;
    private ValueAnimator.AnimatorUpdateListener invalidateSelfOnUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            MyLocationView.this.invalidate();
        }
    };
    private Drawable foregroundDrawable;
    private Drawable foregroundBearingDrawable;
    private Drawable backgroundDrawable;
    private Rect foregroundBounds;
    private Rect backgroundBounds;
    private int backgroundOffsetLeft;
    private int backgroundOffsetTop;
    private int backgroundOffsetRight;
    private int backgroundOffsetBottom;
    private Matrix matrix;
    private Camera camera;
    private PointF screenLocation;
    private double tilt;
    private double bearing;
    private float magneticHeading;
    private static final int COMPASS_UPDATE_RATE_MS = 500;
    private int myLocationTrackingMode;
    private int myBearingTrackingMode;
    private GpsLocationListener userLocationListener;
    private CompassListener compassListener;

    public MyLocationView(Context context) {
        super(context);
        this.init(context);
    }

    public MyLocationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MyLocationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        if (this.isInEditMode()) {
            return;
        }
        this.setEnabled(false);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.setLayoutParams(lp);
        this.matrix = new Matrix();
        this.camera = new Camera();
        this.camera.setLocation(0.0f, 0.0f, -1000.0f);
        this.accuracyPaint = new Paint();
        this.myLocationBehavior = new MyLocationBehaviorFactory().getBehavioralModel(0);
        this.compassListener = new CompassListener(context);
    }

    public final void setForegroundDrawables(Drawable defaultDrawable, Drawable bearingDrawable) {
        if (defaultDrawable == null) {
            return;
        }
        if (bearingDrawable == null) {
            bearingDrawable = defaultDrawable.getConstantState().newDrawable();
        }
        if (this.backgroundDrawable == null) {
            this.backgroundDrawable = defaultDrawable.getConstantState().newDrawable();
        }
        if (defaultDrawable.getIntrinsicWidth() != bearingDrawable.getIntrinsicWidth() || defaultDrawable.getIntrinsicHeight() != bearingDrawable.getIntrinsicHeight()) {
            throw new RuntimeException("The dimensions from location and bearing drawables should be match");
        }
        this.foregroundDrawable = defaultDrawable;
        this.foregroundBearingDrawable = bearingDrawable;
        this.invalidateBounds();
    }

    public final void setForegroundDrawableTint(@ColorInt int color2) {
        if (this.foregroundDrawable != null) {
            this.foregroundDrawable.mutate().setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        }
        if (this.foregroundBearingDrawable != null) {
            this.foregroundBearingDrawable.mutate().setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        }
        this.invalidate();
    }

    public final void setShadowDrawable(Drawable drawable2) {
        this.setShadowDrawable(drawable2, 0, 0, 0, 0);
    }

    public final void setShadowDrawable(Drawable drawable2, int left, int top, int right, int bottom) {
        if (drawable2 != null) {
            this.backgroundDrawable = drawable2;
        }
        this.backgroundOffsetLeft = left;
        this.backgroundOffsetTop = top;
        this.backgroundOffsetRight = right;
        this.backgroundOffsetBottom = bottom;
        this.invalidateBounds();
    }

    public final void setShadowDrawableTint(@ColorInt int color2) {
        if (this.backgroundDrawable == null) {
            return;
        }
        this.backgroundDrawable.mutate().setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        this.invalidate();
    }

    public final void setAccuracyTint(@ColorInt int color2) {
        int alpha = this.accuracyPaint.getAlpha();
        this.accuracyPaint.setColor(color2);
        this.accuracyPaint.setAlpha(alpha);
        this.invalidate();
    }

    public final void setAccuracyAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.accuracyPaint.setAlpha(alpha);
        this.invalidate();
    }

    private void invalidateBounds() {
        if (this.backgroundDrawable == null || this.foregroundDrawable == null || this.foregroundBearingDrawable == null) {
            return;
        }
        int backgroundWidth = this.backgroundDrawable.getIntrinsicWidth();
        int backgroundHeight = this.backgroundDrawable.getIntrinsicHeight();
        int horizontalOffset = this.backgroundOffsetLeft - this.backgroundOffsetRight;
        int verticalOffset = this.backgroundOffsetTop - this.backgroundOffsetBottom;
        this.backgroundBounds = new Rect(-backgroundWidth / 2 + horizontalOffset, -backgroundHeight / 2 + verticalOffset, backgroundWidth / 2 + horizontalOffset, backgroundHeight / 2 + verticalOffset);
        this.backgroundDrawable.setBounds(this.backgroundBounds);
        int foregroundWidth = this.foregroundDrawable.getIntrinsicWidth();
        int foregroundHeight = this.foregroundDrawable.getIntrinsicHeight();
        this.foregroundBounds = new Rect(-foregroundWidth / 2, -foregroundHeight / 2, foregroundWidth / 2, foregroundHeight / 2);
        this.foregroundDrawable.setBounds(this.foregroundBounds);
        this.foregroundBearingDrawable.setBounds(this.foregroundBounds);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.location == null || this.foregroundBounds == null || this.backgroundBounds == null || this.accuracyAnimator == null || this.screenLocation == null) {
            return;
        }
        PointF pointF = this.screenLocation;
        float metersPerPixel = (float)this.projection.getMetersPerPixelAtLatitude(this.location.getLatitude());
        float accuracyPixels = ((Float)this.accuracyAnimator.getAnimatedValue()).floatValue() / metersPerPixel;
        this.matrix.reset();
        this.projectedCoordinate[0] = 0.0f;
        this.projectedCoordinate[1] = 0.0f;
        this.camera.save();
        this.camera.rotate((float)this.tilt, 0.0f, 0.0f);
        this.camera.getMatrix(this.matrix);
        if (this.myBearingTrackingMode != 0 && this.directionAnimator != null) {
            this.matrix.preRotate(((Float)this.directionAnimator.getAnimatedValue()).floatValue());
        }
        this.matrix.preTranslate(0.0f, this.contentPaddingY);
        this.matrix.postTranslate(pointF.x, pointF.y - this.contentPaddingY);
        canvas.concat(this.matrix);
        this.matrix.mapPoints(this.projectedCoordinate);
        this.projectedX = pointF.x - this.projectedCoordinate[0];
        this.projectedY = pointF.y - this.projectedCoordinate[1];
        this.camera.restore();
        canvas.drawCircle(0.0f, 0.0f, accuracyPixels, this.accuracyPaint);
        if (this.backgroundDrawable != null) {
            this.backgroundDrawable.draw(canvas);
        }
        if (this.myBearingTrackingMode == 0 || !this.compassListener.isSensorAvailable()) {
            if (this.foregroundDrawable != null) {
                this.foregroundDrawable.draw(canvas);
            }
        } else if (this.foregroundBearingDrawable != null && this.foregroundBounds != null) {
            this.foregroundBearingDrawable.draw(canvas);
        }
    }

    public void setTilt(@FloatRange(from=0.0, to=60.0) double tilt) {
        this.tilt = tilt;
        if (this.myLocationTrackingMode == 4) {
            this.mapboxMap.getUiSettings().setFocalPoint(this.getCenter());
        }
        this.invalidate();
    }

    public void setBearing(double bearing) {
        this.bearing = bearing;
        if (this.myLocationTrackingMode == 0) {
            if (this.myBearingTrackingMode == 8) {
                if (this.location != null) {
                    this.setCompass((double)this.location.getBearing() - bearing);
                }
            } else if (this.myBearingTrackingMode == 4 && this.compassListener.isSensorAvailable()) {
                this.setCompass((double)this.magneticHeading - bearing);
            }
        }
    }

    public void setCameraPosition(CameraPosition position) {
        if (position != null) {
            this.setBearing(position.bearing);
            this.setTilt(position.tilt);
        }
    }

    public void onStart() {
        if (this.myBearingTrackingMode == 4 && this.compassListener.isSensorAvailable()) {
            this.compassListener.onResume();
        }
        if (this.isEnabled()) {
            this.toggleGps(true);
        }
    }

    public void onStop() {
        this.compassListener.onPause();
        this.toggleGps(false);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.locationChangeAnimator != null) {
            this.locationChangeAnimator.cancel();
            this.locationChangeAnimator = null;
        }
        if (this.accuracyAnimator != null) {
            this.accuracyAnimator.cancel();
            this.accuracyAnimator = null;
        }
        if (this.directionAnimator != null) {
            this.directionAnimator.cancel();
            this.directionAnimator = null;
        }
        if (this.userLocationListener != null) {
            LocationSource.getLocationEngine(this.getContext()).removeLocationEngineListener((LocationEngineListener)this.userLocationListener);
            this.userLocationListener = null;
        }
    }

    public void update() {
        if (this.isEnabled()) {
            this.myLocationBehavior.invalidate();
        } else {
            this.setVisibility(4);
        }
    }

    public void setMapboxMap(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
        this.projection = mapboxMap.getProjection();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setVisibility(enabled ? 0 : 4);
        this.toggleGps(enabled);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putDouble("tilt", this.tilt);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.tilt = bundle.getDouble("tilt");
            state = bundle.getParcelable("superState");
        }
        super.onRestoreInstanceState(state);
    }

    private void toggleGps(boolean enableGps) {
        LocationEngine locationEngine = LocationSource.getLocationEngine(this.getContext());
        if (enableGps) {
            Location lastLocation = locationEngine.getLastLocation();
            if (lastLocation != null) {
                this.setLocation(lastLocation);
            }
            if (this.userLocationListener == null) {
                this.userLocationListener = new GpsLocationListener(this);
            }
            locationEngine.addLocationEngineListener((LocationEngineListener)this.userLocationListener);
            locationEngine.activate();
        } else {
            this.location = null;
            locationEngine.removeLocationEngineListener((LocationEngineListener)this.userLocationListener);
            locationEngine.deactivate();
        }
        locationEngine.setPriority(3);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        if (location == null) {
            this.location = null;
            return;
        }
        this.location = location;
        this.myLocationBehavior.updateLatLng(location);
    }

    public void setMyBearingTrackingMode(int myBearingTrackingMode) {
        this.myBearingTrackingMode = myBearingTrackingMode;
        if (myBearingTrackingMode == 4 && this.compassListener.isSensorAvailable()) {
            this.compassListener.onResume();
        } else {
            this.compassListener.onPause();
            if (this.myLocationTrackingMode == 4) {
                this.setCompass(0.0);
            } else {
                this.myLocationBehavior.invalidate();
            }
        }
        this.invalidate();
    }

    public void setMyLocationTrackingMode(int myLocationTrackingMode) {
        MyLocationBehaviorFactory factory = new MyLocationBehaviorFactory();
        this.myLocationBehavior = factory.getBehavioralModel(myLocationTrackingMode);
        if (this.location != null) {
            if (myLocationTrackingMode == 4) {
                this.mapboxMap.getTrackingSettings().setDismissTrackingModeForCameraPositionChange(false);
                this.mapboxMap.easeCamera(CameraUpdateFactory.newLatLng(new LatLng(this.location)), 0, false, new MapboxMap.CancelableCallback(){

                    @Override
                    public void onCancel() {
                    }

                    @Override
                    public void onFinish() {
                        MyLocationView.this.mapboxMap.getTrackingSettings().setDismissTrackingModeForCameraPositionChange(true);
                    }
                });
            } else {
                this.latLng = null;
            }
            this.myLocationBehavior.updateLatLng(this.location);
        }
        this.myLocationTrackingMode = myLocationTrackingMode;
        this.invalidate();
    }

    public int getMyLocationTrackingMode() {
        return this.myLocationTrackingMode;
    }

    public int getMyBearingTrackingMode() {
        return this.myBearingTrackingMode;
    }

    private void setCompass(double bearing) {
        this.setCompass(bearing, 0L);
    }

    private void setCompass(double bearing, long duration) {
        float newDir;
        float diff;
        float oldDir = this.previousDirection;
        if (this.directionAnimator != null) {
            oldDir = ((Float)this.directionAnimator.getAnimatedValue()).floatValue();
            this.directionAnimator.end();
            this.directionAnimator = null;
        }
        if ((diff = oldDir - (newDir = (float)bearing)) > 180.0f) {
            newDir += 360.0f;
        } else if (diff < -180.0f) {
            newDir -= 360.0f;
        }
        this.previousDirection = newDir;
        this.directionAnimator = ValueAnimator.ofFloat((float[])new float[]{oldDir, newDir});
        this.directionAnimator.setDuration(duration);
        this.directionAnimator.addUpdateListener(this.invalidateSelfOnUpdateListener);
        this.directionAnimator.start();
    }

    public PointF getCenter() {
        return new PointF(this.getCenterX(), this.getCenterY());
    }

    private float getCenterX() {
        return (this.getX() + (float)this.getMeasuredWidth()) / 2.0f + this.contentPaddingX - this.projectedX;
    }

    private float getCenterY() {
        return (this.getY() + (float)this.getMeasuredHeight()) / 2.0f + this.contentPaddingY - this.projectedY;
    }

    public void setContentPadding(int[] padding) {
        this.contentPaddingX = (padding[0] - padding[2]) / 2;
        this.contentPaddingY = (padding[1] - padding[3]) / 2;
    }

    private class MyLocationShowBehavior
    extends MyLocationBehavior {
        private MyLocationShowBehavior() {
        }

        @Override
        void updateLatLng(@NonNull Location location) {
            super.updateLatLng(location);
            if (MyLocationView.this.latLng == null) {
                MyLocationView.this.latLng = new LatLng(location);
                MyLocationView.this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
            }
            LatLng newLocation = new LatLng(location);
            this.updateAccuracy(location);
            long previousUpdateTimeStamp = MyLocationView.this.locationUpdateTimestamp;
            MyLocationView.this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
            long locationUpdateDuration = (long)((float)(MyLocationView.this.locationUpdateTimestamp - previousUpdateTimeStamp) * 1.2f);
            if (MyLocationView.this.locationChangeAnimator != null) {
                MyLocationView.this.locationChangeAnimator.end();
                MyLocationView.this.locationChangeAnimator = null;
            }
            MyLocationView.this.locationChangeAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            MyLocationView.this.locationChangeAnimator.setDuration(locationUpdateDuration);
            MyLocationView.this.locationChangeAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new MarkerCoordinateAnimatorListener(this, MyLocationView.this.latLng, newLocation));
            MyLocationView.this.locationChangeAnimator.start();
            MyLocationView.this.latLng = newLocation;
        }

        @Override
        void invalidate() {
            if (MyLocationView.this.latLng != null) {
                MyLocationView.this.screenLocation = MyLocationView.this.projection.toScreenLocation(MyLocationView.this.latLng);
            }
            MyLocationView.this.invalidate();
        }
    }

    private class MyLocationTrackingBehavior
    extends MyLocationBehavior {
        private MyLocationTrackingBehavior() {
        }

        @Override
        void updateLatLng(@NonNull Location location) {
            super.updateLatLng(location);
            if (MyLocationView.this.latLng == null) {
                MyLocationView.this.latLng = new LatLng(location);
                MyLocationView.this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
            }
            float previousUpdateTimeStamp = MyLocationView.this.locationUpdateTimestamp;
            MyLocationView.this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
            float animationDuration = previousUpdateTimeStamp == 0.0f ? 0.0f : ((float)MyLocationView.this.locationUpdateTimestamp - previousUpdateTimeStamp) * 1.1f;
            MyLocationView.this.latLng = new LatLng(location);
            CameraPosition.Builder builder = new CameraPosition.Builder().target(MyLocationView.this.latLng);
            if (MyLocationView.this.myBearingTrackingMode == 8) {
                if (location.hasBearing()) {
                    builder.bearing(location.getBearing());
                }
                MyLocationView.this.setCompass(0.0, 500L);
            }
            this.updateAccuracy(location);
            MyLocationView.this.mapboxMap.getTrackingSettings().setDismissTrackingModeForCameraPositionChange(false);
            MyLocationView.this.mapboxMap.easeCamera(CameraUpdateFactory.newCameraPosition(builder.build()), (int)animationDuration, false, new MapboxMap.CancelableCallback(){

                @Override
                public void onCancel() {
                }

                @Override
                public void onFinish() {
                    MyLocationView.this.mapboxMap.getTrackingSettings().setDismissTrackingModeForCameraPositionChange(true);
                }
            });
        }

        @Override
        void invalidate() {
            int[] mapPadding = MyLocationView.this.mapboxMap.getPadding();
            float x = (float)((MyLocationView.this.getWidth() + mapPadding[0] - mapPadding[2]) / 2) + MyLocationView.this.contentPaddingX;
            float y = (float)((MyLocationView.this.getHeight() - mapPadding[3] + mapPadding[1]) / 2) + MyLocationView.this.contentPaddingY;
            MyLocationView.this.screenLocation = new PointF(x, y);
            MyLocationView.this.invalidate();
        }
    }

    private abstract class MyLocationBehavior {
        private MyLocationBehavior() {
        }

        void updateLatLng(@NonNull Location newLocation) {
            MyLocationView.this.location = newLocation;
        }

        void updateLatLng(double lat, double lon) {
            if (MyLocationView.this.latLng != null) {
                MyLocationView.this.latLng.setLatitude(lat);
                MyLocationView.this.latLng.setLongitude(lon);
            }
        }

        void updateAccuracy(@NonNull Location location) {
            if (MyLocationView.this.accuracyAnimator != null && MyLocationView.this.accuracyAnimator.isRunning()) {
                MyLocationView.this.accuracy = ((Float)MyLocationView.this.accuracyAnimator.getAnimatedValue()).floatValue();
                MyLocationView.this.accuracyAnimator.end();
            }
            MyLocationView.this.accuracyAnimator = ValueAnimator.ofFloat((float[])new float[]{MyLocationView.this.accuracy, location.getAccuracy()});
            MyLocationView.this.accuracyAnimator.setDuration(750L);
            MyLocationView.this.accuracyAnimator.start();
            MyLocationView.this.accuracy = location.getAccuracy();
        }

        abstract void invalidate();
    }

    private class MyLocationBehaviorFactory {
        private MyLocationBehaviorFactory() {
        }

        MyLocationBehavior getBehavioralModel(int mode) {
            if (mode == 0) {
                return new MyLocationShowBehavior();
            }
            return new MyLocationTrackingBehavior();
        }
    }

    private class MarkerCoordinateAnimatorListener
    implements ValueAnimator.AnimatorUpdateListener {
        private MyLocationBehavior behavior;
        private double fromLat;
        private double fromLng;
        private double toLat;
        private double toLng;

        private MarkerCoordinateAnimatorListener(MyLocationBehavior myLocationBehavior, LatLng from, LatLng to) {
            this.behavior = myLocationBehavior;
            this.fromLat = from.getLatitude();
            this.fromLng = from.getLongitude();
            this.toLat = to.getLatitude();
            this.toLng = to.getLongitude();
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float frac = animation.getAnimatedFraction();
            double latitude = this.fromLat + (this.toLat - this.fromLat) * (double)frac;
            double longitude = this.fromLng + (this.toLng - this.fromLng) * (double)frac;
            this.behavior.updateLatLng(latitude, longitude);
            MyLocationView.this.update();
        }
    }

    private class CompassListener
    implements SensorEventListener {
        private final SensorManager sensorManager;
        private Sensor rotationVectorSensor;
        float[] matrix = new float[9];
        float[] orientation = new float[3];
        private long compassUpdateNextTimestamp = 0L;

        CompassListener(Context context) {
            this.sensorManager = (SensorManager)context.getSystemService("sensor");
            this.rotationVectorSensor = this.sensorManager.getDefaultSensor(11);
        }

        public void onResume() {
            this.sensorManager.registerListener((SensorEventListener)this, this.rotationVectorSensor, 1);
        }

        public void onPause() {
            this.sensorManager.unregisterListener((SensorEventListener)this, this.rotationVectorSensor);
        }

        public boolean isSensorAvailable() {
            return this.rotationVectorSensor != null;
        }

        public void onSensorChanged(SensorEvent event) {
            long currentTime = SystemClock.elapsedRealtime();
            if (currentTime < this.compassUpdateNextTimestamp) {
                return;
            }
            if (event.sensor.getType() == 11) {
                SensorManager.getRotationMatrixFromVector((float[])this.matrix, (float[])event.values);
                SensorManager.getOrientation((float[])this.matrix, (float[])this.orientation);
                MyLocationView.this.magneticHeading = (float)Math.toDegrees(SensorManager.getOrientation((float[])this.matrix, (float[])this.orientation)[0]);
                if (MyLocationView.this.myLocationTrackingMode == 4) {
                    this.rotateCamera(MyLocationView.this.magneticHeading);
                    MyLocationView.this.setCompass(0.0, 500L);
                } else {
                    MyLocationView.this.setCompass((double)MyLocationView.this.magneticHeading - MyLocationView.this.bearing, 500L);
                }
                this.compassUpdateNextTimestamp = currentTime + 500L;
            }
        }

        private void rotateCamera(float rotation) {
            CameraPosition.Builder builder = new CameraPosition.Builder();
            builder.bearing(rotation);
            MyLocationView.this.mapboxMap.getTrackingSettings().setDismissTrackingModeForCameraPositionChange(false);
            MyLocationView.this.mapboxMap.easeCamera(CameraUpdateFactory.newCameraPosition(builder.build()), 500, false, new MapboxMap.CancelableCallback(){

                @Override
                public void onCancel() {
                }

                @Override
                public void onFinish() {
                    MyLocationView.this.mapboxMap.getTrackingSettings().setDismissTrackingModeForCameraPositionChange(true);
                }
            });
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    private static class GpsLocationListener
    implements LocationEngineListener {
        private WeakReference<MyLocationView> userLocationView;

        GpsLocationListener(MyLocationView myLocationView) {
            this.userLocationView = new WeakReference<MyLocationView>(myLocationView);
        }

        public void onConnected() {
            MyLocationView locationView = (MyLocationView)((Object)this.userLocationView.get());
            if (locationView != null) {
                LocationEngine locationSource = LocationSource.getLocationEngine(locationView.getContext());
                Location location = locationSource.getLastLocation();
                locationView.setLocation(location);
                locationSource.requestLocationUpdates();
            }
        }

        public void onLocationChanged(Location location) {
            MyLocationView locationView = (MyLocationView)((Object)this.userLocationView.get());
            if (locationView != null) {
                locationView.setLocation(location);
            }
        }
    }
}

