/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.maps.CompassViewSettings;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.ViewSettings;

public class UiSettings {
    private MapView mapView;
    private CompassViewSettings compassSettings;
    private ViewSettings logoSettings;
    private ViewSettings attributionSettings;
    private boolean rotateGesturesEnabled = true;
    private boolean rotateGestureChangeAllowed = true;
    private boolean tiltGesturesEnabled = true;
    private boolean tiltGestureChangeAllowed = true;
    private boolean zoomGesturesEnabled = true;
    private boolean zoomGestureChangeAllowed = true;
    private boolean scrollGesturesEnabled = true;
    private boolean scrollGestureChangeAllowed = true;
    private boolean zoomControlsEnabled;
    private boolean deselectMarkersOnTap = true;
    private PointF focalPoint;

    UiSettings(@NonNull MapView mapView) {
        this.mapView = mapView;
        this.compassSettings = new CompassViewSettings();
        this.logoSettings = new ViewSettings();
        this.attributionSettings = new ViewSettings();
    }

    public void setCompassEnabled(boolean compassEnabled) {
        this.compassSettings.setEnabled(compassEnabled);
        this.mapView.setCompassEnabled(compassEnabled);
    }

    public boolean isCompassEnabled() {
        return this.compassSettings.isEnabled();
    }

    @UiThread
    public void setCompassGravity(int gravity) {
        this.compassSettings.setGravity(gravity);
        this.mapView.setCompassGravity(gravity);
    }

    public void setCompassFadeFacingNorth(boolean compassFadeFacingNorth) {
        this.compassSettings.setFadeFacingNorth(compassFadeFacingNorth);
        this.mapView.setCompassFadeFacingNorth(compassFadeFacingNorth);
    }

    public boolean isCompassFadeWhenFacingNorth() {
        return this.compassSettings.isFadeFacingNorth();
    }

    public int getCompassGravity() {
        return this.compassSettings.getGravity();
    }

    @UiThread
    public void setCompassMargins(int left, int top, int right, int bottom) {
        this.compassSettings.setMargins(new int[]{left, top, right, bottom});
        this.mapView.setCompassMargins(left, top, right, bottom);
    }

    public int getCompassMarginLeft() {
        return this.compassSettings.getMargins()[0];
    }

    public int getCompassMarginTop() {
        return this.compassSettings.getMargins()[1];
    }

    public int getCompassMarginRight() {
        return this.compassSettings.getMargins()[2];
    }

    public int getCompassMarginBottom() {
        return this.compassSettings.getMargins()[3];
    }

    public void setLogoEnabled(boolean enabled) {
        this.logoSettings.setEnabled(enabled);
        this.mapView.setLogoEnabled(enabled);
    }

    public boolean isLogoEnabled() {
        return this.logoSettings.isEnabled();
    }

    public void setLogoGravity(int gravity) {
        this.logoSettings.setGravity(gravity);
        this.mapView.setLogoGravity(gravity);
    }

    public int getLogoGravity() {
        return this.logoSettings.getGravity();
    }

    public void setLogoMargins(int left, int top, int right, int bottom) {
        this.logoSettings.setMargins(new int[]{left, top, right, bottom});
        this.mapView.setLogoMargins(left, top, right, bottom);
    }

    public int getLogoMarginLeft() {
        return this.logoSettings.getMargins()[0];
    }

    public int getLogoMarginTop() {
        return this.logoSettings.getMargins()[1];
    }

    public int getLogoMarginRight() {
        return this.logoSettings.getMargins()[2];
    }

    public int getLogoMarginBottom() {
        return this.logoSettings.getMargins()[3];
    }

    public void setAttributionEnabled(boolean enabled) {
        this.attributionSettings.setEnabled(enabled);
        this.mapView.setAttributionEnabled(enabled ? 0 : 8);
    }

    public boolean isAttributionEnabled() {
        return this.attributionSettings.isEnabled();
    }

    public void setAttributionGravity(int gravity) {
        this.attributionSettings.setGravity(gravity);
        this.mapView.setAttributionGravity(gravity);
    }

    public int getAttributionGravity() {
        return this.attributionSettings.getGravity();
    }

    public void setAttributionMargins(int left, int top, int right, int bottom) {
        this.attributionSettings.setMargins(new int[]{left, top, right, bottom});
        this.mapView.setAttributionMargins(left, top, right, bottom);
    }

    public void setAttributionTintColor(@ColorInt int tintColor) {
        this.attributionSettings.setTintColor(tintColor);
        this.mapView.setAtttibutionTintColor(tintColor);
    }

    public int getAttributionTintColor() {
        return this.attributionSettings.getTintColor();
    }

    public int getAttributionMarginLeft() {
        return this.attributionSettings.getMargins()[0];
    }

    public int getAttributionMarginTop() {
        return this.attributionSettings.getMargins()[1];
    }

    public int getAttributionMarginRight() {
        return this.attributionSettings.getMargins()[2];
    }

    public int getAttributionMarginBottom() {
        return this.attributionSettings.getMargins()[3];
    }

    public void setRotateGesturesEnabled(boolean rotateGesturesEnabled) {
        if (this.rotateGestureChangeAllowed) {
            this.rotateGesturesEnabled = rotateGesturesEnabled;
        }
    }

    public boolean isRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    void setRotateGestureChangeAllowed(boolean rotateGestureChangeAllowed) {
        this.rotateGestureChangeAllowed = rotateGestureChangeAllowed;
    }

    boolean isRotateGestureChangeAllowed() {
        return this.rotateGestureChangeAllowed;
    }

    public void setTiltGesturesEnabled(boolean tiltGesturesEnabled) {
        if (this.tiltGestureChangeAllowed) {
            this.tiltGesturesEnabled = tiltGesturesEnabled;
        }
    }

    public boolean isTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    void setTiltGestureChangeAllowed(boolean tiltGestureChangeAllowed) {
        this.tiltGestureChangeAllowed = tiltGestureChangeAllowed;
    }

    boolean isTiltGestureChangeAllowed() {
        return this.tiltGestureChangeAllowed;
    }

    public void setZoomGesturesEnabled(boolean zoomGesturesEnabled) {
        if (this.zoomGestureChangeAllowed) {
            this.zoomGesturesEnabled = zoomGesturesEnabled;
        }
    }

    public boolean isZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    void setZoomGestureChangeAllowed(boolean zoomGestureChangeAllowed) {
        this.zoomGestureChangeAllowed = zoomGestureChangeAllowed;
    }

    boolean isZoomGestureChangeAllowed() {
        return this.zoomGestureChangeAllowed;
    }

    public void setZoomControlsEnabled(boolean zoomControlsEnabled) {
        this.zoomControlsEnabled = zoomControlsEnabled;
    }

    public boolean isZoomControlsEnabled() {
        return this.zoomControlsEnabled;
    }

    public boolean isDeselectMarkersOnTap() {
        return this.deselectMarkersOnTap;
    }

    public void setDeselectMarkersOnTap(boolean deselectMarkersOnTap) {
        this.deselectMarkersOnTap = deselectMarkersOnTap;
    }

    public void setScrollGesturesEnabled(boolean scrollGesturesEnabled) {
        if (this.scrollGestureChangeAllowed) {
            this.scrollGesturesEnabled = scrollGesturesEnabled;
        }
    }

    public boolean isScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    void setScrollGestureChangeAllowed(boolean scrollGestureChangeAllowed) {
        this.scrollGestureChangeAllowed = scrollGestureChangeAllowed;
    }

    boolean isScrollGestureChangeAllowed() {
        return this.scrollGestureChangeAllowed;
    }

    public void setAllGesturesEnabled(boolean enabled) {
        this.setScrollGesturesEnabled(enabled);
        this.setRotateGesturesEnabled(enabled);
        this.setTiltGesturesEnabled(enabled);
        this.setZoomGesturesEnabled(enabled);
    }

    public void setFocalPoint(@Nullable PointF focalPoint) {
        this.focalPoint = focalPoint;
        this.mapView.setFocalPoint(focalPoint);
    }

    public PointF getFocalPoint() {
        return this.focalPoint;
    }

    public float getHeight() {
        return this.mapView.getMeasuredHeight();
    }

    public float getWidth() {
        return this.mapView.getMeasuredWidth();
    }

    public void invalidate() {
        this.mapView.setLogoMargins(this.getLogoMarginLeft(), this.getLogoMarginTop(), this.getLogoMarginRight(), this.getLogoMarginBottom());
        this.mapView.setCompassMargins(this.getCompassMarginLeft(), this.getCompassMarginTop(), this.getCompassMarginRight(), this.getCompassMarginBottom());
        this.mapView.setAttributionMargins(this.getAttributionMarginLeft(), this.getAttributionMarginTop(), this.getAttributionMarginRight(), this.getAttributionMarginBottom());
    }
}

