/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.InvalidAccessTokenException;
import com.mapbox.mapboxsdk.exceptions.MapboxAccountManagerNotStartedException;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.telemetry.MapboxEventManager;

public class MapboxAccountManager {
    private static MapboxAccountManager mapboxAccountManager = null;
    private final String accessToken;
    private final Context applicationContext;
    private Boolean connected = null;

    private MapboxAccountManager(Context applicationContext, String accessToken) {
        this.applicationContext = applicationContext.getApplicationContext();
        this.accessToken = accessToken;
    }

    public static MapboxAccountManager start(Context context, String accessToken) {
        if (mapboxAccountManager == null) {
            mapboxAccountManager = new MapboxAccountManager(context, accessToken);
            MapboxEventManager.getMapboxEventManager().initialize(context, accessToken);
            ConnectivityReceiver.instance(context);
        }
        return mapboxAccountManager;
    }

    public static MapboxAccountManager getInstance() {
        if (mapboxAccountManager == null) {
            throw new MapboxAccountManagerNotStartedException();
        }
        return mapboxAccountManager;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public static void validateAccessToken(String accessToken) throws InvalidAccessTokenException {
        if (TextUtils.isEmpty((CharSequence)accessToken) || !accessToken.toLowerCase(MapboxConstants.MAPBOX_LOCALE).startsWith("pk.") && !accessToken.toLowerCase(MapboxConstants.MAPBOX_LOCALE).startsWith("sk.")) {
            throw new InvalidAccessTokenException();
        }
    }

    public void setConnected(Boolean connected) {
        this.connected = connected;
    }

    public Boolean isConnected() {
        if (this.connected != null) {
            return this.connected;
        }
        ConnectivityManager cm = (ConnectivityManager)this.applicationContext.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    public Context getApplicationContext() {
        return this.applicationContext;
    }
}

