/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.Property;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class CircleLayer
extends Layer {
    public CircleLayer(long nativePtr) {
        super(nativePtr);
    }

    public CircleLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public CircleLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public void setFilter(Filter.Statement filter) {
        this.setFilter(filter.toArray());
    }

    public void setFilter(Object[] filter) {
        this.nativeSetFilter(filter);
    }

    public CircleLayer withFilter(Object[] filter) {
        this.setFilter(filter);
        return this;
    }

    public CircleLayer withFilter(Filter.Statement filter) {
        this.setFilter(filter);
        return this;
    }

    public CircleLayer withProperties(Property<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Float> getCircleRadius() {
        return new PropertyValue<Float>(this.nativeGetCircleRadius());
    }

    public PropertyValue<String> getCircleColor() {
        return new PropertyValue<String>(this.nativeGetCircleColor());
    }

    @ColorInt
    public int getCircleColorAsInt() {
        PropertyValue<String> value = this.getCircleColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("circle-color was set as a Function");
    }

    public PropertyValue<Float> getCircleBlur() {
        return new PropertyValue<Float>(this.nativeGetCircleBlur());
    }

    public PropertyValue<Float> getCircleOpacity() {
        return new PropertyValue<Float>(this.nativeGetCircleOpacity());
    }

    public PropertyValue<Float[]> getCircleTranslate() {
        return new PropertyValue<Float[]>(this.nativeGetCircleTranslate());
    }

    public PropertyValue<String> getCircleTranslateAnchor() {
        return new PropertyValue<String>(this.nativeGetCircleTranslateAnchor());
    }

    public PropertyValue<String> getCirclePitchScale() {
        return new PropertyValue<String>(this.nativeGetCirclePitchScale());
    }

    private native Object nativeGetCircleRadius();

    private native Object nativeGetCircleColor();

    private native Object nativeGetCircleBlur();

    private native Object nativeGetCircleOpacity();

    private native Object nativeGetCircleTranslate();

    private native Object nativeGetCircleTranslateAnchor();

    private native Object nativeGetCirclePitchScale();

    @Override
    protected native void finalize() throws Throwable;
}

