/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.UiSettings;

public class TrackingSettings {
    private MapView mapView;
    private UiSettings uiSettings;
    private boolean dismissLocationTrackingOnGesture = true;
    private boolean dismissBearingTrackingOnGesture = true;
    private int myLocationTrackingMode;
    private int myBearingTrackingMode;

    TrackingSettings(@NonNull MapView mapView, UiSettings uiSettings) {
        this.mapView = mapView;
        this.uiSettings = uiSettings;
    }

    @UiThread
    public void setMyLocationTrackingMode(int myLocationTrackingMode) {
        this.myLocationTrackingMode = myLocationTrackingMode;
        this.mapView.setMyLocationTrackingMode(myLocationTrackingMode);
    }

    @UiThread
    public int getMyLocationTrackingMode() {
        return this.myLocationTrackingMode;
    }

    @UiThread
    public void setMyBearingTrackingMode(int myBearingTrackingMode) {
        this.myBearingTrackingMode = myBearingTrackingMode;
        this.mapView.setMyBearingTrackingMode(myBearingTrackingMode);
    }

    @UiThread
    public int getMyBearingTrackingMode() {
        return this.myBearingTrackingMode;
    }

    @Deprecated
    public boolean isDismissTrackingOnGesture() {
        return this.dismissLocationTrackingOnGesture && this.dismissBearingTrackingOnGesture;
    }

    public boolean isAllDismissTrackingOnGesture() {
        return this.dismissLocationTrackingOnGesture && this.dismissBearingTrackingOnGesture;
    }

    @Deprecated
    public void setDismissTrackingOnGesture(boolean dismissTrackingOnGesture) {
        this.setDismissAllTrackingOnGesture(dismissTrackingOnGesture);
    }

    public void setDismissAllTrackingOnGesture(boolean dismissTrackingOnGesture) {
        this.dismissLocationTrackingOnGesture = dismissTrackingOnGesture;
        this.dismissBearingTrackingOnGesture = dismissTrackingOnGesture;
    }

    public void setDismissLocationTrackingOnGesture(boolean dismissLocationTrackingOnGesture) {
        this.dismissLocationTrackingOnGesture = dismissLocationTrackingOnGesture;
    }

    public boolean isDismissLocationTrackingOnGesture() {
        return this.dismissLocationTrackingOnGesture;
    }

    public void setDismissBearingTrackingOnGesture(boolean dismissBearingTrackingOnGesture) {
        this.dismissBearingTrackingOnGesture = dismissBearingTrackingOnGesture;
    }

    public boolean isDismissBearingTrackingOnGesture() {
        return this.dismissBearingTrackingOnGesture;
    }

    public boolean isLocationTrackingDisabled() {
        return this.myLocationTrackingMode == 0;
    }

    public boolean isBearingTrackingDisabled() {
        return this.myBearingTrackingMode == 0;
    }

    public boolean isRotateGestureCurrentlyEnabled() {
        return this.uiSettings.isRotateGesturesEnabled() && (this.dismissBearingTrackingOnGesture || this.myBearingTrackingMode == 0 || this.myLocationTrackingMode == 0);
    }

    public boolean isScrollGestureCurrentlyEnabled() {
        return this.uiSettings.isScrollGesturesEnabled() && (this.dismissLocationTrackingOnGesture || this.myLocationTrackingMode == 0);
    }
}

