/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.util.Log;
import com.mapbox.mapboxsdk.MapboxAccountManager;
import com.mapbox.mapboxsdk.net.ConnectivityListener;
import com.mapbox.mapboxsdk.net.NativeConnectivityListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConnectivityReceiver
extends BroadcastReceiver {
    private static final String TAG = ConnectivityReceiver.class.getSimpleName();
    private static ConnectivityReceiver INSTANCE;
    private List<ConnectivityListener> listeners = new CopyOnWriteArrayList<ConnectivityListener>();

    public static synchronized ConnectivityReceiver instance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new ConnectivityReceiver();
            context.registerReceiver((BroadcastReceiver)INSTANCE, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            INSTANCE.addListener(new NativeConnectivityListener());
        }
        return INSTANCE;
    }

    private ConnectivityReceiver() {
    }

    public void onReceive(Context context, Intent intent) {
        boolean connected = this.isConnected(context);
        Log.v((String)TAG, (String)("Connected: " + connected));
        for (ConnectivityListener listener : this.listeners) {
            listener.onNetworkStateChanged(connected);
        }
    }

    public void addListener(@NonNull ConnectivityListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@NonNull ConnectivityListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isConnected(Context context) {
        Boolean connected = MapboxAccountManager.getInstance().isConnected();
        if (connected != null) {
            return connected;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }
}

