/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.Nullable;
import android.util.Log;
import com.mapbox.mapboxsdk.style.layers.Function;

public class PropertyValue<T> {
    private static final String TAG = PropertyValue.class.getSimpleName();
    private final Object value;

    PropertyValue(Object value) {
        this.value = value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isFunction() {
        return !this.isNull() && this.value instanceof Function;
    }

    public boolean isValue() {
        return !this.isNull() && !this.isFunction();
    }

    @Nullable
    public Function<T> getFunction() {
        if (this.isFunction()) {
            return (Function)this.value;
        }
        Log.w((String)TAG, (String)"not a function, try value");
        return null;
    }

    @Nullable
    public T getValue() {
        if (this.isValue()) {
            return (T)this.value;
        }
        Log.w((String)TAG, (String)"not a value, try function");
        return null;
    }

    public String toString() {
        return String.format("%s (%s)", this.getClass().getSimpleName(), this.value != null ? this.value.getClass().getSimpleName() : null);
    }
}

