/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import com.mapbox.mapboxsdk.style.layers.Function;
import com.mapbox.mapboxsdk.style.layers.PaintProperty;
import com.mapbox.mapboxsdk.style.layers.Property;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;

public abstract class Layer {
    private long nativePtr;
    private boolean invalidated;

    public Layer(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public Layer() {
    }

    public void setProperties(Property<?> ... properties) {
        this.checkValidity();
        if (properties.length == 0) {
            return;
        }
        for (Property<?> property : properties) {
            Object converted = this.convertValue(property.value);
            if (property instanceof PaintProperty) {
                this.nativeSetPaintProperty(property.name, converted);
                continue;
            }
            this.nativeSetLayoutProperty(property.name, converted);
        }
    }

    public String getId() {
        this.checkValidity();
        return this.nativeGetId();
    }

    public PropertyValue<String> getVisibility() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetVisibility());
    }

    public float getMinZoom() {
        this.checkValidity();
        return this.nativeGetMinZoom();
    }

    public float getMaxZoom() {
        this.checkValidity();
        return this.nativeGetMaxZoom();
    }

    public void setMinZoom(float zoom) {
        this.checkValidity();
        this.nativeSetMinZoom(zoom);
    }

    public void setMaxZoom(float zoom) {
        this.checkValidity();
        this.nativeSetMaxZoom(zoom);
    }

    protected native void finalize() throws Throwable;

    protected native String nativeGetId();

    protected native Object nativeGetVisibility();

    protected native void nativeSetLayoutProperty(String var1, Object var2);

    protected native void nativeSetPaintProperty(String var1, Object var2);

    protected native void nativeSetFilter(Object[] var1);

    protected native void nativeSetSourceLayer(String var1);

    protected native float nativeGetMinZoom();

    protected native float nativeGetMaxZoom();

    protected native void nativeSetMinZoom(float var1);

    protected native void nativeSetMaxZoom(float var1);

    public long getNativePtr() {
        return this.nativePtr;
    }

    private Object convertValue(Object value) {
        return value != null && value instanceof Function ? ((Function)((Object)value)).toValueObject() : value;
    }

    protected void checkValidity() {
        if (this.invalidated) {
            throw new RuntimeException("Layer has been invalidated. Request a new reference after adding");
        }
    }

    public final void invalidate() {
        this.invalidated = true;
    }
}

