/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.Surface;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.offline.OfflineManager;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.NoSuchLayerException;
import com.mapbox.mapboxsdk.style.sources.NoSuchSourceException;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.commons.geojson.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class NativeMapView {
    boolean destroyed = false;
    private long nativeMapViewPtr = 0L;
    private MapView mapView;
    private final float pixelRatio;

    public NativeMapView(MapView mapView) {
        String dataPath;
        Context context = mapView.getContext();
        String cachePath = dataPath = OfflineManager.getDatabasePath(context);
        this.pixelRatio = context.getResources().getDisplayMetrics().density;
        String apkPath = context.getPackageCodePath();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        activityManager.getMemoryInfo(memoryInfo);
        long totalMemory = memoryInfo.availMem;
        if (Build.VERSION.SDK_INT >= 16) {
            totalMemory = memoryInfo.totalMem;
        }
        if (availableProcessors < 0) {
            throw new IllegalArgumentException("availableProcessors cannot be negative.");
        }
        if (totalMemory < 0L) {
            throw new IllegalArgumentException("totalMemory cannot be negative.");
        }
        this.mapView = mapView;
        this.nativeMapViewPtr = this.nativeCreate(cachePath, dataPath, apkPath, this.pixelRatio, availableProcessors, totalMemory);
    }

    public void destroy() {
        this.nativeDestroy(this.nativeMapViewPtr);
        this.nativeMapViewPtr = 0L;
        this.mapView = null;
        this.destroyed = true;
    }

    public boolean wasDestroyed() {
        return this.destroyed;
    }

    public void initializeDisplay() {
        this.nativeInitializeDisplay(this.nativeMapViewPtr);
    }

    public void terminateDisplay() {
        this.nativeTerminateDisplay(this.nativeMapViewPtr);
    }

    public void initializeContext() {
        this.nativeInitializeContext(this.nativeMapViewPtr);
    }

    public void terminateContext() {
        this.nativeTerminateContext(this.nativeMapViewPtr);
    }

    public void createSurface(Surface surface) {
        this.nativeCreateSurface(this.nativeMapViewPtr, surface);
    }

    public void destroySurface() {
        this.nativeDestroySurface(this.nativeMapViewPtr);
    }

    public void update() {
        this.nativeUpdate(this.nativeMapViewPtr);
    }

    public void render() {
        this.nativeRender(this.nativeMapViewPtr);
    }

    public void resizeView(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be negative.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be negative.");
        }
        if (width > 65535) {
            throw new IllegalArgumentException("width cannot be greater than 65535.");
        }
        if (height > 65535) {
            throw new IllegalArgumentException("height cannot be greater than 65535.");
        }
        this.nativeViewResize(this.nativeMapViewPtr, width, height);
    }

    public void resizeFramebuffer(int fbWidth, int fbHeight) {
        if (fbWidth < 0) {
            throw new IllegalArgumentException("fbWidth cannot be negative.");
        }
        if (fbHeight < 0) {
            throw new IllegalArgumentException("fbHeight cannot be negative.");
        }
        if (fbWidth > 65535) {
            throw new IllegalArgumentException("fbWidth cannot be greater than 65535.");
        }
        if (fbHeight > 65535) {
            throw new IllegalArgumentException("fbHeight cannot be greater than 65535.");
        }
        this.nativeFramebufferResize(this.nativeMapViewPtr, fbWidth, fbHeight);
    }

    public void addClass(String clazz) {
        this.nativeAddClass(this.nativeMapViewPtr, clazz);
    }

    public void removeClass(String clazz) {
        this.nativeRemoveClass(this.nativeMapViewPtr, clazz);
    }

    public boolean hasClass(String clazz) {
        return this.nativeHasClass(this.nativeMapViewPtr, clazz);
    }

    public void setClasses(List<String> classes) {
        this.nativeSetClasses(this.nativeMapViewPtr, classes);
    }

    public List<String> getClasses() {
        return this.nativeGetClasses(this.nativeMapViewPtr);
    }

    public void setStyleUrl(String url) {
        this.nativeSetStyleUrl(this.nativeMapViewPtr, url);
    }

    public void setStyleJson(String newStyleJson) {
        this.nativeSetStyleJson(this.nativeMapViewPtr, newStyleJson);
    }

    public String getStyleJson() {
        return this.nativeGetStyleJson(this.nativeMapViewPtr);
    }

    public void setAccessToken(String accessToken) {
        this.nativeSetAccessToken(this.nativeMapViewPtr, accessToken);
    }

    public String getAccessToken() {
        return this.nativeGetAccessToken(this.nativeMapViewPtr);
    }

    public void cancelTransitions() {
        this.nativeCancelTransitions(this.nativeMapViewPtr);
    }

    public void setGestureInProgress(boolean inProgress) {
        this.nativeSetGestureInProgress(this.nativeMapViewPtr, inProgress);
    }

    public void moveBy(double dx, double dy) {
        this.moveBy(dx, dy, 0L);
    }

    public void moveBy(double dx, double dy, long duration) {
        this.nativeMoveBy(this.nativeMapViewPtr, dx, dy, duration);
    }

    public void setLatLng(LatLng latLng) {
        this.setLatLng(latLng, 0L);
    }

    public void setLatLng(LatLng latLng, long duration) {
        this.nativeSetLatLng(this.nativeMapViewPtr, latLng.getLatitude(), latLng.getLongitude(), duration);
    }

    public LatLng getLatLng() {
        return this.nativeGetLatLng(this.nativeMapViewPtr);
    }

    public void resetPosition() {
        this.nativeResetPosition(this.nativeMapViewPtr);
    }

    public double getPitch() {
        return this.nativeGetPitch(this.nativeMapViewPtr);
    }

    public void setPitch(double pitch, long duration) {
        this.nativeSetPitch(this.nativeMapViewPtr, pitch, duration);
    }

    public void scaleBy(double ds) {
        this.scaleBy(ds, Double.NaN, Double.NaN);
    }

    public void scaleBy(double ds, double cx, double cy) {
        this.scaleBy(ds, cx, cy, 0L);
    }

    public void scaleBy(double ds, double cx, double cy, long duration) {
        this.nativeScaleBy(this.nativeMapViewPtr, ds, cx, cy, duration);
    }

    public void setScale(double scale) {
        this.setScale(scale, Double.NaN, Double.NaN);
    }

    public void setScale(double scale, double cx, double cy) {
        this.setScale(scale, cx, cy, 0L);
    }

    public void setScale(double scale, double cx, double cy, long duration) {
        this.nativeSetScale(this.nativeMapViewPtr, scale, cx, cy, duration);
    }

    public double getScale() {
        return this.nativeGetScale(this.nativeMapViewPtr);
    }

    public void setZoom(double zoom) {
        this.setZoom(zoom, 0L);
    }

    public void setZoom(double zoom, long duration) {
        this.nativeSetZoom(this.nativeMapViewPtr, zoom, duration);
    }

    public double getZoom() {
        return this.nativeGetZoom(this.nativeMapViewPtr);
    }

    public void resetZoom() {
        this.nativeResetZoom(this.nativeMapViewPtr);
    }

    public void setMinZoom(double zoom) {
        this.nativeSetMinZoom(this.nativeMapViewPtr, zoom);
    }

    public double getMinZoom() {
        return this.nativeGetMinZoom(this.nativeMapViewPtr);
    }

    public void setMaxZoom(double zoom) {
        this.nativeSetMaxZoom(this.nativeMapViewPtr, zoom);
    }

    public double getMaxZoom() {
        return this.nativeGetMaxZoom(this.nativeMapViewPtr);
    }

    public void rotateBy(double sx, double sy, double ex, double ey) {
        this.rotateBy(sx, sy, ex, ey, 0L);
    }

    public void rotateBy(double sx, double sy, double ex, double ey, long duration) {
        this.nativeRotateBy(this.nativeMapViewPtr, sx, sy, ex, ey, duration);
    }

    public void setContentPadding(double top, double left, double bottom, double right) {
        this.nativeSetContentPadding(this.nativeMapViewPtr, top, left, bottom, right);
    }

    public void setBearing(double degrees) {
        this.setBearing(degrees, 0L);
    }

    public void setBearing(double degrees, long duration) {
        this.nativeSetBearing(this.nativeMapViewPtr, degrees, duration);
    }

    public void setBearing(double degrees, double cx, double cy) {
        this.nativeSetBearingXY(this.nativeMapViewPtr, degrees, cx, cy);
    }

    public double getBearing() {
        return this.nativeGetBearing(this.nativeMapViewPtr);
    }

    public void resetNorth() {
        this.nativeResetNorth(this.nativeMapViewPtr);
    }

    public long addMarker(Marker marker) {
        Marker[] markers = new Marker[]{marker};
        return this.nativeAddMarkers(this.nativeMapViewPtr, markers)[0];
    }

    public long[] addMarkers(List<Marker> markers) {
        return this.nativeAddMarkers(this.nativeMapViewPtr, markers.toArray(new Marker[markers.size()]));
    }

    public long addPolyline(Polyline polyline) {
        Polyline[] polylines = new Polyline[]{polyline};
        return this.nativeAddPolylines(this.nativeMapViewPtr, polylines)[0];
    }

    public long[] addPolylines(List<Polyline> polylines) {
        return this.nativeAddPolylines(this.nativeMapViewPtr, polylines.toArray(new Polyline[polylines.size()]));
    }

    public long addPolygon(Polygon polygon) {
        Polygon[] polygons = new Polygon[]{polygon};
        return this.nativeAddPolygons(this.nativeMapViewPtr, polygons)[0];
    }

    public long[] addPolygons(List<Polygon> polygons) {
        return this.nativeAddPolygons(this.nativeMapViewPtr, polygons.toArray(new Polygon[polygons.size()]));
    }

    public void updateMarker(Marker marker) {
        LatLng position = marker.getPosition();
        Icon icon = marker.getIcon();
        this.nativeUpdateMarker(this.nativeMapViewPtr, marker.getId(), position.getLatitude(), position.getLongitude(), icon.getId());
    }

    public void updatePolygon(Polygon polygon) {
        this.nativeUpdatePolygon(this.nativeMapViewPtr, polygon.getId(), polygon);
    }

    public void updatePolyline(Polyline polyline) {
        this.nativeUpdatePolyline(this.nativeMapViewPtr, polyline.getId(), polyline);
    }

    public void removeAnnotation(long id2) {
        long[] ids = new long[]{id2};
        this.removeAnnotations(ids);
    }

    public void removeAnnotations(long[] ids) {
        this.nativeRemoveAnnotations(this.nativeMapViewPtr, ids);
    }

    public long[] queryPointAnnotations(RectF rect) {
        return this.nativeQueryPointAnnotations(this.nativeMapViewPtr, rect);
    }

    public void addAnnotationIcon(String symbol, int width, int height, float scale, byte[] pixels) {
        this.nativeAddAnnotationIcon(this.nativeMapViewPtr, symbol, width, height, scale, pixels);
    }

    public void setVisibleCoordinateBounds(LatLng[] coordinates, RectF padding, double direction, long duration) {
        this.nativeSetVisibleCoordinateBounds(this.nativeMapViewPtr, coordinates, padding, direction, duration);
    }

    public void onLowMemory() {
        this.nativeOnLowMemory(this.nativeMapViewPtr);
    }

    public void setDebug(boolean debug) {
        this.nativeSetDebug(this.nativeMapViewPtr, debug);
    }

    public void cycleDebugOptions() {
        this.nativeToggleDebug(this.nativeMapViewPtr);
    }

    public boolean getDebug() {
        return this.nativeGetDebug(this.nativeMapViewPtr);
    }

    public boolean isFullyLoaded() {
        return this.nativeIsFullyLoaded(this.nativeMapViewPtr);
    }

    public void setReachability(boolean status) {
        this.nativeSetReachability(this.nativeMapViewPtr, status);
    }

    public double getMetersPerPixelAtLatitude(double lat, double zoom) {
        return this.nativeGetMetersPerPixelAtLatitude(this.nativeMapViewPtr, lat, zoom);
    }

    public ProjectedMeters projectedMetersForLatLng(LatLng latLng) {
        return this.nativeProjectedMetersForLatLng(this.nativeMapViewPtr, latLng.getLatitude(), latLng.getLongitude());
    }

    public LatLng latLngForProjectedMeters(ProjectedMeters projectedMeters) {
        return this.nativeLatLngForProjectedMeters(this.nativeMapViewPtr, projectedMeters.getNorthing(), projectedMeters.getEasting());
    }

    public PointF pixelForLatLng(LatLng latLng) {
        return this.nativePixelForLatLng(this.nativeMapViewPtr, latLng.getLatitude(), latLng.getLongitude());
    }

    public LatLng latLngForPixel(PointF pixel) {
        return this.nativeLatLngForPixel(this.nativeMapViewPtr, pixel.x, pixel.y);
    }

    public double getTopOffsetPixelsForAnnotationSymbol(String symbolName) {
        return this.nativeGetTopOffsetPixelsForAnnotationSymbol(this.nativeMapViewPtr, symbolName);
    }

    public void jumpTo(double angle, LatLng center, double pitch, double zoom) {
        this.nativeJumpTo(this.nativeMapViewPtr, angle, center.getLatitude(), center.getLongitude(), pitch, zoom);
    }

    public void easeTo(double angle, LatLng center, long duration, double pitch, double zoom, boolean easingInterpolator) {
        this.nativeEaseTo(this.nativeMapViewPtr, angle, center.getLatitude(), center.getLongitude(), duration, pitch, zoom, easingInterpolator);
    }

    public void flyTo(double angle, LatLng center, long duration, double pitch, double zoom) {
        this.nativeFlyTo(this.nativeMapViewPtr, angle, center.getLatitude(), center.getLongitude(), duration, pitch, zoom);
    }

    public double[] getCameraValues() {
        return this.nativeGetCameraValues(this.nativeMapViewPtr);
    }

    public Layer getLayer(String layerId) {
        return this.nativeGetLayer(this.nativeMapViewPtr, layerId);
    }

    public void addLayer(@NonNull Layer layer, @Nullable String before) {
        this.nativeAddLayer(this.nativeMapViewPtr, layer.getNativePtr(), before);
        layer.invalidate();
    }

    public void removeLayer(@NonNull String layerId) throws NoSuchLayerException {
        this.nativeRemoveLayer(this.nativeMapViewPtr, layerId);
    }

    public Source getSource(@NonNull String sourceId) {
        return this.nativeGetSource(this.nativeMapViewPtr, sourceId);
    }

    public void addSource(@NonNull Source source) {
        this.nativeAddSource(this.nativeMapViewPtr, source.getNativePtr());
    }

    public void removeSource(@NonNull String sourceId) throws NoSuchSourceException {
        this.nativeRemoveSource(this.nativeMapViewPtr, sourceId);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(PointF coordinates, String ... layerIds) {
        Feature[] features = this.nativeQueryRenderedFeaturesForPoint(this.nativeMapViewPtr, coordinates.x / this.pixelRatio, coordinates.y / this.pixelRatio, layerIds);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(RectF coordinates, String ... layerIds) {
        Feature[] features = this.nativeQueryRenderedFeaturesForBox(this.nativeMapViewPtr, coordinates.left / this.pixelRatio, coordinates.top / this.pixelRatio, coordinates.right / this.pixelRatio, coordinates.bottom / this.pixelRatio, layerIds);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    public void scheduleTakeSnapshot() {
        this.nativeScheduleTakeSnapshot(this.nativeMapViewPtr);
    }

    public void setApiBaseUrl(String baseUrl) {
        this.nativeSetAPIBaseURL(this.nativeMapViewPtr, baseUrl);
    }

    protected void onInvalidate() {
        this.mapView.onInvalidate();
    }

    protected void onMapChanged(int rawChange) {
        this.mapView.onMapChanged(rawChange);
    }

    protected void onFpsChanged(double fps) {
        this.mapView.onFpsChanged(fps);
    }

    protected void onSnapshotReady(byte[] bytes) {
        this.mapView.onSnapshotReady(bytes);
    }

    private native long nativeCreate(String var1, String var2, String var3, float var4, int var5, long var6);

    private native void nativeDestroy(long var1);

    private native void nativeInitializeDisplay(long var1);

    private native void nativeTerminateDisplay(long var1);

    private native void nativeInitializeContext(long var1);

    private native void nativeTerminateContext(long var1);

    private native void nativeCreateSurface(long var1, Surface var3);

    private native void nativeDestroySurface(long var1);

    private native void nativeUpdate(long var1);

    private native void nativeRender(long var1);

    private native void nativeViewResize(long var1, int var3, int var4);

    private native void nativeFramebufferResize(long var1, int var3, int var4);

    private native void nativeAddClass(long var1, String var3);

    private native void nativeRemoveClass(long var1, String var3);

    private native boolean nativeHasClass(long var1, String var3);

    private native void nativeSetClasses(long var1, List<String> var3);

    private native List<String> nativeGetClasses(long var1);

    private native void nativeSetStyleUrl(long var1, String var3);

    private native void nativeSetStyleJson(long var1, String var3);

    private native String nativeGetStyleJson(long var1);

    private native void nativeSetAccessToken(long var1, String var3);

    private native String nativeGetAccessToken(long var1);

    private native void nativeCancelTransitions(long var1);

    private native void nativeSetGestureInProgress(long var1, boolean var3);

    private native void nativeMoveBy(long var1, double var3, double var5, long var7);

    private native void nativeSetLatLng(long var1, double var3, double var5, long var7);

    private native LatLng nativeGetLatLng(long var1);

    private native void nativeResetPosition(long var1);

    private native double nativeGetPitch(long var1);

    private native void nativeSetPitch(long var1, double var3, long var5);

    private native void nativeScaleBy(long var1, double var3, double var5, double var7, long var9);

    private native void nativeSetScale(long var1, double var3, double var5, double var7, long var9);

    private native double nativeGetScale(long var1);

    private native void nativeSetZoom(long var1, double var3, long var5);

    private native double nativeGetZoom(long var1);

    private native void nativeResetZoom(long var1);

    private native void nativeSetMinZoom(long var1, double var3);

    private native double nativeGetMinZoom(long var1);

    private native void nativeSetMaxZoom(long var1, double var3);

    private native double nativeGetMaxZoom(long var1);

    private native void nativeRotateBy(long var1, double var3, double var5, double var7, double var9, long var11);

    private native void nativeSetContentPadding(long var1, double var3, double var5, double var7, double var9);

    private native void nativeSetBearing(long var1, double var3, long var5);

    private native void nativeSetBearingXY(long var1, double var3, double var5, double var7);

    private native double nativeGetBearing(long var1);

    private native void nativeResetNorth(long var1);

    private native void nativeUpdateMarker(long var1, long var3, double var5, double var7, String var9);

    private native long[] nativeAddMarkers(long var1, Marker[] var3);

    private native long[] nativeAddPolylines(long var1, Polyline[] var3);

    private native long[] nativeAddPolygons(long var1, Polygon[] var3);

    private native void nativeRemoveAnnotations(long var1, long[] var3);

    private native long[] nativeQueryPointAnnotations(long var1, RectF var3);

    private native void nativeAddAnnotationIcon(long var1, String var3, int var4, int var5, float var6, byte[] var7);

    private native void nativeSetVisibleCoordinateBounds(long var1, LatLng[] var3, RectF var4, double var5, long var7);

    private native void nativeOnLowMemory(long var1);

    private native void nativeSetDebug(long var1, boolean var3);

    private native void nativeToggleDebug(long var1);

    private native boolean nativeGetDebug(long var1);

    private native boolean nativeIsFullyLoaded(long var1);

    private native void nativeSetReachability(long var1, boolean var3);

    private native double nativeGetMetersPerPixelAtLatitude(long var1, double var3, double var5);

    private native ProjectedMeters nativeProjectedMetersForLatLng(long var1, double var3, double var5);

    private native LatLng nativeLatLngForProjectedMeters(long var1, double var3, double var5);

    private native PointF nativePixelForLatLng(long var1, double var3, double var5);

    private native LatLng nativeLatLngForPixel(long var1, float var3, float var4);

    private native double nativeGetTopOffsetPixelsForAnnotationSymbol(long var1, String var3);

    private native void nativeJumpTo(long var1, double var3, double var5, double var7, double var9, double var11);

    private native void nativeEaseTo(long var1, double var3, double var5, double var7, long var9, double var11, double var13, boolean var15);

    private native void nativeFlyTo(long var1, double var3, double var5, double var7, long var9, double var11, double var13);

    private native double[] nativeGetCameraValues(long var1);

    private native Layer nativeGetLayer(long var1, String var3);

    private native void nativeAddLayer(long var1, long var3, String var5);

    private native void nativeRemoveLayer(long var1, String var3) throws NoSuchLayerException;

    private native Source nativeGetSource(long var1, String var3);

    private native void nativeAddSource(long var1, long var3);

    private native void nativeRemoveSource(long var1, String var3) throws NoSuchSourceException;

    private native void nativeUpdatePolygon(long var1, long var3, Polygon var5);

    private native void nativeUpdatePolyline(long var1, long var3, Polyline var5);

    private native void nativeScheduleTakeSnapshot(long var1);

    private native Feature[] nativeQueryRenderedFeaturesForPoint(long var1, float var3, float var4, String[] var5);

    private native Feature[] nativeQueryRenderedFeaturesForBox(long var1, float var3, float var4, float var5, float var6, String[] var7);

    private native void nativeSetAPIBaseURL(long var1, String var3);

    static {
        System.loadLibrary("mapbox-gl");
    }
}

