/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.graphics.Bitmap;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.annotations.BaseMarkerViewOptions;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.IconFactory;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;

public class MarkerView
extends Marker {
    private MarkerViewManager markerViewManager;
    private float anchorU;
    private float anchorV;
    private float offsetX = -1.0f;
    private float offsetY = -1.0f;
    private float infoWindowAnchorU;
    private float infoWindowAnchorV;
    private boolean flat;
    private boolean visible = true;
    private float tiltValue;
    private float rotation;
    private float alpha = 1.0f;
    private Icon markerViewIcon;
    private boolean selected;

    MarkerView() {
    }

    public MarkerView(BaseMarkerViewOptions baseMarkerViewOptions) {
        super(baseMarkerViewOptions);
        this.alpha = baseMarkerViewOptions.getAlpha();
        this.anchorU = baseMarkerViewOptions.getAnchorU();
        this.anchorV = baseMarkerViewOptions.getAnchorV();
        this.infoWindowAnchorU = baseMarkerViewOptions.getInfoWindowAnchorU();
        this.infoWindowAnchorV = baseMarkerViewOptions.getInfoWindowAnchorV();
        this.flat = baseMarkerViewOptions.isFlat();
        this.rotation = baseMarkerViewOptions.getRotation();
        this.selected = baseMarkerViewOptions.selected;
    }

    public void setAnchor(@FloatRange(from=0.0, to=1.0) float u, @FloatRange(from=0.0, to=1.0) float v) {
        this.anchorU = u;
        this.anchorV = v;
        this.setOffset(-1.0f, -1.0f);
    }

    public float getAnchorU() {
        return this.anchorU;
    }

    public float getAnchorV() {
        return this.anchorV;
    }

    void setOffset(float x, float y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    float getOffsetX() {
        return this.offsetX;
    }

    float getOffsetY() {
        return this.offsetY;
    }

    public void setInfoWindowAnchor(@FloatRange(from=0.0, to=1.0) float u, @FloatRange(from=0.0, to=1.0) float v) {
        this.infoWindowAnchorU = u;
        this.infoWindowAnchorV = v;
    }

    public float getInfoWindowAnchorU() {
        return this.infoWindowAnchorU;
    }

    public float getInfoWindowAnchorV() {
        return this.infoWindowAnchorV;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    float getTilt() {
        return this.tiltValue;
    }

    void setTilt(@FloatRange(from=0.0, to=60.0) float tiltValue) {
        this.tiltValue = tiltValue;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.markerViewManager != null) {
            this.markerViewManager.animateVisible(this, visible);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
        if (this.markerViewManager != null) {
            this.markerViewManager.animateRotation(this, rotation);
        }
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(@FloatRange(from=0.0, to=255.0) float alpha) {
        this.alpha = alpha;
        if (this.markerViewManager != null) {
            this.markerViewManager.animateAlpha(this, alpha);
        }
    }

    @Override
    public void setIcon(@Nullable Icon icon) {
        if (icon != null) {
            this.markerViewIcon = IconFactory.recreate("icon", icon.getBitmap());
        }
        Bitmap bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Icon transparentIcon = IconFactory.recreate("markerViewSettings", bitmap);
        if (this.markerViewManager != null) {
            this.markerViewManager.updateIcon(this);
        }
        super.setIcon(transparentIcon);
    }

    @Override
    public void setPosition(LatLng position) {
        super.setPosition(position);
        if (this.markerViewManager != null) {
            this.markerViewManager.update();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public Icon getIcon() {
        return this.markerViewIcon;
    }

    @Override
    public void setMapboxMap(MapboxMap mapboxMap) {
        super.setMapboxMap(mapboxMap);
        if (this.isFlat()) {
            this.tiltValue = (float)mapboxMap.getCameraPosition().tilt;
        }
        this.markerViewManager = mapboxMap.getMarkerViewManager();
    }

    @Override
    public String toString() {
        return "MarkerView [position[" + this.getPosition() + "]]";
    }
}

