/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.TypedValue;
import android.widget.ImageView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.exceptions.ConversionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColorUtils {
    @ColorInt
    public static int getPrimaryColor(@NonNull Context context) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(R.attr.colorPrimary, typedValue, true);
        return typedValue.data;
    }

    @ColorInt
    public static int getPrimaryDarkColor(@NonNull Context context) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(R.attr.colorPrimaryDark, typedValue, true);
        return typedValue.data;
    }

    @ColorInt
    public static int getAccentColor(@NonNull Context context) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(R.attr.colorAccent, typedValue, true);
        return typedValue.data;
    }

    @NonNull
    public static ColorStateList getSelector(@ColorInt int color2) {
        return new ColorStateList((int[][])new int[][]{{16842919}, new int[0]}, new int[]{color2, color2});
    }

    public static void setTintList(@NonNull ImageView imageView, @ColorInt int tintColor) {
        Drawable originalDrawable = imageView.getDrawable();
        Drawable wrappedDrawable = DrawableCompat.wrap((Drawable)originalDrawable);
        DrawableCompat.setTintList((Drawable)wrappedDrawable, (ColorStateList)ColorUtils.getSelector(tintColor));
    }

    static int normalizeColorComponent(String value) {
        return (int)(Float.parseFloat(value) * 255.0f);
    }

    @ColorInt
    public static int rgbaToColor(String value) {
        Pattern c = Pattern.compile("rgba?\\s*\\(\\s*(\\d+\\.?\\d*)\\s*,\\s*(\\d+\\.?\\d*)\\s*,\\s*(\\d+\\.?\\d*)\\s*,?\\s*(\\d+\\.?\\d*)?\\s*\\)");
        Matcher m = c.matcher(value);
        if (m.matches() && m.groupCount() == 3) {
            return Color.rgb((int)ColorUtils.normalizeColorComponent(m.group(1)), (int)ColorUtils.normalizeColorComponent(m.group(2)), (int)ColorUtils.normalizeColorComponent(m.group(3)));
        }
        if (m.matches() && m.groupCount() == 4) {
            return Color.argb((int)ColorUtils.normalizeColorComponent(m.group(4)), (int)ColorUtils.normalizeColorComponent(m.group(1)), (int)ColorUtils.normalizeColorComponent(m.group(2)), (int)ColorUtils.normalizeColorComponent(m.group(3)));
        }
        throw new ConversionException("Not a valid rgb/rgba value");
    }
}

