/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.commons.geojson.FeatureCollection;
import java.net.URL;
import java.util.HashMap;

public class GeoJsonSource
extends Source {
    public static final String TYPE = "geojson";
    private static final String DATA_KEY = "data";

    public GeoJsonSource(String id2, String geoJson) {
        super(id2, TYPE);
        if (geoJson == null || geoJson.startsWith("http")) {
            throw new IllegalArgumentException("Expected a raw json body");
        }
        this.setRawJson(geoJson);
    }

    public GeoJsonSource(String id2, URL url) {
        super(id2, TYPE);
        this.put(DATA_KEY, url.toExternalForm());
    }

    public GeoJsonSource(String id2, FeatureCollection features) {
        super(id2, TYPE);
        this.setRawJson(features.toJson());
    }

    public GeoJsonSource withCluster(boolean cluster) {
        this.put("cluster", cluster);
        return this;
    }

    public GeoJsonSource withClusterMaxZoom(float zoom) {
        this.put("clusterMaxZoom", Float.valueOf(zoom));
        return this;
    }

    public GeoJsonSource withClusterRadius(float radius) {
        this.put("clusterRadius", Float.valueOf(radius));
        return this;
    }

    private void setRawJson(String geoJson) {
        HashMap<String, String> wrapper = new HashMap<String, String>();
        wrapper.put(DATA_KEY, geoJson);
        this.put(DATA_KEY, wrapper);
    }
}

