/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.mapboxsdk.annotations.BaseMarkerViewOptions;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.exceptions.InvalidMarkerPositionException;
import com.mapbox.mapboxsdk.geometry.LatLng;

public class MarkerViewOptions
extends BaseMarkerViewOptions<MarkerView, MarkerViewOptions> {
    private MarkerView marker = new MarkerView();
    public static final Parcelable.Creator<MarkerViewOptions> CREATOR = new Parcelable.Creator<MarkerViewOptions>(){

        public MarkerViewOptions createFromParcel(Parcel in) {
            return new MarkerViewOptions(in);
        }

        public MarkerViewOptions[] newArray(int size) {
            return new MarkerViewOptions[size];
        }
    };

    public MarkerViewOptions() {
    }

    protected MarkerViewOptions(Parcel in) {
        this.position((LatLng)in.readParcelable(LatLng.class.getClassLoader()));
        this.snippet(in.readString());
        this.title(in.readString());
        this.flat(in.readByte() != 0);
        this.anchor(in.readFloat(), in.readFloat());
        this.infoWindowAnchor(in.readFloat(), in.readFloat());
        this.rotation(in.readFloat());
        this.visible(in.readByte() != 0);
        this.alpha(in.readFloat());
        if (in.readByte() != 0) {
            String iconId = in.readString();
            Bitmap iconBitmap = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
            Icon icon = new Icon(iconId, iconBitmap);
            this.icon(icon);
        }
    }

    @Override
    public MarkerViewOptions getThis() {
        return this;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.getPosition(), flags);
        out.writeString(this.getSnippet());
        out.writeString(this.getTitle());
        out.writeByte((byte)(this.isFlat() ? 1 : 0));
        out.writeFloat(this.getAnchorU());
        out.writeFloat(this.getAnchorV());
        out.writeFloat(this.getInfoWindowAnchorU());
        out.writeFloat(this.getInfoWindowAnchorV());
        out.writeFloat(this.getRotation());
        out.writeByte((byte)(this.isVisible() ? 1 : 0));
        out.writeFloat(this.alpha);
        Icon icon = this.getIcon();
        out.writeByte((byte)(icon != null ? 1 : 0));
        if (icon != null) {
            out.writeString(this.getIcon().getId());
            out.writeParcelable((Parcelable)this.getIcon().getBitmap(), flags);
        }
    }

    @Override
    public MarkerView getMarker() {
        if (this.position == null) {
            throw new InvalidMarkerPositionException();
        }
        this.marker.setPosition(this.position);
        this.marker.setSnippet(this.snippet);
        this.marker.setTitle(this.title);
        this.marker.setIcon(this.icon);
        this.marker.setFlat(this.flat);
        this.marker.setAnchor(this.anchorU, this.anchorV);
        this.marker.setInfoWindowAnchor(this.infoWindowAnchorU, this.infoWindowAnchorV);
        this.marker.setRotation(this.rotation);
        this.marker.setVisible(this.visible);
        this.marker.setAlpha(this.alpha);
        return this.marker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkerViewOptions that = (MarkerViewOptions)o;
        return this.marker != null ? this.marker.equals(that.marker) : that.marker == null;
    }

    public int hashCode() {
        return this.marker != null ? this.marker.hashCode() : 0;
    }
}

