/*
 * Decompiled with CFR 0.152.
 */
package com.almeros.android.multitouch.gesturedetectors;

import android.content.Context;
import android.view.MotionEvent;
import com.almeros.android.multitouch.gesturedetectors.TwoFingerGestureDetector;

public class ShoveGestureDetector
extends TwoFingerGestureDetector {
    private float mPrevAverageY;
    private float mCurrAverageY;
    private final OnShoveGestureListener mListener;
    private boolean mSloppyGesture;

    public ShoveGestureDetector(Context context, OnShoveGestureListener listener) {
        super(context);
        this.mListener = listener;
    }

    @Override
    protected void handleStartProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 5: {
                this.resetState();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                this.mTimeDelta = 0L;
                this.updateStateByEvent(event);
                this.mSloppyGesture = this.isSloppyGesture(event);
                if (this.mSloppyGesture) break;
                this.mGestureInProgress = this.mListener.onShoveBegin(this);
                break;
            }
            case 2: {
                if (!this.mSloppyGesture) break;
                this.mSloppyGesture = this.isSloppyGesture(event);
                if (this.mSloppyGesture) break;
                this.mGestureInProgress = this.mListener.onShoveBegin(this);
                break;
            }
            case 6: {
                if (this.mSloppyGesture) break;
            }
        }
    }

    @Override
    protected void handleInProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 6: {
                this.updateStateByEvent(event);
                if (!this.mSloppyGesture) {
                    this.mListener.onShoveEnd(this);
                }
                this.resetState();
                break;
            }
            case 3: {
                if (!this.mSloppyGesture) {
                    this.mListener.onShoveEnd(this);
                }
                this.resetState();
                break;
            }
            case 2: {
                boolean updatePrevious;
                this.updateStateByEvent(event);
                if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(Math.abs(this.getShovePixelsDelta()) > 0.5f) || !(updatePrevious = this.mListener.onShove(this))) break;
                this.mPrevEvent.recycle();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
            }
        }
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.mSloppyGesture = false;
        this.mPrevAverageY = 0.0f;
        this.mCurrAverageY = 0.0f;
    }

    @Override
    protected void updateStateByEvent(MotionEvent curr) {
        super.updateStateByEvent(curr);
        MotionEvent prev = this.mPrevEvent;
        float py0 = prev.getY(0);
        float py1 = prev.getY(1);
        this.mPrevAverageY = (py0 + py1) / 2.0f;
        float cy0 = curr.getY(0);
        float cy1 = curr.getY(1);
        this.mCurrAverageY = (cy0 + cy1) / 2.0f;
    }

    @Override
    protected boolean isSloppyGesture(MotionEvent event) {
        boolean sloppy = super.isSloppyGesture(event);
        if (sloppy) {
            return true;
        }
        double angle = Math.abs(Math.atan2(this.mCurrFingerDiffY, this.mCurrFingerDiffX));
        return !(0.0 < angle && angle < (double)0.35f || (double)2.79f < angle && angle < Math.PI);
    }

    public float getShovePixelsDelta() {
        return this.mCurrAverageY - this.mPrevAverageY;
    }

    public static class SimpleOnShoveGestureListener
    implements OnShoveGestureListener {
        @Override
        public boolean onShove(ShoveGestureDetector detector) {
            return false;
        }

        @Override
        public boolean onShoveBegin(ShoveGestureDetector detector) {
            return true;
        }

        @Override
        public void onShoveEnd(ShoveGestureDetector detector) {
        }
    }

    public static interface OnShoveGestureListener {
        public boolean onShove(ShoveGestureDetector var1);

        public boolean onShoveBegin(ShoveGestureDetector var1);

        public void onShoveEnd(ShoveGestureDetector var1);
    }
}

