/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.Property;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class FillLayer
extends Layer {
    public FillLayer(long nativePtr) {
        super(nativePtr);
    }

    public FillLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkValidity();
        this.nativeSetSourceLayer(sourceLayer);
    }

    public FillLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public void setFilter(Filter.Statement filter) {
        this.checkValidity();
        this.setFilter(filter.toArray());
    }

    public void setFilter(Object[] filter) {
        this.checkValidity();
        this.nativeSetFilter(filter);
    }

    public FillLayer withFilter(Object[] filter) {
        this.setFilter(filter);
        return this;
    }

    public FillLayer withFilter(Filter.Statement filter) {
        this.setFilter(filter);
        return this;
    }

    public FillLayer withProperties(Property<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Boolean> getFillAntialias() {
        this.checkValidity();
        return new PropertyValue<Boolean>(this.nativeGetFillAntialias());
    }

    public PropertyValue<Float> getFillOpacity() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetFillOpacity());
    }

    public PropertyValue<String> getFillColor() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetFillColor());
    }

    @ColorInt
    public int getFillColorAsInt() {
        this.checkValidity();
        PropertyValue<String> value = this.getFillColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-color was set as a Function");
    }

    public PropertyValue<String> getFillOutlineColor() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetFillOutlineColor());
    }

    @ColorInt
    public int getFillOutlineColorAsInt() {
        this.checkValidity();
        PropertyValue<String> value = this.getFillOutlineColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-outline-color was set as a Function");
    }

    public PropertyValue<Float[]> getFillTranslate() {
        this.checkValidity();
        return new PropertyValue<Float[]>(this.nativeGetFillTranslate());
    }

    public PropertyValue<String> getFillTranslateAnchor() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetFillTranslateAnchor());
    }

    public PropertyValue<String> getFillPattern() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetFillPattern());
    }

    private native Object nativeGetFillAntialias();

    private native Object nativeGetFillOpacity();

    private native Object nativeGetFillColor();

    private native Object nativeGetFillOutlineColor();

    private native Object nativeGetFillTranslate();

    private native Object nativeGetFillTranslateAnchor();

    private native Object nativeGetFillPattern();

    @Override
    protected native void finalize() throws Throwable;
}

