/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.geometry;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.exceptions.InvalidLatLngBoundsException;
import com.mapbox.mapboxsdk.geometry.ILatLng;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngSpan;
import java.util.ArrayList;
import java.util.List;

public class LatLngBounds
implements Parcelable {
    private final double mLatNorth;
    private final double mLatSouth;
    private final double mLonEast;
    private final double mLonWest;
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new Parcelable.Creator<LatLngBounds>(){

        public LatLngBounds createFromParcel(Parcel in) {
            return LatLngBounds.readFromParcel(in);
        }

        public LatLngBounds[] newArray(int size) {
            return new LatLngBounds[size];
        }
    };

    LatLngBounds(double northLatitude, double eastLongitude, double southLatitude, double westLongitude) {
        this.mLatNorth = northLatitude;
        this.mLonEast = eastLongitude;
        this.mLatSouth = southLatitude;
        this.mLonWest = westLongitude;
    }

    public LatLng getCenter() {
        return new LatLng((this.mLatNorth + this.mLatSouth) / 2.0, (this.mLonEast + this.mLonWest) / 2.0);
    }

    public double getLatNorth() {
        return this.mLatNorth;
    }

    public double getLatSouth() {
        return this.mLatSouth;
    }

    public double getLonEast() {
        return this.mLonEast;
    }

    public double getLonWest() {
        return this.mLonWest;
    }

    public LatLngSpan getSpan() {
        return new LatLngSpan(this.getLatitudeSpan(), this.getLongitudeSpan());
    }

    public double getLatitudeSpan() {
        return Math.abs(this.mLatNorth - this.mLatSouth);
    }

    public double getLongitudeSpan() {
        return Math.abs(this.mLonEast - this.mLonWest);
    }

    public boolean isEmptySpan() {
        return this.getLongitudeSpan() == 0.0 || this.getLatitudeSpan() == 0.0;
    }

    public String toString() {
        return "N:" + this.mLatNorth + "; E:" + this.mLonEast + "; S:" + this.mLatSouth + "; W:" + this.mLonWest;
    }

    static LatLngBounds fromLatLngs(List<? extends ILatLng> latLngs) {
        double minLat = 90.0;
        double minLon = 180.0;
        double maxLat = -90.0;
        double maxLon = -180.0;
        for (ILatLng iLatLng : latLngs) {
            double latitude = iLatLng.getLatitude();
            double longitude = iLatLng.getLongitude();
            minLat = Math.min(minLat, latitude);
            minLon = Math.min(minLon, longitude);
            maxLat = Math.max(maxLat, latitude);
            maxLon = Math.max(maxLon, longitude);
        }
        return new LatLngBounds(maxLat, maxLon, minLat, minLon);
    }

    public LatLng[] toLatLngs() {
        return new LatLng[]{new LatLng(this.mLatNorth, this.mLonEast), new LatLng(this.mLatSouth, this.mLonWest)};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LatLngBounds) {
            LatLngBounds other = (LatLngBounds)o;
            return this.mLatNorth == other.getLatNorth() && this.mLatSouth == other.getLatSouth() && this.mLonEast == other.getLonEast() && this.mLonWest == other.getLonWest();
        }
        return false;
    }

    public boolean contains(ILatLng latLng) {
        double latitude = latLng.getLatitude();
        double longitude = latLng.getLongitude();
        return latitude < this.mLatNorth && latitude > this.mLatSouth && longitude < this.mLonEast && longitude > this.mLonWest;
    }

    public LatLngBounds union(LatLngBounds bounds) {
        return this.union(bounds.getLatNorth(), bounds.getLonEast(), bounds.getLatSouth(), bounds.getLonWest());
    }

    public LatLngBounds union(double lonNorth, double latEast, double lonSouth, double latWest) {
        return new LatLngBounds(this.mLatNorth < lonNorth ? lonNorth : this.mLatNorth, this.mLonEast < latEast ? latEast : this.mLonEast, this.mLatSouth > lonSouth ? lonSouth : this.mLatSouth, this.mLonWest > latWest ? latWest : this.mLonWest);
    }

    public LatLngBounds intersect(LatLngBounds box) {
        double minLatWest = Math.max(this.getLonWest(), box.getLonWest());
        double maxLatEast = Math.min(this.getLonEast(), box.getLonEast());
        if (maxLatEast > minLatWest) {
            double minLonSouth = Math.max(this.getLatSouth(), box.getLatSouth());
            double maxLonNorth = Math.min(this.getLatNorth(), box.getLatNorth());
            if (maxLonNorth > minLonSouth) {
                return new LatLngBounds(maxLonNorth, maxLatEast, minLonSouth, minLatWest);
            }
        }
        return null;
    }

    public LatLngBounds intersect(double northLatitude, double eastLongitude, double southLatitude, double westLongitude) {
        return this.intersect(new LatLngBounds(northLatitude, eastLongitude, southLatitude, westLongitude));
    }

    public int hashCode() {
        return (int)(this.mLatNorth + 90.0 + (this.mLatSouth + 90.0) * 1000.0 + (this.mLonEast + 180.0) * 1000000.0 + (this.mLonEast + 180.0) * 1.0E9);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int arg1) {
        out.writeDouble(this.mLatNorth);
        out.writeDouble(this.mLonEast);
        out.writeDouble(this.mLatSouth);
        out.writeDouble(this.mLonWest);
    }

    private static LatLngBounds readFromParcel(Parcel in) {
        double lonNorth = in.readDouble();
        double latEast = in.readDouble();
        double lonSouth = in.readDouble();
        double latWest = in.readDouble();
        return new LatLngBounds(lonNorth, latEast, lonSouth, latWest);
    }

    public static final class Builder {
        private List<LatLng> mLatLngList = new ArrayList<LatLng>();

        public LatLngBounds build() {
            if (this.mLatLngList.size() < 2) {
                throw new InvalidLatLngBoundsException(this.mLatLngList.size());
            }
            return LatLngBounds.fromLatLngs(this.mLatLngList);
        }

        public Builder includes(List<LatLng> latLngs) {
            for (LatLng point : latLngs) {
                this.mLatLngList.add(point);
            }
            return this;
        }

        public Builder include(@NonNull LatLng latLng) {
            this.mLatLngList.add(latLng);
            return this;
        }
    }
}

