/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.os.Parcelable;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.geometry.LatLng;

public abstract class BaseMarkerViewOptions<U extends MarkerView, T extends BaseMarkerViewOptions<U, T>>
implements Parcelable {
    protected LatLng position;
    protected String snippet;
    protected String title;
    protected Icon icon;
    protected boolean flat;
    protected float anchorU = 0.5f;
    protected float anchorV = 1.0f;
    protected float infoWindowAnchorU = 0.5f;
    protected float infoWindowAnchorV = 0.0f;
    protected float rotation;
    protected boolean visible = true;
    protected boolean selected;

    public T position(@NonNull LatLng position) {
        this.position = position;
        return this.getThis();
    }

    public T snippet(String snippet) {
        this.snippet = snippet;
        return this.getThis();
    }

    public T title(String title) {
        this.title = title;
        return this.getThis();
    }

    public T icon(Icon icon) {
        this.icon = icon;
        return this.getThis();
    }

    public T flat(boolean flat) {
        this.flat = flat;
        return this.getThis();
    }

    public T anchor(@FloatRange(from=0.0, to=1.0) float u, @FloatRange(from=0.0, to=1.0) float v) {
        this.anchorU = u;
        this.anchorV = v;
        return this.getThis();
    }

    public T infoWindowAnchor(@FloatRange(from=0.0, to=1.0) float u, @FloatRange(from=0.0, to=1.0) float v) {
        this.infoWindowAnchorU = u;
        this.infoWindowAnchorV = v;
        return this.getThis();
    }

    public T rotation(float rotation) {
        this.rotation = rotation;
        return this.getThis();
    }

    public T visible(boolean visible) {
        this.visible = visible;
        return this.getThis();
    }

    public LatLng getPosition() {
        return this.position;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public String getTitle() {
        return this.title;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public float getAnchorU() {
        return this.anchorU;
    }

    public float getAnchorV() {
        return this.anchorV;
    }

    public float getInfoWindowAnchorU() {
        return this.infoWindowAnchorU;
    }

    public float getInfoWindowAnchorV() {
        return this.infoWindowAnchorV;
    }

    public float getRotation() {
        return this.rotation;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public abstract T getThis();

    public abstract U getMarker();
}

