/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ScaleGestureDetectorCompat;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ZoomButtonsController;
import com.almeros.android.multitouch.gesturedetectors.RotateGestureDetector;
import com.almeros.android.multitouch.gesturedetectors.ShoveGestureDetector;
import com.almeros.android.multitouch.gesturedetectors.TwoFingerGestureDetector;
import com.mapbox.mapboxsdk.MapboxAccountManager;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.IconFactory;
import com.mapbox.mapboxsdk.annotations.InfoWindow;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.constants.Style;
import com.mapbox.mapboxsdk.exceptions.IconBitmapChangedException;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.layers.CustomLayer;
import com.mapbox.mapboxsdk.location.LocationListener;
import com.mapbox.mapboxsdk.location.LocationServices;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.TrackingSettings;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.maps.widgets.CompassView;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationView;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationViewSettings;
import com.mapbox.mapboxsdk.telemetry.MapboxEventManager;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MapView
extends FrameLayout {
    private MapboxMap mMapboxMap;
    private boolean mInitialLoad;
    private boolean mDestroyed;
    private List<Icon> mIcons;
    private int mAverageIconHeight;
    private int mAverageIconWidth;
    private NativeMapView mNativeMapView;
    private boolean mHasSurface = false;
    private CompassView mCompassView;
    private ImageView mLogoView;
    private ImageView mAttributionsView;
    private MyLocationView mMyLocationView;
    private LocationListener mMyLocationListener;
    private CopyOnWriteArrayList<OnMapChangedListener> mOnMapChangedListener;
    private ZoomButtonsController mZoomButtonsController;
    private ConnectivityReceiver mConnectivityReceiver;
    private float mScreenDensity = 1.0f;
    private TrackballLongPressTimeOut mCurrentTrackballLongPressTimeOut;
    private GestureDetectorCompat mGestureDetector;
    private ScaleGestureDetector mScaleGestureDetector;
    private RotateGestureDetector mRotateGestureDetector;
    private ShoveGestureDetector mShoveGestureDetector;
    private boolean mTwoTap = false;
    private boolean mZoomStarted = false;
    private boolean mQuickZoom = false;
    private boolean mScrollInProgress = false;
    private int mContentPaddingLeft;
    private int mContentPaddingTop;
    private int mContentPaddingRight;
    private int mContentPaddingBottom;
    private StyleInitializer mStyleInitializer;
    private List<OnMapReadyCallback> mOnMapReadyCallbackList;
    public static final int REGION_WILL_CHANGE = 0;
    public static final int REGION_WILL_CHANGE_ANIMATED = 1;
    public static final int REGION_IS_CHANGING = 2;
    public static final int REGION_DID_CHANGE = 3;
    public static final int REGION_DID_CHANGE_ANIMATED = 4;
    public static final int WILL_START_LOADING_MAP = 5;
    public static final int DID_FINISH_LOADING_MAP = 6;
    public static final int DID_FAIL_LOADING_MAP = 7;
    public static final int WILL_START_RENDERING_FRAME = 8;
    public static final int DID_FINISH_RENDERING_FRAME = 9;
    public static final int DID_FINISH_RENDERING_FRAME_FULLY_RENDERED = 10;
    public static final int WILL_START_RENDERING_MAP = 11;
    public static final int DID_FINISH_RENDERING_MAP = 12;
    public static final int DID_FINISH_RENDERING_MAP_FULLY_RENDERED = 13;

    @UiThread
    public MapView(@NonNull Context context) {
        super(context);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, null));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable MapboxMapOptions options) {
        super(context);
        this.initialize(context, options);
    }

    private void initialize(@NonNull Context context, @NonNull MapboxMapOptions options) {
        this.mInitialLoad = true;
        this.mOnMapReadyCallbackList = new ArrayList<OnMapReadyCallback>();
        this.mOnMapChangedListener = new CopyOnWriteArrayList();
        this.mMapboxMap = new MapboxMap(this);
        this.mIcons = new ArrayList<Icon>();
        this.mStyleInitializer = new StyleInitializer(context);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.mapview_internal, (ViewGroup)this);
        if (!this.isInEditMode()) {
            this.setWillNotDraw(false);
        }
        TextureView textureView = (TextureView)view.findViewById(R.id.textureView);
        textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)new SurfaceTextureListener());
        if (this.isInEditMode()) {
            return;
        }
        this.mNativeMapView = new NativeMapView(this);
        this.setClickable(true);
        this.setLongClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.mGestureDetector.setIsLongpressEnabled(true);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureListener());
        ScaleGestureDetectorCompat.setQuickScaleEnabled((Object)this.mScaleGestureDetector, (boolean)true);
        this.mRotateGestureDetector = new RotateGestureDetector(context, new RotateGestureListener());
        this.mShoveGestureDetector = new ShoveGestureDetector(context, new ShoveGestureListener());
        this.mZoomButtonsController = new ZoomButtonsController((View)this);
        this.mZoomButtonsController.setZoomSpeed(300L);
        this.mZoomButtonsController.setOnZoomListener((ZoomButtonsController.OnZoomListener)new OnZoomListener());
        this.onConnectivityChanged(this.isConnected());
        this.mMyLocationView = (MyLocationView)view.findViewById(R.id.userLocationView);
        this.mMyLocationView.setMapboxMap(this.mMapboxMap);
        this.mCompassView = (CompassView)view.findViewById(R.id.compassView);
        this.mCompassView.setMapboxMap(this.mMapboxMap);
        this.mLogoView = (ImageView)view.findViewById(R.id.logoView);
        this.mAttributionsView = (ImageView)view.findViewById(R.id.attributionView);
        this.mAttributionsView.setOnClickListener((View.OnClickListener)new AttributionOnClickListener(this));
        this.mScreenDensity = context.getResources().getDisplayMetrics().density;
        this.setInitialState(options);
        if (!context.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch")) {
            this.mMapboxMap.getUiSettings().setZoomControlsEnabled(true);
        }
    }

    private void setInitialState(MapboxMapOptions options) {
        this.mMapboxMap.setDebugActive(options.getDebugActive());
        CameraPosition position = options.getCamera();
        if (position != null) {
            this.mMapboxMap.moveCamera(CameraUpdateFactory.newCameraPosition(position));
        }
        String accessToken = null;
        accessToken = MapboxAccountManager.getInstance() != null ? MapboxAccountManager.getInstance().getAccessToken() : options.getAccessToken();
        String style2 = options.getStyle();
        if (!TextUtils.isEmpty((CharSequence)accessToken)) {
            this.mMapboxMap.setAccessToken(accessToken);
            if (style2 != null) {
                this.setStyleUrl(style2);
            }
        } else {
            this.mStyleInitializer.setStyle(style2, true);
        }
        MyLocationViewSettings myLocationViewSettings = this.mMapboxMap.getMyLocationViewSettings();
        myLocationViewSettings.setForegroundDrawable(options.getMyLocationForegroundDrawable(), options.getMyLocationForegroundBearingDrawable());
        myLocationViewSettings.setForegroundTintColor(options.getMyLocationForegroundTintColor());
        myLocationViewSettings.setBackgroundDrawable(options.getMyLocationBackgroundDrawable(), options.getMyLocationBackgroundPadding());
        myLocationViewSettings.setBackgroundTintColor(options.getMyLocationBackgroundTintColor());
        myLocationViewSettings.setAccuracyAlpha(options.getMyLocationAccuracyAlpha());
        myLocationViewSettings.setAccuracyTintColor(options.getMyLocationAccuracyTintColor());
        this.mMapboxMap.setMyLocationEnabled(options.getLocationEnabled());
        UiSettings uiSettings = this.mMapboxMap.getUiSettings();
        uiSettings.setZoomGesturesEnabled(options.getZoomGesturesEnabled());
        uiSettings.setZoomGestureChangeAllowed(options.getZoomGesturesEnabled());
        uiSettings.setScrollGesturesEnabled(options.getScrollGesturesEnabled());
        uiSettings.setScrollGestureChangeAllowed(options.getScrollGesturesEnabled());
        uiSettings.setRotateGesturesEnabled(options.getRotateGesturesEnabled());
        uiSettings.setRotateGestureChangeAllowed(options.getRotateGesturesEnabled());
        uiSettings.setTiltGesturesEnabled(options.getTiltGesturesEnabled());
        uiSettings.setTiltGestureChangeAllowed(options.getTiltGesturesEnabled());
        uiSettings.setZoomControlsEnabled(options.getZoomControlsEnabled());
        this.mMapboxMap.setMaxZoom(options.getMaxZoom());
        this.mMapboxMap.setMinZoom(options.getMinZoom());
        uiSettings.setCompassEnabled(options.getCompassEnabled());
        uiSettings.setCompassGravity(options.getCompassGravity());
        int[] compassMargins = options.getCompassMargins();
        if (compassMargins != null) {
            uiSettings.setCompassMargins(compassMargins[0], compassMargins[1], compassMargins[2], compassMargins[3]);
        } else {
            int tenDp = (int)this.getResources().getDimension(R.dimen.ten_dp);
            uiSettings.setCompassMargins(tenDp, tenDp, tenDp, tenDp);
        }
        uiSettings.setLogoEnabled(options.getLogoEnabled());
        uiSettings.setLogoGravity(options.getLogoGravity());
        int[] logoMargins = options.getLogoMargins();
        if (logoMargins != null) {
            uiSettings.setLogoMargins(logoMargins[0], logoMargins[1], logoMargins[2], logoMargins[3]);
        } else {
            int sixteenDp = (int)this.getResources().getDimension(R.dimen.sixteen_dp);
            uiSettings.setLogoMargins(sixteenDp, sixteenDp, sixteenDp, sixteenDp);
        }
        uiSettings.setAttributionEnabled(options.getAttributionEnabled());
        uiSettings.setAttributionGravity(options.getAttributionGravity());
        int[] attributionMargins = options.getAttributionMargins();
        if (attributionMargins != null) {
            uiSettings.setAttributionMargins(attributionMargins[0], attributionMargins[1], attributionMargins[2], attributionMargins[3]);
        } else {
            Resources resources = this.getResources();
            int sevenDp = (int)resources.getDimension(R.dimen.seven_dp);
            int seventySixDp = (int)resources.getDimension(R.dimen.seventy_six_dp);
            uiSettings.setAttributionMargins(seventySixDp, sevenDp, sevenDp, sevenDp);
        }
        int attributionTintColor = options.getAttributionTintColor();
        uiSettings.setAttributionTintColor(attributionTintColor != -1 ? attributionTintColor : ColorUtils.getPrimaryColor(this.getContext()));
    }

    @UiThread
    public void onCreate(@Nullable Bundle savedInstanceState) {
        MapboxAccountManager.validateAccessToken(this.getAccessToken());
        if (savedInstanceState != null && savedInstanceState.getBoolean("savedState")) {
            CameraPosition cameraPosition = (CameraPosition)savedInstanceState.getParcelable("cameraPosition");
            if (cameraPosition != null) {
                this.mMapboxMap.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition));
            }
            UiSettings uiSettings = this.mMapboxMap.getUiSettings();
            uiSettings.setZoomGesturesEnabled(savedInstanceState.getBoolean("zoomEnabled"));
            uiSettings.setZoomGestureChangeAllowed(savedInstanceState.getBoolean("zoomEnabledChange"));
            uiSettings.setScrollGesturesEnabled(savedInstanceState.getBoolean("scrollEnabled"));
            uiSettings.setScrollGestureChangeAllowed(savedInstanceState.getBoolean("scrollEnabledChange"));
            uiSettings.setRotateGesturesEnabled(savedInstanceState.getBoolean("rotateEnabled"));
            uiSettings.setRotateGestureChangeAllowed(savedInstanceState.getBoolean("rotateEnabledChange"));
            uiSettings.setTiltGesturesEnabled(savedInstanceState.getBoolean("tiltEnabled"));
            uiSettings.setTiltGestureChangeAllowed(savedInstanceState.getBoolean("tiltEnabledChange"));
            uiSettings.setZoomControlsEnabled(savedInstanceState.getBoolean("zoomControlsEnabled"));
            uiSettings.setCompassEnabled(savedInstanceState.getBoolean("compassEnabled"));
            uiSettings.setCompassGravity(savedInstanceState.getInt("compassGravity"));
            uiSettings.setCompassMargins(savedInstanceState.getInt("compassMarginLeft"), savedInstanceState.getInt("compassMarginTop"), savedInstanceState.getInt("compassMarginRight"), savedInstanceState.getInt("compassMarginBottom"));
            uiSettings.setLogoEnabled(savedInstanceState.getBoolean("logoEnabled"));
            uiSettings.setLogoGravity(savedInstanceState.getInt("logoGravity"));
            uiSettings.setLogoMargins(savedInstanceState.getInt("logoMarginLeft"), savedInstanceState.getInt("logoMarginTop"), savedInstanceState.getInt("logoMarginRight"), savedInstanceState.getInt("logoMarginBottom"));
            uiSettings.setAttributionEnabled(savedInstanceState.getBoolean("atrrEnabled"));
            uiSettings.setAttributionGravity(savedInstanceState.getInt("attrGravity"));
            uiSettings.setAttributionMargins(savedInstanceState.getInt("attrMarginLeft"), savedInstanceState.getInt("attrMarginTop"), savedInstanceState.getInt("attrMarginRight"), savedInstanceState.getInt("atrrMarginBottom"));
            this.mMapboxMap.setDebugActive(savedInstanceState.getBoolean("debugActive"));
            this.mMapboxMap.setStyleUrl(savedInstanceState.getString("styleUrl"));
            try {
                this.mMapboxMap.setMyLocationEnabled(savedInstanceState.getBoolean("myLocationEnabled"));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            TrackingSettings trackingSettings = this.mMapboxMap.getTrackingSettings();
            trackingSettings.setMyLocationTrackingMode(savedInstanceState.getInt("myLocationTracking", 0));
            trackingSettings.setMyBearingTrackingMode(savedInstanceState.getInt("myBearingTracking", 0));
        } else if (savedInstanceState == null) {
            Log.i((String)MapView.class.getCanonicalName(), (String)"MapView start Telemetry...");
            MapboxEventManager eventManager = MapboxEventManager.getMapboxEventManager();
            eventManager.initialize(this.getContext(), this.getAccessToken());
        }
        this.mNativeMapView.initializeDisplay();
        this.mNativeMapView.initializeContext();
        this.addOnMapChangedListener(new OnMapChangedListener(){

            @Override
            public void onMapChanged(int change) {
                if (change == 11 && MapView.this.mInitialLoad) {
                    MapView.this.mInitialLoad = false;
                    MapView.this.reloadIcons();
                    MapView.this.reloadMarkers();
                    MapView.this.adjustTopOffsetPixels();
                    if (MapView.this.mOnMapReadyCallbackList.size() > 0) {
                        Iterator iterator = MapView.this.mOnMapReadyCallbackList.iterator();
                        while (iterator.hasNext()) {
                            OnMapReadyCallback callback = (OnMapReadyCallback)iterator.next();
                            callback.onMapReady(MapView.this.mMapboxMap);
                            iterator.remove();
                        }
                    }
                } else if (change == 2 || change == 3 || change == 6) {
                    MapView.this.mMapboxMap.getMarkerViewManager().invalidateViewMarkers();
                }
            }
        });
        if (savedInstanceState == null) {
            Hashtable<String, Object> evt = new Hashtable<String, Object>();
            evt.put("event", "map.load");
            evt.put("created", MapboxEventManager.generateCreateDate());
            MapboxEventManager.getMapboxEventManager().pushEvent(evt);
        }
    }

    @UiThread
    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putBoolean("savedState", true);
        outState.putParcelable("cameraPosition", (Parcelable)this.mMapboxMap.getCameraPosition());
        outState.putBoolean("debugActive", this.mMapboxMap.isDebugActive());
        outState.putString("styleUrl", this.mStyleInitializer.getStyle());
        outState.putBoolean("myLocationEnabled", this.mMapboxMap.isMyLocationEnabled());
        TrackingSettings trackingSettings = this.mMapboxMap.getTrackingSettings();
        outState.putInt("myLocationTracking", trackingSettings.getMyLocationTrackingMode());
        outState.putInt("myBearingTracking", trackingSettings.getMyBearingTrackingMode());
        UiSettings uiSettings = this.mMapboxMap.getUiSettings();
        outState.putBoolean("zoomEnabled", uiSettings.isZoomGesturesEnabled());
        outState.putBoolean("zoomEnabledChange", uiSettings.isZoomGestureChangeAllowed());
        outState.putBoolean("scrollEnabled", uiSettings.isScrollGesturesEnabled());
        outState.putBoolean("scrollEnabledChange", uiSettings.isScrollGestureChangeAllowed());
        outState.putBoolean("rotateEnabled", uiSettings.isRotateGesturesEnabled());
        outState.putBoolean("rotateEnabledChange", uiSettings.isRotateGestureChangeAllowed());
        outState.putBoolean("tiltEnabled", uiSettings.isTiltGesturesEnabled());
        outState.putBoolean("tiltEnabledChange", uiSettings.isTiltGestureChangeAllowed());
        outState.putBoolean("zoomControlsEnabled", uiSettings.isZoomControlsEnabled());
        outState.putBoolean("compassEnabled", uiSettings.isCompassEnabled());
        outState.putInt("compassGravity", uiSettings.getCompassGravity());
        outState.putInt("compassMarginLeft", uiSettings.getCompassMarginLeft());
        outState.putInt("compassMarginTop", uiSettings.getCompassMarginTop());
        outState.putInt("compassMarginBottom", uiSettings.getCompassMarginBottom());
        outState.putInt("compassMarginRight", uiSettings.getCompassMarginRight());
        outState.putInt("logoGravity", uiSettings.getLogoGravity());
        outState.putInt("logoMarginLeft", uiSettings.getLogoMarginLeft());
        outState.putInt("logoMarginTop", uiSettings.getCompassMarginTop());
        outState.putInt("logoMarginRight", uiSettings.getLogoMarginRight());
        outState.putInt("logoMarginBottom", uiSettings.getLogoMarginBottom());
        outState.putBoolean("logoEnabled", uiSettings.isLogoEnabled());
        outState.putInt("attrGravity", uiSettings.getAttributionGravity());
        outState.putInt("attrMarginLeft", uiSettings.getAttributionMarginLeft());
        outState.putInt("attrMarginTop", uiSettings.getAttributionMarginTop());
        outState.putInt("attrMarginRight", uiSettings.getAttributionMarginRight());
        outState.putInt("atrrMarginBottom", uiSettings.getAttributionMarginBottom());
        outState.putBoolean("atrrEnabled", uiSettings.isAttributionEnabled());
    }

    @UiThread
    public void onDestroy() {
        this.mDestroyed = true;
        this.mNativeMapView.terminateContext();
        this.mNativeMapView.terminateDisplay();
        this.mNativeMapView.destroySurface();
        this.mNativeMapView.destroy();
        this.mNativeMapView = null;
    }

    @UiThread
    public void onPause() {
        this.getContext().unregisterReceiver((BroadcastReceiver)this.mConnectivityReceiver);
        this.mConnectivityReceiver = null;
        this.mMyLocationView.onPause();
    }

    @UiThread
    public void onResume() {
        this.mConnectivityReceiver = new ConnectivityReceiver();
        this.getContext().registerReceiver((BroadcastReceiver)this.mConnectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.mNativeMapView.update();
        this.mMyLocationView.onResume();
        if (this.mStyleInitializer.isDefaultStyle()) {
            this.setStyleUrl(this.mStyleInitializer.getStyle());
        }
    }

    @UiThread
    public void onLowMemory() {
        this.mNativeMapView.onLowMemory();
    }

    protected void onFpsChanged(final double fps) {
        this.post(new Runnable(){

            @Override
            public void run() {
                MapboxMap.OnFpsChangedListener listener = MapView.this.mMapboxMap.getOnFpsChangedListener();
                if (listener != null) {
                    listener.onFpsChanged(fps);
                }
            }
        });
    }

    LatLng getLatLng() {
        return this.mNativeMapView.getLatLng();
    }

    double getTilt() {
        return this.mNativeMapView.getPitch();
    }

    void setTilt(Double pitch) {
        this.mMyLocationView.setTilt(pitch);
        this.mNativeMapView.setPitch(pitch, 0L);
    }

    double getDirection() {
        double direction;
        if (this.mDestroyed) {
            return 0.0;
        }
        for (direction = -this.mNativeMapView.getBearing(); direction > 360.0; direction -= 360.0) {
        }
        while (direction < 0.0) {
            direction += 360.0;
        }
        return direction;
    }

    void setDirection(@FloatRange(from=0.0, to=360.0) double direction) {
        if (this.mDestroyed) {
            return;
        }
        this.setDirection(direction, false);
    }

    void setDirection(@FloatRange(from=0.0, to=360.0) double direction, boolean animated) {
        if (this.mDestroyed) {
            return;
        }
        long duration = animated ? 300L : 0L;
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.setBearing(-direction, duration);
    }

    void resetNorth() {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.resetNorth();
    }

    int getContentPaddingLeft() {
        return this.mContentPaddingLeft;
    }

    int getContentPaddingTop() {
        return this.mContentPaddingTop;
    }

    int getContentPaddingRight() {
        return this.mContentPaddingRight;
    }

    int getContentPaddingBottom() {
        return this.mContentPaddingBottom;
    }

    int getContentWidth() {
        return this.getWidth() - this.mContentPaddingLeft - this.mContentPaddingRight;
    }

    int getContentHeight() {
        return this.getHeight() - this.mContentPaddingBottom - this.mContentPaddingTop;
    }

    double getZoom() {
        if (this.mDestroyed) {
            return 0.0;
        }
        return this.mNativeMapView.getZoom();
    }

    void setMinZoom(@FloatRange(from=0.0, to=21.0) double minZoom) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.setMinZoom(minZoom);
    }

    double getMinZoom() {
        if (this.mDestroyed) {
            return 0.0;
        }
        return this.mNativeMapView.getMinZoom();
    }

    void setMaxZoom(@FloatRange(from=0.0, to=21.0) double maxZoom) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.setMaxZoom(maxZoom);
    }

    double getMaxZoom() {
        if (this.mDestroyed) {
            return 0.0;
        }
        return this.mNativeMapView.getMaxZoom();
    }

    private void zoom(boolean zoomIn) {
        this.zoom(zoomIn, -1.0f, -1.0f);
    }

    private void zoom(boolean zoomIn, float x, float y) {
        this.mNativeMapView.cancelTransitions();
        if (zoomIn) {
            this.mNativeMapView.scaleBy(2.0, x / this.mScreenDensity, y / this.mScreenDensity, 300L);
        } else {
            this.mNativeMapView.scaleBy(0.5, x / this.mScreenDensity, y / this.mScreenDensity, 300L);
        }
        this.postDelayed(new ZoomInvalidator(this.mMapboxMap), 300L);
    }

    boolean isDebugActive() {
        if (this.mDestroyed) {
            return false;
        }
        return this.mNativeMapView.getDebug();
    }

    void setDebugActive(boolean debugActive) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.setDebug(debugActive);
    }

    void cycleDebugOptions() {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.cycleDebugOptions();
    }

    public void setStyleUrl(@NonNull String url) {
        if (this.mDestroyed) {
            return;
        }
        this.mStyleInitializer.setStyle(url);
        this.mNativeMapView.setStyleUrl(url);
    }

    @UiThread
    public void setStyle(String style2) {
        this.setStyleUrl(style2);
    }

    @UiThread
    @NonNull
    public String getStyleUrl() {
        return this.mStyleInitializer.getStyle();
    }

    @Deprecated
    @UiThread
    public void setAccessToken(@NonNull String accessToken) {
        if (this.mDestroyed) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)accessToken)) {
            accessToken = accessToken.trim();
        }
        MapboxAccountManager.validateAccessToken(accessToken);
        this.mNativeMapView.setAccessToken(accessToken);
    }

    @Deprecated
    @UiThread
    @Nullable
    public String getAccessToken() {
        if (this.mDestroyed) {
            return "";
        }
        return this.mNativeMapView.getAccessToken();
    }

    LatLng fromScreenLocation(@NonNull PointF point) {
        if (this.mDestroyed) {
            return new LatLng();
        }
        point.set(point.x / this.mScreenDensity, point.y / this.mScreenDensity);
        return this.mNativeMapView.latLngForPixel(point);
    }

    PointF toScreenLocation(@NonNull LatLng location) {
        if (this.mDestroyed || location == null) {
            return new PointF();
        }
        PointF pointF = this.mNativeMapView.pixelForLatLng(location);
        pointF.set(pointF.x * this.mScreenDensity, pointF.y * this.mScreenDensity);
        return pointF;
    }

    Icon loadIconForMarker(Marker marker) {
        Bitmap bitmap;
        Icon icon = marker.getIcon();
        int iconSize = this.mIcons.size() + 1;
        if (icon == null) {
            icon = IconFactory.getInstance(this.getContext()).defaultMarker();
            bitmap = icon.getBitmap();
            this.mAverageIconHeight += (bitmap.getHeight() / 2 - this.mAverageIconHeight) / iconSize;
            this.mAverageIconWidth = this.mAverageIconHeight + (bitmap.getWidth() - this.mAverageIconHeight) / iconSize;
            marker.setIcon(icon);
        } else {
            bitmap = icon.getBitmap();
            this.mAverageIconHeight += (bitmap.getHeight() - this.mAverageIconHeight) / iconSize;
            this.mAverageIconWidth = this.mAverageIconHeight + (bitmap.getWidth() - this.mAverageIconHeight) / iconSize;
        }
        if (!this.mIcons.contains(icon)) {
            this.mIcons.add(icon);
            this.loadIcon(icon);
        } else {
            Icon oldIcon = this.mIcons.get(this.mIcons.indexOf(icon));
            if (!oldIcon.getBitmap().sameAs(icon.getBitmap())) {
                throw new IconBitmapChangedException();
            }
        }
        return icon;
    }

    void loadIcon(Icon icon) {
        if (this.mDestroyed) {
            return;
        }
        Bitmap bitmap = icon.getBitmap();
        String id2 = icon.getId();
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        }
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        float density = bitmap.getDensity();
        if (density == 0.0f) {
            density = 160.0f;
        }
        float scale = density / 160.0f;
        this.mNativeMapView.addAnnotationIcon(id2, bitmap.getWidth(), bitmap.getHeight(), scale, buffer.array());
    }

    void reloadIcons() {
        int count = this.mIcons.size();
        for (int i = 0; i < count; ++i) {
            Icon icon = this.mIcons.get(i);
            this.loadIcon(icon);
        }
    }

    void updateMarker(@NonNull Marker updatedMarker) {
        if (this.mDestroyed) {
            return;
        }
        if (updatedMarker == null) {
            Log.w((String)"MapboxMap", (String)"marker was null, doing nothing");
            return;
        }
        if (updatedMarker.getId() == -1L) {
            Log.w((String)"MapboxMap", (String)"marker has an id of -1, possibly was not added yet, doing nothing");
        }
        this.ensureIconLoaded(updatedMarker);
        this.mNativeMapView.updateMarker(updatedMarker);
    }

    private void ensureIconLoaded(Marker marker) {
        Marker previousMarker;
        Icon icon = marker.getIcon();
        if (icon == null) {
            icon = IconFactory.getInstance(this.getContext()).defaultMarker();
            marker.setIcon(icon);
        }
        if (!this.mIcons.contains(icon)) {
            this.mIcons.add(icon);
            this.loadIcon(icon);
        } else {
            Icon oldIcon = this.mIcons.get(this.mIcons.indexOf(icon));
            if (!oldIcon.getBitmap().sameAs(icon.getBitmap())) {
                throw new IconBitmapChangedException();
            }
        }
        Marker marker2 = previousMarker = marker.getId() != -1L ? (Marker)this.mMapboxMap.getAnnotation(marker.getId()) : null;
        if (previousMarker == null || previousMarker.getIcon() == null || previousMarker.getIcon() != marker.getIcon()) {
            marker.setTopOffsetPixels(this.getTopOffsetPixelsForIcon(icon));
        }
    }

    long addMarker(@NonNull Marker marker) {
        return this.mNativeMapView.addMarker(marker);
    }

    long[] addMarkers(@NonNull List<Marker> markerList) {
        if (this.mDestroyed) {
            return new long[0];
        }
        return this.mNativeMapView.addMarkers(markerList);
    }

    long addPolyline(@NonNull Polyline polyline) {
        if (this.mDestroyed) {
            return 0L;
        }
        return this.mNativeMapView.addPolyline(polyline);
    }

    long[] addPolylines(@NonNull List<Polyline> polylines) {
        if (this.mDestroyed) {
            return new long[0];
        }
        return this.mNativeMapView.addPolylines(polylines);
    }

    long addPolygon(@NonNull Polygon polygon) {
        if (this.mDestroyed) {
            return 0L;
        }
        return this.mNativeMapView.addPolygon(polygon);
    }

    long[] addPolygons(@NonNull List<Polygon> polygons) {
        if (this.mDestroyed) {
            return new long[0];
        }
        return this.mNativeMapView.addPolygons(polygons);
    }

    void removeAnnotation(long id2) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.removeAnnotation(id2);
    }

    void removeAnnotations(@NonNull long[] ids) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.removeAnnotations(ids);
    }

    List<Marker> getMarkersInBounds(@NonNull LatLngBounds bbox) {
        if (this.mDestroyed || bbox == null) {
            return new ArrayList<Marker>();
        }
        long[] ids = this.mNativeMapView.getAnnotationsInBounds(bbox);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            idsList.add(ids[i]);
        }
        ArrayList<Marker> annotations = new ArrayList<Marker>(ids.length);
        List<Annotation> annotationList = this.mMapboxMap.getAnnotations();
        int count = annotationList.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (!(annotation instanceof Marker) || !idsList.contains(annotation.getId())) continue;
            annotations.add((Marker)annotation);
        }
        return new ArrayList<Marker>(annotations);
    }

    public List<MarkerView> getMarkerViewsInBounds(@NonNull LatLngBounds bbox) {
        if (this.mDestroyed || bbox == null) {
            return new ArrayList<MarkerView>();
        }
        long[] ids = this.mNativeMapView.getAnnotationsInBounds(bbox);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            idsList.add(ids[i]);
        }
        ArrayList<MarkerView> annotations = new ArrayList<MarkerView>(ids.length);
        List<Annotation> annotationList = this.mMapboxMap.getAnnotations();
        int count = annotationList.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (!(annotation instanceof MarkerView) || !idsList.contains(annotation.getId())) continue;
            annotations.add((MarkerView)annotation);
        }
        return new ArrayList<MarkerView>(annotations);
    }

    int getTopOffsetPixelsForIcon(Icon icon) {
        if (this.mDestroyed) {
            return 0;
        }
        return (int)(this.mNativeMapView.getTopOffsetPixelsForAnnotationSymbol(icon.getId()) * (double)this.mScreenDensity);
    }

    void setContentPadding(int left, int top, int right, int bottom) {
        if (this.mDestroyed) {
            return;
        }
        this.mContentPaddingLeft = left;
        this.mContentPaddingTop = top;
        this.mContentPaddingRight = right;
        this.mContentPaddingBottom = bottom;
        int[] userLocationViewPadding = this.mMapboxMap.getMyLocationViewSettings().getPadding();
        this.mNativeMapView.setContentPadding((float)(top += userLocationViewPadding[1]) / this.mScreenDensity, (float)(left += userLocationViewPadding[0]) / this.mScreenDensity, (float)(bottom += userLocationViewPadding[3]) / this.mScreenDensity, (float)(right += userLocationViewPadding[2]) / this.mScreenDensity);
    }

    public void invalidateContentPadding() {
        this.setContentPadding(this.mContentPaddingLeft, this.mContentPaddingTop, this.mContentPaddingRight, this.mContentPaddingBottom);
    }

    double getMetersPerPixelAtLatitude(@FloatRange(from=-180.0, to=180.0) double latitude) {
        if (this.mDestroyed) {
            return 0.0;
        }
        return this.mNativeMapView.getMetersPerPixelAtLatitude(latitude, this.getZoom()) / (double)this.mScreenDensity;
    }

    void jumpTo(double bearing, LatLng center, double pitch, double zoom) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.jumpTo(bearing, center, pitch, zoom);
    }

    void easeTo(double bearing, LatLng center, long duration, double pitch, double zoom, boolean easingInterpolator, final @Nullable MapboxMap.CancelableCallback cancelableCallback) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.cancelTransitions();
        if (cancelableCallback != null) {
            this.addOnMapChangedListener(new OnMapChangedListener(){

                @Override
                public void onMapChanged(int change) {
                    if (change == 4) {
                        cancelableCallback.onFinish();
                        MapView.this.removeOnMapChangedListener(this);
                    }
                }
            });
        }
        this.mNativeMapView.easeTo(bearing, center, duration, pitch, zoom, easingInterpolator);
    }

    void flyTo(double bearing, LatLng center, long duration, double pitch, double zoom, final @Nullable MapboxMap.CancelableCallback cancelableCallback) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.cancelTransitions();
        if (cancelableCallback != null) {
            this.addOnMapChangedListener(new OnMapChangedListener(){

                @Override
                public void onMapChanged(int change) {
                    if (change == 4) {
                        cancelableCallback.onFinish();
                        MapView.this.removeOnMapChangedListener(this);
                    }
                }
            });
        }
        this.mNativeMapView.flyTo(bearing, center, duration, pitch, zoom);
    }

    private void adjustTopOffsetPixels() {
        List<Annotation> annotations = this.mMapboxMap.getAnnotations();
        int count = annotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotations.get(i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.setTopOffsetPixels(this.getTopOffsetPixelsForIcon(marker.getIcon()));
        }
        for (Marker marker : this.mMapboxMap.getSelectedMarkers()) {
            if (!marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
            marker.showInfoWindow(this.mMapboxMap, this);
        }
    }

    private void reloadMarkers() {
        if (this.mDestroyed) {
            return;
        }
        List<Annotation> annotations = this.mMapboxMap.getAnnotations();
        int count = annotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotations.get(i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            this.mNativeMapView.removeAnnotation(annotation.getId());
            long newId = this.mNativeMapView.addMarker(marker);
            marker.setId(newId);
        }
    }

    protected void onInvalidate() {
        this.postInvalidate();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            return;
        }
        if (this.mDestroyed) {
            return;
        }
        if (!this.mHasSurface) {
            return;
        }
        this.mNativeMapView.render();
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        if (this.mDestroyed) {
            return;
        }
        if (!this.isInEditMode()) {
            this.mNativeMapView.resizeView((int)((float)width / this.mScreenDensity), (int)((float)height / this.mScreenDensity));
        }
    }

    double getScale() {
        if (this.mDestroyed) {
            return 0.0;
        }
        return this.mNativeMapView.getScale();
    }

    void update() {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.update();
    }

    CameraPosition invalidateCameraPosition() {
        if (this.mDestroyed) {
            return new CameraPosition.Builder().build();
        }
        return new CameraPosition.Builder(this.mNativeMapView.getCameraValues()).build();
    }

    double getBearing() {
        if (this.mDestroyed) {
            return 0.0;
        }
        return this.mNativeMapView.getBearing();
    }

    void setBearing(float bearing) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.setBearing(bearing);
    }

    void setBearing(float bearing, long duration) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.setBearing(bearing, duration);
    }

    @CallSuper
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mMapboxMap.getUiSettings().isZoomControlsEnabled()) {
            this.mZoomButtonsController.setVisible(false);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        if (this.mMapboxMap.getUiSettings().isZoomControlsEnabled() && visibility != 0) {
            this.mZoomButtonsController.setVisible(false);
        }
        if (this.mMapboxMap.getUiSettings().isZoomControlsEnabled() && visibility == 0) {
            this.mZoomButtonsController.setVisible(true);
        }
    }

    private void trackGestureEvent(@NonNull String gestureId, @NonNull float xCoordinate, @NonNull float yCoordinate) {
        LatLng tapLatLng = this.fromScreenLocation(new PointF(xCoordinate, yCoordinate));
        Hashtable<String, Object> evt = new Hashtable<String, Object>();
        evt.put("event", "map.click");
        evt.put("created", MapboxEventManager.generateCreateDate());
        evt.put("gesture", gestureId);
        evt.put("lat", tapLatLng.getLatitude());
        evt.put("lng", tapLatLng.getLongitude());
        evt.put("zoom", this.mMapboxMap.getCameraPosition().zoom);
        MapboxEventManager.getMapboxEventManager().pushEvent(evt);
    }

    private void trackGestureDragEndEvent(@NonNull float xCoordinate, @NonNull float yCoordinate) {
        LatLng tapLatLng = this.fromScreenLocation(new PointF(xCoordinate, yCoordinate));
        Hashtable<String, Object> evt = new Hashtable<String, Object>();
        evt.put("event", "map.dragend");
        evt.put("created", MapboxEventManager.generateCreateDate());
        evt.put("lat", tapLatLng.getLatitude());
        evt.put("lng", tapLatLng.getLongitude());
        evt.put("zoom", this.mMapboxMap.getCameraPosition().zoom);
        MapboxEventManager.getMapboxEventManager().pushEvent(evt);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.mDestroyed) {
            return super.onTouchEvent(event);
        }
        if (event.getButtonState() != 0 && event.getButtonState() != 1) {
            return false;
        }
        this.mRotateGestureDetector.onTouchEvent(event);
        this.mScaleGestureDetector.onTouchEvent(event);
        this.mShoveGestureDetector.onTouchEvent(event);
        switch (event.getActionMasked()) {
            case 0: {
                this.mNativeMapView.setGestureInProgress(true);
                break;
            }
            case 5: {
                boolean bl = this.mTwoTap = event.getPointerCount() == 2 && this.mMapboxMap.getUiSettings().isZoomGesturesEnabled();
                if (!this.mTwoTap) break;
                this.trackGestureEvent("TwoFingerTap", event.getX(), event.getY());
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                boolean inProgress;
                long tapInterval = event.getEventTime() - event.getDownTime();
                boolean isTap = tapInterval <= (long)ViewConfiguration.getTapTimeout();
                boolean bl = inProgress = this.mRotateGestureDetector.isInProgress() || this.mScaleGestureDetector.isInProgress() || this.mShoveGestureDetector.isInProgress();
                if (this.mTwoTap && isTap && !inProgress) {
                    PointF focalPoint = TwoFingerGestureDetector.determineFocalPoint(event);
                    this.zoom(false, focalPoint.x, focalPoint.y);
                    this.mTwoTap = false;
                    return true;
                }
                if (this.mScrollInProgress) {
                    this.trackGestureDragEndEvent(event.getX(), event.getY());
                    this.mScrollInProgress = false;
                }
                this.mTwoTap = false;
                this.mNativeMapView.setGestureInProgress(false);
                break;
            }
            case 3: {
                this.mTwoTap = false;
                this.mNativeMapView.setGestureInProgress(false);
            }
        }
        boolean retVal = this.mGestureDetector.onTouchEvent(event);
        return retVal || super.onTouchEvent(event);
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        if (this.mDestroyed) {
            return super.onKeyDown(keyCode, event);
        }
        double scrollDist = event.getRepeatCount() >= 5 ? 50.0 : 10.0;
        switch (keyCode) {
            case 23: 
            case 66: {
                event.startTracking();
                return true;
            }
            case 21: {
                if (!this.mMapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(scrollDist / (double)this.mScreenDensity, 0.0 / (double)this.mScreenDensity);
                return true;
            }
            case 22: {
                if (!this.mMapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(-scrollDist / (double)this.mScreenDensity, 0.0 / (double)this.mScreenDensity);
                return true;
            }
            case 19: {
                if (!this.mMapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(0.0 / (double)this.mScreenDensity, scrollDist / (double)this.mScreenDensity);
                return true;
            }
            case 20: {
                if (!this.mMapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(0.0 / (double)this.mScreenDensity, -scrollDist / (double)this.mScreenDensity);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.mMapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                    return false;
                }
                this.zoom(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (event.isCanceled()) {
            return super.onKeyUp(keyCode, event);
        }
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.mMapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                    return false;
                }
                this.zoom(true);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        if (this.mDestroyed) {
            return false;
        }
        switch (event.getActionMasked()) {
            case 2: {
                if (!this.mMapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(-10.0 * (double)event.getX() / (double)this.mScreenDensity, -10.0 * (double)event.getY() / (double)this.mScreenDensity);
                return true;
            }
            case 0: {
                if (this.mCurrentTrackballLongPressTimeOut != null) {
                    this.mCurrentTrackballLongPressTimeOut.cancel();
                    this.mCurrentTrackballLongPressTimeOut = null;
                }
                this.mCurrentTrackballLongPressTimeOut = new TrackballLongPressTimeOut();
                this.postDelayed(this.mCurrentTrackballLongPressTimeOut, ViewConfiguration.getLongPressTimeout());
                return true;
            }
            case 1: {
                if (!this.mMapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                    return false;
                }
                if (this.mCurrentTrackballLongPressTimeOut != null) {
                    this.zoom(true);
                }
                return true;
            }
            case 3: {
                if (this.mCurrentTrackballLongPressTimeOut != null) {
                    this.mCurrentTrackballLongPressTimeOut.cancel();
                    this.mCurrentTrackballLongPressTimeOut = null;
                }
                return true;
            }
        }
        return super.onTrackballEvent(event);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if (this.mDestroyed) {
            return false;
        }
        if ((event.getSource() & 2) == 2) {
            switch (event.getActionMasked()) {
                case 8: {
                    if (!this.mMapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                        return false;
                    }
                    this.mNativeMapView.cancelTransitions();
                    float scrollDist = event.getAxisValue(9);
                    this.mNativeMapView.scaleBy(Math.pow(2.0, scrollDist), event.getX() / this.mScreenDensity, event.getY() / this.mScreenDensity);
                    return true;
                }
            }
            return super.onGenericMotionEvent(event);
        }
        return super.onGenericMotionEvent(event);
    }

    public boolean onHoverEvent(@NonNull MotionEvent event) {
        switch (event.getActionMasked()) {
            case 7: 
            case 9: {
                if (this.mMapboxMap.getUiSettings().isZoomControlsEnabled()) {
                    this.mZoomButtonsController.setVisible(true);
                }
                return true;
            }
            case 10: {
                if (!this.mMapboxMap.getUiSettings().isZoomControlsEnabled()) break;
                this.mZoomButtonsController.setVisible(false);
            }
        }
        return super.onHoverEvent(event);
    }

    private boolean isConnected() {
        Context appContext = this.getContext().getApplicationContext();
        ConnectivityManager connectivityManager = (ConnectivityManager)appContext.getSystemService("connectivity");
        NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
    }

    private void onConnectivityChanged(boolean isConnected) {
        this.mNativeMapView.setReachability(isConnected);
    }

    public void addOnMapChangedListener(@Nullable OnMapChangedListener listener) {
        if (listener != null) {
            this.mOnMapChangedListener.add(listener);
        }
    }

    public void removeOnMapChangedListener(@Nullable OnMapChangedListener listener) {
        if (listener != null) {
            this.mOnMapChangedListener.remove(listener);
        }
    }

    protected void onMapChanged(int mapChange) {
        if (this.mOnMapChangedListener != null) {
            for (OnMapChangedListener listener : this.mOnMapChangedListener) {
                listener.onMapChanged(mapChange);
            }
        }
    }

    void setMyLocationEnabled(boolean enabled) {
        this.mMyLocationView.setEnabled(enabled);
    }

    Location getMyLocation() {
        return this.mMyLocationView.getLocation();
    }

    void setOnMyLocationChangeListener(final @Nullable MapboxMap.OnMyLocationChangeListener listener) {
        if (listener != null) {
            this.mMyLocationListener = new LocationListener(){

                @Override
                public void onLocationChanged(Location location) {
                    if (listener != null) {
                        listener.onMyLocationChange(location);
                    }
                }
            };
            LocationServices.getLocationServices(this.getContext()).addLocationListener(this.mMyLocationListener);
        } else {
            LocationServices.getLocationServices(this.getContext()).removeLocationListener(this.mMyLocationListener);
            this.mMyLocationListener = null;
        }
    }

    void setMyLocationTrackingMode(int myLocationTrackingMode) {
        if (myLocationTrackingMode != 0 && !this.mMapboxMap.isMyLocationEnabled()) {
            this.mMapboxMap.setMyLocationEnabled(true);
        }
        this.mMyLocationView.setMyLocationTrackingMode(myLocationTrackingMode);
        MapboxMap.OnMyLocationTrackingModeChangeListener listener = this.mMapboxMap.getOnMyLocationTrackingModeChangeListener();
        if (listener != null) {
            listener.onMyLocationTrackingModeChange(myLocationTrackingMode);
        }
    }

    void setMyBearingTrackingMode(int myBearingTrackingMode) {
        if (myBearingTrackingMode != 0 && !this.mMapboxMap.isMyLocationEnabled()) {
            this.mMapboxMap.setMyLocationEnabled(true);
        }
        this.mMyLocationView.setMyBearingTrackingMode(myBearingTrackingMode);
        MapboxMap.OnMyBearingTrackingModeChangeListener listener = this.mMapboxMap.getOnMyBearingTrackingModeChangeListener();
        if (listener != null) {
            listener.onMyBearingTrackingModeChange(myBearingTrackingMode);
        }
    }

    boolean isPermissionsAccepted() {
        return ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    private void resetTrackingModesIfRequired() {
        TrackingSettings trackingSettings = this.mMapboxMap.getTrackingSettings();
        if (trackingSettings.isDismissLocationTrackingOnGesture()) {
            this.resetLocationTrackingMode();
        }
        if (trackingSettings.isDismissBearingTrackingOnGesture()) {
            this.resetBearingTrackingMode();
        }
    }

    private void resetLocationTrackingMode() {
        try {
            TrackingSettings trackingSettings = this.mMapboxMap.getTrackingSettings();
            trackingSettings.setMyLocationTrackingMode(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void resetBearingTrackingMode() {
        try {
            this.setMyBearingTrackingMode(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    void setCompassEnabled(boolean compassEnabled) {
        this.mCompassView.setEnabled(compassEnabled);
    }

    void setCompassGravity(int gravity) {
        this.setWidgetGravity((View)this.mCompassView, gravity);
    }

    void setCompassMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.mCompassView, left, top, right, bottom);
    }

    void setLogoGravity(int gravity) {
        this.setWidgetGravity((View)this.mLogoView, gravity);
    }

    void setLogoMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.mLogoView, left, top, right, bottom);
    }

    void setLogoEnabled(boolean visible) {
        this.mLogoView.setVisibility(visible ? 0 : 8);
    }

    void setAttributionGravity(int gravity) {
        this.setWidgetGravity((View)this.mAttributionsView, gravity);
    }

    void setAttributionMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.mAttributionsView, left, top, right, bottom);
    }

    void setAttributionEnabled(int visibility) {
        this.mAttributionsView.setVisibility(visibility);
    }

    void setAtttibutionTintColor(int tintColor) {
        ColorUtils.setTintList(this.mAttributionsView, tintColor);
    }

    int getAttributionTintColor() {
        return this.mMapboxMap.getUiSettings().getAttributionTintColor();
    }

    @UiThread
    void addCustomLayer(CustomLayer customLayer, String before) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.addCustomLayer(customLayer, before);
    }

    @UiThread
    void removeCustomLayer(String id2) {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.removeCustomLayer(id2);
    }

    @UiThread
    void invalidateCustomLayers() {
        if (this.mDestroyed) {
            return;
        }
        this.mNativeMapView.update();
    }

    @UiThread
    public void getMapAsync(@NonNull OnMapReadyCallback callback) {
        if (!this.mInitialLoad) {
            callback.onMapReady(this.mMapboxMap);
        } else {
            this.mOnMapReadyCallbackList.add(callback);
        }
    }

    MapboxMap getMapboxMap() {
        return this.mMapboxMap;
    }

    void setMapboxMap(MapboxMap mapboxMap) {
        this.mMapboxMap = mapboxMap;
    }

    MyLocationView getUserLocationView() {
        return this.mMyLocationView;
    }

    @UiThread
    void snapshot(@NonNull MapboxMap.SnapshotReadyCallback callback, @Nullable Bitmap bitmap) {
        TextureView textureView = (TextureView)this.findViewById(R.id.textureView);
        boolean canUseBitmap = bitmap != null && textureView.getWidth() == bitmap.getWidth() && textureView.getHeight() == bitmap.getHeight();
        this.setDrawingCacheEnabled(true);
        Bitmap content = Bitmap.createBitmap((Bitmap)this.getDrawingCache());
        this.setDrawingCacheEnabled(false);
        Bitmap output = Bitmap.createBitmap((int)content.getWidth(), (int)content.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        canvas.drawBitmap(canUseBitmap ? textureView.getBitmap(bitmap) : textureView.getBitmap(), 0.0f, 0.0f, null);
        canvas.drawBitmap(content, new Matrix(), null);
        callback.onSnapshotReady(output);
    }

    private void setWidgetGravity(@NonNull View view, int gravity) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWidgetMargins(@NonNull View view, int left, int top, int right, int bottom) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.setMargins(left += this.mContentPaddingLeft, top += this.mContentPaddingTop, right += this.mContentPaddingRight, bottom += this.mContentPaddingBottom);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public static interface OnMapChangedListener {
        public void onMapChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MapChange {
    }

    static class StyleInitializer {
        private String mStyle;
        private boolean mDefaultStyle;

        StyleInitializer(@NonNull Context context) {
            this.mStyle = Style.getMapboxStreetsUrl(context.getResources().getInteger(R.integer.style_version));
            this.mDefaultStyle = true;
        }

        void setStyle(@NonNull String style2) {
            this.setStyle(style2, false);
        }

        void setStyle(@NonNull String style2, boolean defaultStyle) {
            if (style2 == null) {
                return;
            }
            this.mStyle = style2;
            this.mDefaultStyle = defaultStyle;
        }

        public String getStyle() {
            return this.mStyle;
        }

        boolean isDefaultStyle() {
            return this.mDefaultStyle;
        }
    }

    private static class ZoomInvalidator
    implements Runnable {
        private MapboxMap mapboxMap;

        public ZoomInvalidator(MapboxMap mapboxMap) {
            this.mapboxMap = mapboxMap;
        }

        @Override
        public void run() {
            this.mapboxMap.getCameraPosition();
        }
    }

    private static class AttributionOnClickListener
    implements View.OnClickListener,
    DialogInterface.OnClickListener {
        private static final int ATTRIBUTION_INDEX_IMPROVE_THIS_MAP = 2;
        private static final int ATTRIBUTION_INDEX_TELEMETRY_SETTINGS = 3;
        private MapView mMapView;

        public AttributionOnClickListener(MapView mapView) {
            this.mMapView = mapView;
        }

        public void onClick(View v) {
            Context context = v.getContext();
            Object[] items = context.getResources().getStringArray(R.array.attribution_names);
            AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.AttributionAlertDialogStyle);
            builder.setTitle(R.string.attributionsDialogTitle);
            builder.setAdapter((ListAdapter)new ArrayAdapter(context, R.layout.attribution_list_item, items), (DialogInterface.OnClickListener)this);
            AlertDialog dialog = builder.show();
            dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(this.mMapView.getAttributionTintColor()));
        }

        public void onClick(DialogInterface dialog, int which) {
            final Context context = ((Dialog)dialog).getContext();
            if (which == 3) {
                int array2 = R.array.attribution_telemetry_options;
                if (MapboxEventManager.getMapboxEventManager().isTelemetryEnabled()) {
                    array2 = R.array.attribution_telemetry_options_already_participating;
                }
                Object[] items = context.getResources().getStringArray(array2);
                AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.AttributionAlertDialogStyle);
                builder.setTitle(R.string.attributionTelemetryTitle);
                LayoutInflater factory = LayoutInflater.from((Context)context);
                View content = factory.inflate(R.layout.attribution_telemetry_view, null);
                ListView lv = (ListView)content.findViewById(R.id.telemetryOptionsList);
                lv.setAdapter((ListAdapter)new ArrayAdapter(context, R.layout.attribution_list_item, items));
                lv.setChoiceMode(1);
                builder.setView(content);
                final AlertDialog telemDialog = builder.show();
                lv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                        switch (position) {
                            case 0: {
                                String url = context.getResources().getStringArray(R.array.attribution_links)[3];
                                Intent intent = new Intent("android.intent.action.VIEW");
                                intent.setData(Uri.parse((String)url));
                                context.startActivity(intent);
                                telemDialog.cancel();
                                return;
                            }
                            case 1: {
                                MapboxEventManager.getMapboxEventManager().setTelemetryEnabled(false);
                                telemDialog.cancel();
                                return;
                            }
                            case 2: {
                                MapboxEventManager.getMapboxEventManager().setTelemetryEnabled(true);
                                telemDialog.cancel();
                                return;
                            }
                        }
                    }
                });
                return;
            }
            String url = context.getResources().getStringArray(R.array.attribution_links)[which];
            if (which == 2) {
                LatLng latLng = this.mMapView.getMapboxMap().getCameraPosition().target;
                url = String.format(url, latLng.getLongitude(), latLng.getLatitude(), (int)this.mMapView.getZoom());
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            context.startActivity(intent);
        }
    }

    private class ConnectivityReceiver
    extends BroadcastReceiver {
        private ConnectivityReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                boolean noConnectivity = intent.getBooleanExtra("noConnectivity", false);
                MapView.this.onConnectivityChanged(!noConnectivity);
            }
        }
    }

    private class TrackballLongPressTimeOut
    implements Runnable {
        private boolean cancelled = false;

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                MapView.this.zoom(false);
                MapView.this.mCurrentTrackballLongPressTimeOut = null;
            }
        }
    }

    private class OnZoomListener
    implements ZoomButtonsController.OnZoomListener {
        private OnZoomListener() {
        }

        public void onVisibilityChanged(boolean visible) {
        }

        public void onZoom(boolean zoomIn) {
            if (!MapView.this.mMapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                return;
            }
            MapView.this.zoom(zoomIn);
        }
    }

    private class ShoveGestureListener
    implements ShoveGestureDetector.OnShoveGestureListener {
        long mBeginTime = 0L;
        float mTotalDelta = 0.0f;
        boolean mStarted = false;

        private ShoveGestureListener() {
        }

        @Override
        public boolean onShoveBegin(ShoveGestureDetector detector) {
            if (!MapView.this.mMapboxMap.getUiSettings().isTiltGesturesEnabled()) {
                return false;
            }
            MapView.this.resetTrackingModesIfRequired();
            this.mBeginTime = detector.getEventTime();
            MapView.this.trackGestureEvent("Pitch", detector.getFocusX(), detector.getFocusY());
            return true;
        }

        @Override
        public void onShoveEnd(ShoveGestureDetector detector) {
            this.mBeginTime = 0L;
            this.mTotalDelta = 0.0f;
            this.mStarted = false;
        }

        @Override
        public boolean onShove(ShoveGestureDetector detector) {
            if (MapView.this.mDestroyed || !MapView.this.mMapboxMap.getUiSettings().isTiltGesturesEnabled()) {
                return false;
            }
            this.mTotalDelta += detector.getShovePixelsDelta();
            if (!MapView.this.mZoomStarted && (this.mTotalDelta > 10.0f || this.mTotalDelta < -10.0f)) {
                this.mStarted = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.mBeginTime;
            if (!this.mStarted && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!this.mStarted) {
                return false;
            }
            MapView.this.mNativeMapView.cancelTransitions();
            double pitch = MapView.this.getTilt();
            pitch -= 0.1 * (double)detector.getShovePixelsDelta();
            pitch = Math.max(0.0, Math.min(60.0, pitch));
            MapView.this.mMapboxMap.setTilt(pitch);
            return true;
        }
    }

    private class RotateGestureListener
    extends RotateGestureDetector.SimpleOnRotateGestureListener {
        long mBeginTime = 0L;
        float mTotalAngle = 0.0f;
        boolean mStarted = false;

        private RotateGestureListener() {
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector detector) {
            if (MapView.this.mDestroyed || !MapView.this.mMapboxMap.getUiSettings().isRotateGesturesEnabled()) {
                return false;
            }
            MapView.this.resetTrackingModesIfRequired();
            this.mBeginTime = detector.getEventTime();
            MapView.this.trackGestureEvent("Rotation", detector.getFocusX(), detector.getFocusY());
            return true;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector detector) {
            this.mBeginTime = 0L;
            this.mTotalAngle = 0.0f;
            this.mStarted = false;
        }

        @Override
        public boolean onRotate(RotateGestureDetector detector) {
            if (MapView.this.mDestroyed || !MapView.this.mMapboxMap.getUiSettings().isRotateGesturesEnabled()) {
                return false;
            }
            this.mTotalAngle += detector.getRotationDegreesDelta();
            if (!MapView.this.mZoomStarted && (this.mTotalAngle > 10.0f || this.mTotalAngle < -10.0f)) {
                this.mStarted = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.mBeginTime;
            if (!this.mStarted && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!this.mStarted) {
                return false;
            }
            MapView.this.mNativeMapView.cancelTransitions();
            double bearing = MapView.this.mNativeMapView.getBearing();
            bearing += (double)detector.getRotationDegreesDelta();
            if (MapView.this.mMapboxMap.getTrackingSettings().isLocationTrackingDisabled()) {
                MapView.this.mNativeMapView.setBearing(bearing, detector.getFocusX() / MapView.this.mScreenDensity, detector.getFocusY() / MapView.this.mScreenDensity);
            } else {
                float x = MapView.this.mMyLocationView.getX() + (float)(MapView.this.mMyLocationView.getWidth() / 2);
                float y = MapView.this.mMyLocationView.getY() + (float)(MapView.this.mMyLocationView.getHeight() / 2);
                MapView.this.mNativeMapView.setBearing(bearing, x / MapView.this.mScreenDensity, y / MapView.this.mScreenDensity);
            }
            return true;
        }
    }

    private class ScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        long mBeginTime = 0L;
        float mScaleFactor = 1.0f;

        private ScaleGestureListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            if (MapView.this.mDestroyed || !MapView.this.mMapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                return false;
            }
            MapView.this.resetTrackingModesIfRequired();
            this.mBeginTime = detector.getEventTime();
            MapView.this.trackGestureEvent("Pinch", detector.getFocusX(), detector.getFocusY());
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            this.mBeginTime = 0L;
            this.mScaleFactor = 1.0f;
            MapView.this.mZoomStarted = false;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            UiSettings uiSettings = MapView.this.mMapboxMap.getUiSettings();
            if (MapView.this.mDestroyed || !uiSettings.isZoomGesturesEnabled()) {
                return super.onScale(detector);
            }
            this.mScaleFactor *= detector.getScaleFactor();
            if (this.mScaleFactor > 1.05f || this.mScaleFactor < 0.95f) {
                MapView.this.mZoomStarted = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.mBeginTime;
            if (!MapView.this.mZoomStarted && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!MapView.this.mZoomStarted) {
                return false;
            }
            MapView.this.mNativeMapView.cancelTransitions();
            MapView.this.mQuickZoom = !MapView.this.mTwoTap;
            TrackingSettings trackingSettings = MapView.this.mMapboxMap.getTrackingSettings();
            if (uiSettings.isScrollGesturesEnabled() && !MapView.this.mQuickZoom && trackingSettings.isLocationTrackingDisabled()) {
                MapView.this.mNativeMapView.scaleBy(detector.getScaleFactor(), detector.getFocusX() / MapView.this.mScreenDensity, detector.getFocusY() / MapView.this.mScreenDensity);
            } else if (trackingSettings.isLocationTrackingDisabled()) {
                MapView.this.mNativeMapView.scaleBy(detector.getScaleFactor(), (float)(MapView.this.getWidth() / 2) / MapView.this.mScreenDensity, (float)(MapView.this.getHeight() / 2) / MapView.this.mScreenDensity);
            } else {
                float x = MapView.this.mMyLocationView.getX() + (float)(MapView.this.mMyLocationView.getWidth() / 2);
                float y = MapView.this.mMyLocationView.getY() + (float)(MapView.this.mMyLocationView.getHeight() / 2);
                MapView.this.mNativeMapView.scaleBy(detector.getScaleFactor(), x / MapView.this.mScreenDensity, y / MapView.this.mScreenDensity);
            }
            return true;
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        @SuppressLint(value={"ResourceType"})
        public boolean onDown(MotionEvent event) {
            if (MapView.this.mMapboxMap.getUiSettings().isZoomControlsEnabled()) {
                MapView.this.mZoomButtonsController.setVisible(true);
            }
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            if (MapView.this.mDestroyed || !MapView.this.mMapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                return false;
            }
            switch (e.getAction()) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (MapView.this.mQuickZoom) {
                        MapView.this.mQuickZoom = false;
                        break;
                    }
                    if (MapView.this.mMapboxMap.getTrackingSettings().isLocationTrackingDisabled()) {
                        MapView.this.zoom(true, e.getX(), e.getY());
                        break;
                    }
                    MapView.this.zoom(true, MapView.this.mMyLocationView.getCenterX(), MapView.this.mMyLocationView.getCenterY());
                }
            }
            MapView.this.trackGestureEvent("DoubleTap", e.getX(), e.getY());
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (MapView.this.mDestroyed) {
                return false;
            }
            MapView.this.mNativeMapView.cancelTransitions();
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            List<Marker> selectedMarkers = MapView.this.mMapboxMap.getSelectedMarkers();
            PointF tapPoint = new PointF(e.getX(), e.getY());
            float toleranceSides = 4.0f * MapView.this.mScreenDensity;
            float toleranceTopBottom = 10.0f * MapView.this.mScreenDensity;
            RectF tapRect = new RectF(tapPoint.x - (float)(MapView.this.mAverageIconWidth / 2) - toleranceSides, tapPoint.y - (float)(MapView.this.mAverageIconHeight / 2) - toleranceTopBottom, tapPoint.x + (float)(MapView.this.mAverageIconWidth / 2) + toleranceSides, tapPoint.y + (float)(MapView.this.mAverageIconHeight / 2) + toleranceTopBottom);
            LatLngBounds.Builder builder = new LatLngBounds.Builder();
            builder.include(MapView.this.fromScreenLocation(new PointF(tapRect.left, tapRect.bottom)));
            builder.include(MapView.this.fromScreenLocation(new PointF(tapRect.left, tapRect.top)));
            builder.include(MapView.this.fromScreenLocation(new PointF(tapRect.right, tapRect.top)));
            builder.include(MapView.this.fromScreenLocation(new PointF(tapRect.right, tapRect.bottom)));
            List<Marker> nearbyMarkers = MapView.this.getMarkersInBounds(builder.build());
            long newSelectedMarkerId = -1L;
            if (nearbyMarkers != null && nearbyMarkers.size() > 0) {
                Collections.sort(nearbyMarkers);
                for (Marker nearbyMarker : nearbyMarkers) {
                    boolean found = false;
                    for (Marker selectedMarker : selectedMarkers) {
                        if (!selectedMarker.equals(nearbyMarker)) continue;
                        found = true;
                    }
                    if (found) continue;
                    newSelectedMarkerId = nearbyMarker.getId();
                    break;
                }
            }
            if (newSelectedMarkerId >= 0L) {
                List<Annotation> annotations = MapView.this.mMapboxMap.getAnnotations();
                int count = annotations.size();
                for (int i = 0; i < count; ++i) {
                    Annotation annotation = annotations.get(i);
                    if (!(annotation instanceof Marker) || annotation.getId() != newSelectedMarkerId) continue;
                    if (!(!selectedMarkers.isEmpty() && selectedMarkers.contains(annotation) || annotation instanceof MarkerView)) {
                        MapView.this.mMapboxMap.selectMarker((Marker)annotation);
                    }
                    break;
                }
            } else {
                MapView.this.mMapboxMap.deselectMarkers();
                MapboxMap.OnMapClickListener listener = MapView.this.mMapboxMap.getOnMapClickListener();
                if (listener != null) {
                    LatLng point = MapView.this.fromScreenLocation(tapPoint);
                    listener.onMapClick(point);
                }
            }
            MapView.this.trackGestureEvent("SingleTap", e.getX(), e.getY());
            return true;
        }

        public void onLongPress(MotionEvent e) {
            MapboxMap.OnMapLongClickListener listener = MapView.this.mMapboxMap.getOnMapLongClickListener();
            if (listener != null && !MapView.this.mQuickZoom) {
                LatLng point = MapView.this.fromScreenLocation(new PointF(e.getX(), e.getY()));
                listener.onMapLongClick(point);
            }
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (MapView.this.mDestroyed || !MapView.this.mMapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                return false;
            }
            MapView.this.resetTrackingModesIfRequired();
            float ease = 0.25f;
            double speed = Math.sqrt((velocityX *= ease) * velocityX + (velocityY *= ease) * velocityY);
            double deceleration = 2500.0;
            double duration = speed / (deceleration * (double)ease);
            MapView.this.mNativeMapView.cancelTransitions();
            MapView.this.mNativeMapView.moveBy((double)velocityX * duration / 2.0 / (double)MapView.this.mScreenDensity, (double)velocityY * duration / 2.0 / (double)MapView.this.mScreenDensity, (long)(duration * 1000.0));
            MapboxMap.OnFlingListener listener = MapView.this.mMapboxMap.getOnFlingListener();
            if (listener != null) {
                listener.onFling();
            }
            MapView.this.trackGestureEvent("Pan", e1.getX(), e1.getY());
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!MapView.this.mScrollInProgress) {
                MapView.this.mScrollInProgress = true;
            }
            if (MapView.this.mDestroyed || !MapView.this.mMapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                return false;
            }
            MapView.this.resetTrackingModesIfRequired();
            MapView.this.mNativeMapView.cancelTransitions();
            MapView.this.mNativeMapView.moveBy(-distanceX / MapView.this.mScreenDensity, -distanceY / MapView.this.mScreenDensity);
            MapboxMap.OnScrollListener listener = MapView.this.mMapboxMap.getOnScrollListener();
            if (listener != null) {
                listener.onScroll();
            }
            return true;
        }
    }

    private class SurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        private Surface mSurface;
        private View mViewHolder;
        private static final int VIEW_MARKERS_POOL_SIZE = 20;

        private SurfaceTextureListener() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            this.mSurface = new Surface(surface);
            MapView.this.mNativeMapView.createSurface(this.mSurface);
            MapView.this.mNativeMapView.resizeFramebuffer(width, height);
            MapView.this.mHasSurface = true;
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            MapView.this.mHasSurface = false;
            if (MapView.this.mNativeMapView != null) {
                MapView.this.mNativeMapView.destroySurface();
            }
            this.mSurface.release();
            return true;
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            if (MapView.this.mDestroyed) {
                return;
            }
            MapView.this.mNativeMapView.resizeFramebuffer(width, height);
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            if (MapView.this.mDestroyed) {
                return;
            }
            MapView.this.mCompassView.update(MapView.this.getDirection());
            MapView.this.mMyLocationView.update();
            MapView.this.mMapboxMap.getMarkerViewManager().update();
            for (InfoWindow infoWindow : MapView.this.mMapboxMap.getInfoWindows()) {
                infoWindow.update();
            }
        }
    }
}

