/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.constants;

import com.mapbox.mapboxsdk.constants.MapboxConstants;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Style {
    private static final String MAPBOX_STREETS_BASE = "mapbox://styles/mapbox/streets-v%d";
    private static final String OUTDOORS_BASE = "mapbox://styles/mapbox/outdoors-v%d";
    private static final String LIGHT_BASE = "mapbox://styles/mapbox/light-v%d";
    private static final String DARK_BASE = "mapbox://styles/mapbox/dark-v%d";
    private static final String SATELLITE_BASE = "mapbox://styles/mapbox/satellite-v%d";
    private static final String SATELLITE_STREETS_BASE = "mapbox://styles/mapbox/satellite-streets-v%d";
    private static final String SATELLITE_STREETS_V8 = "mapbox://styles/mapbox/satellite-hybrid-v8";
    @Deprecated
    public static final String MAPBOX_STREETS = "mapbox://styles/mapbox/streets-v9";
    @Deprecated
    public static final String EMERALD = "mapbox://styles/mapbox/emerald-v8";
    @Deprecated
    public static final String LIGHT = "mapbox://styles/mapbox/light-v9";
    @Deprecated
    public static final String DARK = "mapbox://styles/mapbox/dark-v9";
    @Deprecated
    public static final String SATELLITE = "mapbox://styles/mapbox/satellite-v9";
    @Deprecated
    public static final String SATELLITE_STREETS = "mapbox://styles/mapbox/satellite-streets-v9";

    public static String getMapboxStreetsUrl(int version) {
        return String.format(MapboxConstants.MAPBOX_LOCALE, MAPBOX_STREETS_BASE, version);
    }

    public static String getOutdoorsStyleUrl(int version) {
        return String.format(MapboxConstants.MAPBOX_LOCALE, OUTDOORS_BASE, version);
    }

    public static String getLightStyleUrl(int version) {
        return String.format(MapboxConstants.MAPBOX_LOCALE, LIGHT_BASE, version);
    }

    public static String getDarkStyleUrl(int version) {
        return String.format(MapboxConstants.MAPBOX_LOCALE, DARK_BASE, version);
    }

    public static String getSatelliteStyleUrl(int version) {
        return String.format(MapboxConstants.MAPBOX_LOCALE, SATELLITE_BASE, version);
    }

    public static String getSatelliteStreetsStyleUrl(int version) {
        if (version == 8) {
            return SATELLITE_STREETS_V8;
        }
        return String.format(MapboxConstants.MAPBOX_LOCALE, SATELLITE_STREETS_BASE, version);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Deprecated
    public static @interface StyleUrl {
    }
}

