/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.graphics.PointF;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.Pools;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.utils.AnimatorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MarkerViewManager {
    private Map<MarkerView, View> mMarkerViewMap;
    private MapboxMap mapboxMap;
    private MapView mapView;
    private List<MapboxMap.MarkerViewAdapter> markerViewAdapters;
    private long mViewMarkerBoundsUpdateTime;
    private MapboxMap.OnMarkerViewClickListener onMarkerViewClickListener;

    public MarkerViewManager(@NonNull MapboxMap mapboxMap, @NonNull MapView mapView) {
        this.mapboxMap = mapboxMap;
        this.markerViewAdapters = new ArrayList<MapboxMap.MarkerViewAdapter>();
        this.mapView = mapView;
        this.mMarkerViewMap = new HashMap<MarkerView, View>();
    }

    public void animateRotation(@NonNull MarkerView marker, float rotation) {
        View convertView = this.mMarkerViewMap.get(marker);
        if (convertView != null) {
            AnimatorUtils.rotate(convertView, rotation);
        }
    }

    public void animateAlpha(@NonNull MarkerView marker, float alpha) {
        View convertView = this.mMarkerViewMap.get(marker);
        if (convertView != null) {
            AnimatorUtils.alpha(convertView, alpha);
        }
    }

    public void animateVisible(@NonNull MarkerView marker, boolean visible) {
        View convertView = this.mMarkerViewMap.get(marker);
        if (convertView != null) {
            convertView.setVisibility(visible ? 0 : 8);
        }
    }

    public void update() {
        for (MarkerView marker : this.mMarkerViewMap.keySet()) {
            View convertView = this.mMarkerViewMap.get(marker);
            if (convertView == null) continue;
            PointF point = this.mapboxMap.getProjection().toScreenLocation(marker.getPosition());
            int x = (int)(marker.getAnchorU() * (float)convertView.getMeasuredWidth());
            int y = (int)(marker.getAnchorV() * (float)convertView.getMeasuredHeight());
            marker.setOffsetX(x);
            marker.setOffsetY(y);
            convertView.setX(point.x - (float)x);
            convertView.setY(point.y - (float)y);
            if (!marker.isVisible() || convertView.getVisibility() != 8) continue;
            convertView.animate().cancel();
            convertView.setAlpha(0.0f);
            AnimatorUtils.alpha(convertView, 1.0f);
        }
    }

    public void setTilt(float tilt) {
        for (MarkerView markerView : this.mMarkerViewMap.keySet()) {
            View convertView;
            if (!markerView.isFlat() || (convertView = this.mMarkerViewMap.get(markerView)) == null) continue;
            markerView.setTilt(tilt);
            convertView.setRotationX(tilt);
        }
    }

    public void deselect(@NonNull MarkerView marker) {
        int deselectAnimatorRes;
        View convertView = this.mMarkerViewMap.get(marker);
        if (convertView != null && (deselectAnimatorRes = marker.getDeselectAnimRes()) != 0) {
            AnimatorUtils.animate(convertView, deselectAnimatorRes);
        }
    }

    public void removeMarkerView(MarkerView marker, boolean removeFromMap) {
        final View viewHolder = this.mMarkerViewMap.get(marker);
        if (viewHolder != null && marker != null) {
            for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                if (adapter.getMarkerClass() != marker.getClass()) continue;
                final Pools.SimplePool<View> viewPool = adapter.getViewReusePool();
                viewHolder.animate().cancel();
                viewHolder.setAlpha(1.0f);
                AnimatorUtils.alpha(viewHolder, 0.0f, new AnimatorUtils.OnAnimationEndListener(){

                    @Override
                    public void onAnimationEnd() {
                        viewHolder.setVisibility(8);
                        viewPool.release((Object)viewHolder);
                    }
                });
            }
        }
        if (removeFromMap) {
            this.mMarkerViewMap.remove(marker);
        }
    }

    public void addMarkerViewAdapter(@Nullable MapboxMap.MarkerViewAdapter markerViewAdapter) {
        if (!this.markerViewAdapters.contains(markerViewAdapter)) {
            this.markerViewAdapters.add(markerViewAdapter);
            this.invalidateViewMarkersInBounds();
        }
    }

    public void setOnMarkerViewClickListener(@Nullable MapboxMap.OnMarkerViewClickListener listener) {
        this.onMarkerViewClickListener = listener;
    }

    public List<MapboxMap.MarkerViewAdapter> getMarkerViewAdapters() {
        return this.markerViewAdapters;
    }

    public void invalidateViewMarkers() {
        if (!this.markerViewAdapters.isEmpty()) {
            long currentTime = SystemClock.elapsedRealtime();
            if (currentTime < this.mViewMarkerBoundsUpdateTime) {
                return;
            }
            this.invalidateViewMarkersInBounds();
            this.mViewMarkerBoundsUpdateTime = currentTime + 250L;
        }
    }

    public void invalidateViewMarkersInBounds() {
        View convertView;
        Projection projection = this.mapboxMap.getProjection();
        List<MarkerView> markers = this.mapView.getMarkerViewsInBounds(projection.getVisibleRegion().latLngBounds);
        Iterator<MarkerView> iterator = this.mMarkerViewMap.keySet().iterator();
        while (iterator.hasNext()) {
            MarkerView m = iterator.next();
            if (markers.contains(m)) continue;
            convertView = this.mMarkerViewMap.get(m);
            int deselectAnimRes = m.getDeselectAnimRes();
            if (deselectAnimRes != 0) {
                AnimatorUtils.animate(convertView, deselectAnimRes, 0);
            }
            this.removeMarkerView(m, false);
            iterator.remove();
        }
        for (final MarkerView marker : markers) {
            if (this.mMarkerViewMap.containsKey(marker)) continue;
            for (final MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                int selectAnimRes;
                View adaptedView;
                if (adapter.getMarkerClass() != marker.getClass() || (adaptedView = adapter.getView(marker, convertView = (View)adapter.getViewReusePool().acquire(), (ViewGroup)this.mapView)) == null) continue;
                adaptedView.setRotationX(marker.getTilt());
                adaptedView.setRotation(marker.getRotation());
                adaptedView.setAlpha(marker.getAlpha());
                adaptedView.setVisibility(marker.isVisible() ? 0 : 8);
                if (this.mapboxMap.getSelectedMarkers().contains(marker) && (selectAnimRes = marker.getSelectAnimRes()) != 0) {
                    AnimatorUtils.animate(convertView, selectAnimRes, 0);
                }
                final int animSelectRes = marker.getSelectAnimRes();
                adaptedView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        boolean clickHandled = false;
                        if (MarkerViewManager.this.onMarkerViewClickListener != null) {
                            clickHandled = MarkerViewManager.this.onMarkerViewClickListener.onMarkerClick(marker, v, adapter);
                        }
                        if (!clickHandled) {
                            int infoWindowOffsetX = (int)((float)adaptedView.getWidth() * marker.getInfoWindowAnchorU() - marker.getOffsetX());
                            int infoWindowOffsetY = (int)((float)adaptedView.getHeight() * marker.getInfoWindowAnchorV() - marker.getOffsetY());
                            marker.setTopOffsetPixels(infoWindowOffsetY);
                            marker.setRightOffsetPixels(infoWindowOffsetX);
                            if (animSelectRes != 0) {
                                AnimatorUtils.animate(v, animSelectRes, new AnimatorUtils.OnAnimationEndListener(){

                                    @Override
                                    public void onAnimationEnd() {
                                        MarkerViewManager.this.mapboxMap.selectMarker(marker);
                                    }
                                });
                            } else {
                                MarkerViewManager.this.mapboxMap.selectMarker(marker);
                            }
                        }
                    }
                });
                this.mMarkerViewMap.put(marker, adaptedView);
                if (convertView != null) continue;
                this.mapView.addView(adaptedView);
            }
        }
    }
}

