/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.ViewSettings;

public class UiSettings {
    private MapView mapView;
    private ViewSettings compassSettings;
    private ViewSettings logoSettings;
    private ViewSettings attributionSettings;
    private boolean rotateGesturesEnabled;
    private boolean tiltGesturesEnabled;
    private boolean zoomGesturesEnabled;
    private boolean zoomControlsEnabled;
    private boolean scrollGesturesEnabled;

    UiSettings(@NonNull MapView mapView) {
        this.mapView = mapView;
        this.compassSettings = new ViewSettings();
        this.logoSettings = new ViewSettings();
        this.attributionSettings = new ViewSettings();
    }

    public void setCompassEnabled(boolean compassEnabled) {
        this.compassSettings.setEnabled(compassEnabled);
        this.mapView.setCompassEnabled(compassEnabled);
    }

    public boolean isCompassEnabled() {
        return this.compassSettings.isEnabled();
    }

    @UiThread
    public void setCompassGravity(int gravity) {
        this.compassSettings.setGravity(gravity);
        this.mapView.setCompassGravity(gravity);
    }

    public int getCompassGravity() {
        return this.compassSettings.getGravity();
    }

    @UiThread
    public void setCompassMargins(int left, int top, int right, int bottom) {
        this.compassSettings.setMargins(new int[]{left, top, right, bottom});
        this.mapView.setCompassMargins(left, top, right, bottom);
    }

    public int getCompassMarginLeft() {
        return this.compassSettings.getMargins()[0];
    }

    public int getCompassMarginTop() {
        return this.compassSettings.getMargins()[1];
    }

    public int getCompassMarginRight() {
        return this.compassSettings.getMargins()[2];
    }

    public int getCompassMarginBottom() {
        return this.compassSettings.getMargins()[3];
    }

    public void setLogoEnabled(boolean enabled) {
        this.logoSettings.setEnabled(enabled);
        this.mapView.setLogoEnabled(enabled);
    }

    public boolean isLogoEnabled() {
        return this.logoSettings.isEnabled();
    }

    public void setLogoGravity(int gravity) {
        this.logoSettings.setGravity(gravity);
        this.mapView.setLogoGravity(gravity);
    }

    public int getLogoGravity() {
        return this.logoSettings.getGravity();
    }

    public void setLogoMargins(int left, int top, int right, int bottom) {
        this.logoSettings.setMargins(new int[]{left, top, right, bottom});
        this.mapView.setLogoMargins(left, top, right, bottom);
    }

    public int getLogoMarginLeft() {
        return this.logoSettings.getMargins()[0];
    }

    public int getLogoMarginTop() {
        return this.logoSettings.getMargins()[1];
    }

    public int getLogoMarginRight() {
        return this.logoSettings.getMargins()[2];
    }

    public int getLogoMarginBottom() {
        return this.logoSettings.getMargins()[3];
    }

    public void setAttributionEnabled(boolean enabled) {
        this.attributionSettings.setEnabled(enabled);
        this.mapView.setAttributionEnabled(enabled ? 0 : 8);
    }

    public boolean isAttributionEnabled() {
        return this.attributionSettings.isEnabled();
    }

    public void setAttributionGravity(int gravity) {
        this.attributionSettings.setGravity(gravity);
        this.mapView.setAttributionGravity(gravity);
    }

    public int getAttributionGravity() {
        return this.attributionSettings.getGravity();
    }

    public void setAttributionMargins(int left, int top, int right, int bottom) {
        this.attributionSettings.setMargins(new int[]{left, top, right, bottom});
        this.mapView.setAttributionMargins(left, top, right, bottom);
    }

    public int getAttributionMarginLeft() {
        return this.attributionSettings.getMargins()[0];
    }

    public int getAttributionMarginTop() {
        return this.attributionSettings.getMargins()[1];
    }

    public int getAttributionMarginRight() {
        return this.attributionSettings.getMargins()[2];
    }

    public int getAttributionMarginBottom() {
        return this.attributionSettings.getMargins()[3];
    }

    public void setRotateGesturesEnabled(boolean rotateGesturesEnabled) {
        this.rotateGesturesEnabled = rotateGesturesEnabled;
    }

    public boolean isRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    public void setTiltGesturesEnabled(boolean tiltGesturesEnabled) {
        this.tiltGesturesEnabled = tiltGesturesEnabled;
    }

    public boolean isTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    public void setZoomGesturesEnabled(boolean zoomGesturesEnabled) {
        this.zoomGesturesEnabled = zoomGesturesEnabled;
    }

    public boolean isZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    public void setZoomControlsEnabled(boolean zoomControlsEnabled) {
        this.zoomControlsEnabled = zoomControlsEnabled;
    }

    public boolean isZoomControlsEnabled() {
        return this.zoomControlsEnabled;
    }

    public void setScrollGesturesEnabled(boolean scrollGesturesEnabled) {
        this.scrollGesturesEnabled = scrollGesturesEnabled;
    }

    public boolean isScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    public void setAllGesturesEnabled(boolean enabled) {
        this.setScrollGesturesEnabled(enabled);
        this.setRotateGesturesEnabled(enabled);
        this.setTiltGesturesEnabled(enabled);
        this.setZoomGesturesEnabled(enabled);
    }

    public float getHeight() {
        return this.mapView.getMeasuredHeight();
    }

    public float getWidth() {
        return this.mapView.getMeasuredWidth();
    }

    public void invalidate() {
        this.mapView.setLogoMargins(this.getLogoMarginLeft(), this.getLogoMarginTop(), this.getLogoMarginRight(), this.getLogoMarginBottom());
        this.mapView.setCompassMargins(this.getCompassMarginLeft(), this.getCompassMarginTop(), this.getCompassMarginRight(), this.getCompassMarginBottom());
        this.mapView.setAttributionMargins(this.getAttributionMarginLeft(), this.getAttributionMarginTop(), this.getAttributionMarginRight(), this.getAttributionMarginBottom());
    }
}

