/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.http;

import android.text.TextUtils;
import android.util.Log;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class HTTPRequest
implements Callback {
    private static OkHttpClient mClient = new OkHttpClient();
    private final String LOG_TAG = HTTPRequest.class.getName();
    private static final int CONNECTION_ERROR = 0;
    private static final int TEMPORARY_ERROR = 1;
    private static final int PERMANENT_ERROR = 2;
    private ReentrantLock mLock = new ReentrantLock();
    private long mNativePtr = 0L;
    private Call mCall;
    private Request mRequest;

    private native void nativeOnFailure(int var1, String var2);

    private native void nativeOnResponse(int var1, String var2, String var3, String var4, String var5, byte[] var6);

    private HTTPRequest(long nativePtr, String resourceUrl, String userAgent, String etag, String modified) {
        this.mNativePtr = nativePtr;
        try {
            Request.Builder builder = new Request.Builder().url(resourceUrl).tag((Object)resourceUrl.toLowerCase(MapboxConstants.MAPBOX_LOCALE)).addHeader("User-Agent", userAgent);
            if (etag.length() > 0) {
                builder = builder.addHeader("If-None-Match", etag);
            } else if (modified.length() > 0) {
                builder = builder.addHeader("If-Modified-Since", modified);
            }
            this.mRequest = builder.build();
            this.mCall = mClient.newCall(this.mRequest);
            this.mCall.enqueue((Callback)this);
        }
        catch (Exception e) {
            this.onFailure(e);
        }
    }

    public void cancel() {
        this.mCall.cancel();
        this.mLock.lock();
        this.mNativePtr = 0L;
        this.mLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response response) throws IOException {
        byte[] body;
        if (response.isSuccessful()) {
            Log.v((String)this.LOG_TAG, (String)String.format("[HTTP] Request was successful (code = %d).", response.code()));
        } else {
            String message = !TextUtils.isEmpty((CharSequence)response.message()) ? response.message() : "No additional information";
            Log.d((String)this.LOG_TAG, (String)String.format("[HTTP] Request with response code = %d: %s", response.code(), message));
        }
        try {
            body = response.body().bytes();
        }
        catch (IOException e) {
            this.onFailure(e);
            return;
        }
        finally {
            response.body().close();
        }
        this.mLock.lock();
        if (this.mNativePtr != 0L) {
            this.nativeOnResponse(response.code(), response.header("ETag"), response.header("Last-Modified"), response.header("Cache-Control"), response.header("Expires"), body);
        }
        this.mLock.unlock();
    }

    public void onFailure(Call call, IOException e) {
        this.onFailure(e);
    }

    private void onFailure(Exception e) {
        Log.w((String)this.LOG_TAG, (String)String.format("[HTTP] Request could not be executed: %s", e.getMessage()));
        int type = 2;
        if (e instanceof UnknownHostException || e instanceof SocketException || e instanceof ProtocolException || e instanceof SSLException) {
            type = 0;
        } else if (e instanceof InterruptedIOException) {
            type = 1;
        }
        String errorMessage = e.getMessage() != null ? e.getMessage() : "Error processing the request";
        this.mLock.lock();
        if (this.mNativePtr != 0L) {
            this.nativeOnFailure(type, errorMessage);
        }
        this.mLock.unlock();
    }
}

