/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.VisibleRegion;
import com.mapbox.mapboxsdk.maps.MapView;

public class Projection {
    private MapView mMapView;

    Projection(@NonNull MapView mapView) {
        this.mMapView = mapView;
    }

    public double getMetersPerPixelAtLatitude(@FloatRange(from=-180.0, to=180.0) double latitude) {
        return this.mMapView.getMetersPerPixelAtLatitude(latitude);
    }

    public LatLng fromScreenLocation(PointF point) {
        return this.mMapView.fromScreenLocation(point);
    }

    public VisibleRegion getVisibleRegion() {
        LatLngBounds.Builder builder = new LatLngBounds.Builder();
        int viewportWidth = this.mMapView.getWidth();
        int viewportHeight = this.mMapView.getHeight();
        LatLng topLeft = this.fromScreenLocation(new PointF(0.0f, 0.0f));
        LatLng topRight = this.fromScreenLocation(new PointF((float)viewportWidth, 0.0f));
        LatLng bottomRight = this.fromScreenLocation(new PointF((float)viewportWidth, (float)viewportHeight));
        LatLng bottomLeft = this.fromScreenLocation(new PointF(0.0f, (float)viewportHeight));
        builder.include(topLeft).include(topRight).include(bottomRight).include(bottomLeft);
        return new VisibleRegion(topLeft, topRight, bottomLeft, bottomRight, builder.build());
    }

    public PointF toScreenLocation(LatLng location) {
        return this.mMapView.toScreenLocation(location);
    }

    public double calculateZoom(float minScale) {
        return Math.log(this.mMapView.getScale() * (double)minScale) / Math.log(2.0);
    }
}

