/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.location.Location;
import android.os.SystemClock;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.util.LongSparseArray;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.InfoWindow;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerOptions;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.layers.CustomLayer;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.TrackingSettings;
import com.mapbox.mapboxsdk.maps.UiSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MapboxMap {
    private MapView mMapView;
    private UiSettings mUiSettings;
    private TrackingSettings mTrackingSettings;
    private Projection mProjection;
    private CameraPosition mCameraPosition;
    private boolean mInvalidCameraPosition;
    private LongSparseArray<Annotation> mAnnotations;
    private List<Marker> mSelectedMarkers;
    private List<InfoWindow> mInfoWindows;
    private InfoWindowAdapter mInfoWindowAdapter;
    private boolean mMyLocationEnabled;
    private boolean mAllowConcurrentMultipleInfoWindows;
    private OnMapClickListener mOnMapClickListener;
    private OnMapLongClickListener mOnMapLongClickListener;
    private OnMarkerClickListener mOnMarkerClickListener;
    private OnInfoWindowClickListener mOnInfoWindowClickListener;
    private OnInfoWindowLongClickListener mOnInfoWindowLongClickListener;
    private OnInfoWindowCloseListener mOnInfoWindowCloseListener;
    private OnFlingListener mOnFlingListener;
    private OnScrollListener mOnScrollListener;
    private OnMyLocationTrackingModeChangeListener mOnMyLocationTrackingModeChangeListener;
    private OnMyBearingTrackingModeChangeListener mOnMyBearingTrackingModeChangeListener;
    private OnFpsChangedListener mOnFpsChangedListener;
    private OnCameraChangeListener mOnCameraChangeListener;
    private double mMaxZoomLevel = -1.0;
    private double mMinZoomLevel = -1.0;

    MapboxMap(@NonNull MapView mapView) {
        this.mMapView = mapView;
        this.mMapView.addOnMapChangedListener(new MapChangeCameraPositionListener());
        this.mUiSettings = new UiSettings(mapView);
        this.mTrackingSettings = new TrackingSettings(this.mMapView, this.mUiSettings);
        this.mProjection = new Projection(mapView);
        this.mAnnotations = new LongSparseArray();
        this.mSelectedMarkers = new ArrayList<Marker>();
        this.mInfoWindows = new ArrayList<InfoWindow>();
    }

    @UiThread
    public void setMinZoom(@FloatRange(from=0.0, to=21.0) double minZoom) {
        if (minZoom < 0.0 || minZoom > 21.0) {
            Log.e((String)"MapboxMap", (String)("Not setting minZoom, value is in unsupported range: " + minZoom));
            return;
        }
        this.mMinZoomLevel = minZoom;
        this.mMapView.setMinZoom(minZoom);
    }

    @UiThread
    public double getMinZoom() {
        if (this.mMinZoomLevel == -1.0) {
            this.mMinZoomLevel = this.mMapView.getMinZoom();
            return this.mMinZoomLevel;
        }
        return this.mMinZoomLevel;
    }

    @UiThread
    public void setMaxZoom(@FloatRange(from=0.0, to=21.0) double maxZoom) {
        if (maxZoom < 0.0 || maxZoom > 21.0) {
            Log.e((String)"MapboxMap", (String)("Not setting maxZoom, value is in unsupported range: " + maxZoom));
            return;
        }
        this.mMaxZoomLevel = maxZoom;
        this.mMapView.setMaxZoom(maxZoom);
    }

    @UiThread
    public double getMaxZoom() {
        if (this.mMaxZoomLevel == -1.0) {
            this.mMaxZoomLevel = this.mMapView.getMaxZoom();
            return this.mMaxZoomLevel;
        }
        return this.mMaxZoomLevel;
    }

    public UiSettings getUiSettings() {
        return this.mUiSettings;
    }

    public TrackingSettings getTrackingSettings() {
        return this.mTrackingSettings;
    }

    public Projection getProjection() {
        return this.mProjection;
    }

    public final CameraPosition getCameraPosition() {
        if (this.mInvalidCameraPosition) {
            this.invalidateCameraPosition();
        }
        return this.mCameraPosition;
    }

    public void setCameraPosition(@NonNull CameraPosition cameraPosition) {
        this.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition));
    }

    @UiThread
    public final void moveCamera(CameraUpdate update) {
        this.moveCamera(update, null);
    }

    @UiThread
    public final void moveCamera(CameraUpdate update, CancelableCallback callback) {
        this.mCameraPosition = update.getCameraPosition(this);
        this.mMapView.jumpTo(this.mCameraPosition.bearing, this.mCameraPosition.target, this.mCameraPosition.tilt, this.mCameraPosition.zoom);
        if (callback != null) {
            callback.onFinish();
        }
        this.invalidateCameraPosition();
    }

    @UiThread
    public final void easeCamera(CameraUpdate update) {
        this.easeCamera(update, 300);
    }

    @UiThread
    public final void easeCamera(CameraUpdate update, int durationMs) {
        this.easeCamera(update, durationMs, null);
    }

    @UiThread
    public final void easeCamera(CameraUpdate update, int durationMs, final CancelableCallback callback) {
        this.mCameraPosition = update.getCameraPosition(this);
        this.mMapView.easeTo(this.mCameraPosition.bearing, this.mCameraPosition.target, this.getDurationNano(durationMs), this.mCameraPosition.tilt, this.mCameraPosition.zoom, new CancelableCallback(){

            @Override
            public void onCancel() {
                if (callback != null) {
                    callback.onCancel();
                }
                MapboxMap.this.invalidateCameraPosition();
            }

            @Override
            public void onFinish() {
                if (callback != null) {
                    callback.onFinish();
                }
                MapboxMap.this.invalidateCameraPosition();
            }
        });
    }

    @UiThread
    public final void animateCamera(CameraUpdate update) {
        this.animateCamera(update, 300, null);
    }

    @UiThread
    public final void animateCamera(CameraUpdate update, CancelableCallback callback) {
        this.animateCamera(update, 300, callback);
    }

    @UiThread
    public final void animateCamera(CameraUpdate update, int durationMs) {
        this.animateCamera(update, durationMs, null);
    }

    @UiThread
    public final void animateCamera(CameraUpdate update, int durationMs, final CancelableCallback callback) {
        this.mCameraPosition = update.getCameraPosition(this);
        this.mMapView.flyTo(this.mCameraPosition.bearing, this.mCameraPosition.target, this.getDurationNano(durationMs), this.mCameraPosition.tilt, this.mCameraPosition.zoom, new CancelableCallback(){

            @Override
            public void onCancel() {
                if (callback != null) {
                    callback.onCancel();
                }
                MapboxMap.this.invalidateCameraPosition();
            }

            @Override
            public void onFinish() {
                if (MapboxMap.this.mOnCameraChangeListener != null) {
                    MapboxMap.this.mOnCameraChangeListener.onCameraChange(MapboxMap.this.mCameraPosition);
                }
                if (callback != null) {
                    callback.onFinish();
                }
                MapboxMap.this.invalidateCameraPosition();
            }
        });
    }

    private long getDurationNano(long durationMs) {
        return durationMs > 0L ? TimeUnit.NANOSECONDS.convert(durationMs, TimeUnit.MILLISECONDS) : 0L;
    }

    private void invalidateCameraPosition() {
        this.mInvalidCameraPosition = false;
        CameraPosition cameraPosition = this.mMapView.invalidateCameraPosition();
        if (cameraPosition != null) {
            this.mCameraPosition = cameraPosition;
        }
        if (this.mOnCameraChangeListener != null) {
            this.mOnCameraChangeListener.onCameraChange(this.mCameraPosition);
        }
    }

    public void resetNorth() {
        this.mMapView.resetNorth();
    }

    @UiThread
    public boolean isDebugActive() {
        return this.mMapView.isDebugActive();
    }

    @UiThread
    public void setDebugActive(boolean debugActive) {
        this.mMapView.setDebugActive(debugActive);
    }

    @UiThread
    public void cycleDebugOptions() {
        this.mMapView.cycleDebugOptions();
    }

    @UiThread
    public void setStyleUrl(@NonNull String url) {
        this.mMapView.setStyleUrl(url);
    }

    @UiThread
    public void setStyle(String style2) {
        this.setStyleUrl(style2);
    }

    @UiThread
    @NonNull
    public String getStyleUrl() {
        return this.mMapView.getStyleUrl();
    }

    @UiThread
    public void setAccessToken(@NonNull String accessToken) {
        this.mMapView.setAccessToken(accessToken);
    }

    @UiThread
    @Nullable
    public String getAccessToken() {
        return this.mMapView.getAccessToken();
    }

    @UiThread
    @NonNull
    public Marker addMarker(@NonNull MarkerOptions markerOptions) {
        return this.addMarker((BaseMarkerOptions)markerOptions);
    }

    @UiThread
    @NonNull
    public Marker addMarker(@NonNull BaseMarkerOptions markerOptions) {
        Marker marker = this.prepareMarker(markerOptions);
        long id2 = this.mMapView.addMarker(marker);
        marker.setMapboxMap(this);
        marker.setId(id2);
        this.mAnnotations.put(id2, (Object)marker);
        return marker;
    }

    @UiThread
    @NonNull
    public List<Marker> addMarkers(@NonNull List<MarkerOptions> markerOptionsList) {
        int count = markerOptionsList.size();
        ArrayList<Marker> markers = new ArrayList<Marker>(count);
        for (int i = 0; i < count; ++i) {
            MarkerOptions markerOptions = markerOptionsList.get(i);
            Marker marker = this.prepareMarker(markerOptions);
            markers.add(marker);
        }
        long[] ids = this.mMapView.addMarkers(markers);
        long id2 = 0L;
        for (int i = 0; i < markers.size(); ++i) {
            Marker m = (Marker)markers.get(i);
            m.setMapboxMap(this);
            id2 = ids != null ? ids[i] : ++id2;
            m.setId(id2);
            this.mAnnotations.put(id2, (Object)m);
        }
        return markers;
    }

    @UiThread
    public void updateMarker(@NonNull Marker updatedMarker) {
        this.mMapView.updateMarker(updatedMarker);
        int index = this.mAnnotations.indexOfKey(updatedMarker.getId());
        if (index > -1) {
            this.mAnnotations.setValueAt(index, (Object)updatedMarker);
        }
    }

    @UiThread
    @NonNull
    public Polyline addPolyline(@NonNull PolylineOptions polylineOptions) {
        Polyline polyline = polylineOptions.getPolyline();
        if (!polyline.getPoints().isEmpty()) {
            long id2 = this.mMapView.addPolyline(polyline);
            polyline.setMapboxMap(this);
            polyline.setId(id2);
            this.mAnnotations.put(id2, (Object)polyline);
        }
        return polyline;
    }

    @UiThread
    @NonNull
    public List<Polyline> addPolylines(@NonNull List<PolylineOptions> polylineOptionsList) {
        int count = polylineOptionsList.size();
        ArrayList<Polyline> polylines = new ArrayList<Polyline>(count);
        for (PolylineOptions options : polylineOptionsList) {
            Polyline polyline = options.getPolyline();
            if (polyline.getPoints().isEmpty()) continue;
            polylines.add(polyline);
        }
        long[] ids = this.mMapView.addPolylines(polylines);
        long id2 = 0L;
        for (int i = 0; i < polylines.size(); ++i) {
            Polyline p = (Polyline)polylines.get(i);
            p.setMapboxMap(this);
            id2 = ids != null ? ids[i] : ++id2;
            p.setId(id2);
            this.mAnnotations.put(id2, (Object)p);
        }
        return polylines;
    }

    @UiThread
    @NonNull
    public Polygon addPolygon(@NonNull PolygonOptions polygonOptions) {
        Polygon polygon = polygonOptions.getPolygon();
        if (!polygon.getPoints().isEmpty()) {
            long id2 = this.mMapView.addPolygon(polygon);
            polygon.setId(id2);
            polygon.setMapboxMap(this);
            this.mAnnotations.put(id2, (Object)polygon);
        }
        return polygon;
    }

    @UiThread
    @NonNull
    public List<Polygon> addPolygons(@NonNull List<PolygonOptions> polygonOptionsList) {
        Polygon polygon;
        int count = polygonOptionsList.size();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(count);
        for (PolygonOptions polygonOptions : polygonOptionsList) {
            polygon = polygonOptions.getPolygon();
            if (polygon.getPoints().isEmpty()) continue;
            polygons.add(polygon);
        }
        long[] ids = this.mMapView.addPolygons(polygons);
        long id2 = 0L;
        for (int i = 0; i < polygons.size(); ++i) {
            polygon = (Polygon)polygons.get(i);
            polygon.setMapboxMap(this);
            id2 = ids != null ? ids[i] : ++id2;
            polygon.setId(id2);
            this.mAnnotations.put(id2, (Object)polygon);
        }
        return polygons;
    }

    @UiThread
    public void removeMarker(@NonNull Marker marker) {
        this.removeAnnotation(marker);
    }

    @UiThread
    public void removePolyline(@NonNull Polyline polyline) {
        this.removeAnnotation(polyline);
    }

    @UiThread
    public void removePolygon(@NonNull Polygon polygon) {
        this.removeAnnotation(polygon);
    }

    @UiThread
    public void removeAnnotation(@NonNull Annotation annotation) {
        if (annotation instanceof Marker) {
            ((Marker)annotation).hideInfoWindow();
        }
        long id2 = annotation.getId();
        this.mMapView.removeAnnotation(id2);
        this.mAnnotations.remove(id2);
    }

    @UiThread
    public void removeAnnotation(long id2) {
        this.mMapView.removeAnnotation(id2);
        this.mAnnotations.remove(id2);
    }

    @UiThread
    public void removeAnnotations(@NonNull List<? extends Annotation> annotationList) {
        int count = annotationList.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (annotation instanceof Marker) {
                ((Marker)annotation).hideInfoWindow();
            }
            ids[i] = annotationList.get(i).getId();
        }
        this.mMapView.removeAnnotations(ids);
        for (long id2 : ids) {
            this.mAnnotations.remove(id2);
        }
    }

    @UiThread
    public void removeAnnotations() {
        int count = this.mAnnotations.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = this.mAnnotations.keyAt(i);
            Annotation annotation = (Annotation)this.mAnnotations.get(ids[i]);
            if (!(annotation instanceof Marker)) continue;
            ((Marker)annotation).hideInfoWindow();
        }
        this.mMapView.removeAnnotations(ids);
        this.mAnnotations.clear();
    }

    @UiThread
    @Nullable
    public Annotation getAnnotation(long id2) {
        return (Annotation)this.mAnnotations.get(id2);
    }

    @NonNull
    public List<Annotation> getAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < this.mAnnotations.size(); ++i) {
            annotations.add((Annotation)this.mAnnotations.get(this.mAnnotations.keyAt(i)));
        }
        return annotations;
    }

    @NonNull
    public List<Marker> getMarkers() {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (int i = 0; i < this.mAnnotations.size(); ++i) {
            Annotation annotation = (Annotation)this.mAnnotations.get(this.mAnnotations.keyAt(i));
            if (!(annotation instanceof Marker)) continue;
            markers.add((Marker)annotation);
        }
        return markers;
    }

    @NonNull
    public List<Polygon> getPolygons() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < this.mAnnotations.size(); ++i) {
            Annotation annotation = (Annotation)this.mAnnotations.get(this.mAnnotations.keyAt(i));
            if (!(annotation instanceof Polygon)) continue;
            polygons.add((Polygon)annotation);
        }
        return polygons;
    }

    @NonNull
    public List<Polyline> getPolylines() {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        for (int i = 0; i < this.mAnnotations.size(); ++i) {
            Annotation annotation = (Annotation)this.mAnnotations.get(this.mAnnotations.keyAt(i));
            if (!(annotation instanceof Polyline)) continue;
            polylines.add((Polyline)annotation);
        }
        return polylines;
    }

    @UiThread
    public void selectMarker(@NonNull Marker marker) {
        if (marker == null) {
            Log.w((String)"MapboxMap", (String)"marker was null, so just returning");
            return;
        }
        if (this.mSelectedMarkers.contains(marker)) {
            return;
        }
        if (!this.isAllowConcurrentMultipleOpenInfoWindows()) {
            this.deselectMarkers();
        }
        boolean handledDefaultClick = false;
        if (this.mOnMarkerClickListener != null) {
            handledDefaultClick = this.mOnMarkerClickListener.onMarkerClick(marker);
        }
        if (!handledDefaultClick && (this.isInfoWindowValidForMarker(marker) || this.getInfoWindowAdapter() != null)) {
            this.mInfoWindows.add(marker.showInfoWindow(this, this.mMapView));
        }
        this.mSelectedMarkers.add(marker);
    }

    @UiThread
    public void deselectMarkers() {
        if (this.mSelectedMarkers.isEmpty()) {
            return;
        }
        for (Marker marker : this.mSelectedMarkers) {
            if (!marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
        }
        this.mSelectedMarkers.clear();
    }

    @UiThread
    public void deselectMarker(@NonNull Marker marker) {
        if (!this.mSelectedMarkers.contains(marker)) {
            return;
        }
        if (marker.isInfoWindowShown()) {
            marker.hideInfoWindow();
        }
        this.mSelectedMarkers.remove(marker);
    }

    @UiThread
    public List<Marker> getSelectedMarkers() {
        return this.mSelectedMarkers;
    }

    private Marker prepareMarker(BaseMarkerOptions markerOptions) {
        Object marker = markerOptions.getMarker();
        Icon icon = this.mMapView.loadIconForMarker((Marker)marker);
        ((Marker)marker).setTopOffsetPixels(this.mMapView.getTopOffsetPixelsForIcon(icon));
        return marker;
    }

    @UiThread
    public void setInfoWindowAdapter(@Nullable InfoWindowAdapter infoWindowAdapter) {
        this.mInfoWindowAdapter = infoWindowAdapter;
    }

    @UiThread
    @Nullable
    public InfoWindowAdapter getInfoWindowAdapter() {
        return this.mInfoWindowAdapter;
    }

    @UiThread
    public void setAllowConcurrentMultipleOpenInfoWindows(boolean allow) {
        this.mAllowConcurrentMultipleInfoWindows = allow;
    }

    @UiThread
    public boolean isAllowConcurrentMultipleOpenInfoWindows() {
        return this.mAllowConcurrentMultipleInfoWindows;
    }

    List<InfoWindow> getInfoWindows() {
        return this.mInfoWindows;
    }

    private boolean isInfoWindowValidForMarker(@NonNull Marker marker) {
        return !TextUtils.isEmpty((CharSequence)marker.getTitle()) || !TextUtils.isEmpty((CharSequence)marker.getSnippet());
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.mMapView.setContentPadding(left, top, right, bottom);
        this.mUiSettings.invalidate();
        this.moveCamera(CameraUpdateFactory.newCameraPosition(new CameraPosition.Builder(this.mCameraPosition).build()));
    }

    public int[] getPadding() {
        return new int[]{this.mMapView.getContentPaddingLeft(), this.mMapView.getContentPaddingTop(), this.mMapView.getContentPaddingRight(), this.mMapView.getContentPaddingBottom()};
    }

    @UiThread
    public void setOnCameraChangeListener(@Nullable OnCameraChangeListener listener) {
        this.mOnCameraChangeListener = listener;
    }

    @UiThread
    public void setOnFpsChangedListener(@Nullable OnFpsChangedListener listener) {
        this.mOnFpsChangedListener = listener;
    }

    OnFpsChangedListener getOnFpsChangedListener() {
        return this.mOnFpsChangedListener;
    }

    @UiThread
    public void setOnScrollListener(@Nullable OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    OnScrollListener getOnScrollListener() {
        return this.mOnScrollListener;
    }

    @UiThread
    public void setOnFlingListener(@Nullable OnFlingListener listener) {
        this.mOnFlingListener = listener;
    }

    OnFlingListener getOnFlingListener() {
        return this.mOnFlingListener;
    }

    @UiThread
    public void setOnMapClickListener(@Nullable OnMapClickListener listener) {
        this.mOnMapClickListener = listener;
    }

    OnMapClickListener getOnMapClickListener() {
        return this.mOnMapClickListener;
    }

    @UiThread
    public void setOnMapLongClickListener(@Nullable OnMapLongClickListener listener) {
        this.mOnMapLongClickListener = listener;
    }

    OnMapLongClickListener getOnMapLongClickListener() {
        return this.mOnMapLongClickListener;
    }

    @UiThread
    public void setOnMarkerClickListener(@Nullable OnMarkerClickListener listener) {
        this.mOnMarkerClickListener = listener;
    }

    @UiThread
    public void setOnInfoWindowClickListener(@Nullable OnInfoWindowClickListener listener) {
        this.mOnInfoWindowClickListener = listener;
    }

    @UiThread
    public OnInfoWindowClickListener getOnInfoWindowClickListener() {
        return this.mOnInfoWindowClickListener;
    }

    @UiThread
    public void setOnInfoWindowLongClickListener(@Nullable OnInfoWindowLongClickListener listener) {
        this.mOnInfoWindowLongClickListener = listener;
    }

    public OnInfoWindowLongClickListener getOnInfoWindowLongClickListener() {
        return this.mOnInfoWindowLongClickListener;
    }

    public void setOnInfoWindowCloseListener(@Nullable OnInfoWindowCloseListener listener) {
        this.mOnInfoWindowCloseListener = listener;
    }

    @UiThread
    public OnInfoWindowCloseListener getOnInfoWindowCloseListener() {
        return this.mOnInfoWindowCloseListener;
    }

    @UiThread
    public boolean isMyLocationEnabled() {
        return this.mMyLocationEnabled;
    }

    @UiThread
    public void setMyLocationEnabled(boolean enabled) {
        if (!this.mMapView.isPermissionsAccepted()) {
            Log.e((String)"MapboxMap", (String)"Could not activate user location tracking: user did not accept the permission or permissions were not requested.");
            return;
        }
        this.mMyLocationEnabled = enabled;
        this.mMapView.setMyLocationEnabled(enabled);
    }

    @UiThread
    @Nullable
    public Location getMyLocation() {
        return this.mMapView.getMyLocation();
    }

    @UiThread
    public void setOnMyLocationChangeListener(@Nullable OnMyLocationChangeListener listener) {
        this.mMapView.setOnMyLocationChangeListener(listener);
    }

    @UiThread
    public void setOnMyLocationTrackingModeChangeListener(@Nullable OnMyLocationTrackingModeChangeListener listener) {
        this.mOnMyLocationTrackingModeChangeListener = listener;
    }

    OnMyLocationTrackingModeChangeListener getOnMyLocationTrackingModeChangeListener() {
        return this.mOnMyLocationTrackingModeChangeListener;
    }

    @UiThread
    public void setOnMyBearingTrackingModeChangeListener(@Nullable OnMyBearingTrackingModeChangeListener listener) {
        this.mOnMyBearingTrackingModeChangeListener = listener;
    }

    OnMyBearingTrackingModeChangeListener getOnMyBearingTrackingModeChangeListener() {
        return this.mOnMyBearingTrackingModeChangeListener;
    }

    @UiThread
    public void addCustomLayer(CustomLayer customLayer, String before) {
        this.mMapView.addCustomLayer(customLayer, before);
    }

    @UiThread
    public void removeCustomLayer(String id2) {
        this.mMapView.removeCustomLayer(id2);
    }

    @UiThread
    public void invalidateCustomLayers() {
        this.mMapView.invalidateCustomLayers();
    }

    MapView getMapView() {
        return this.mMapView;
    }

    public void invalidate() {
        this.mMapView.update();
    }

    private class MapChangeCameraPositionListener
    implements MapView.OnMapChangedListener {
        private static final long UPDATE_RATE_MS = 400L;
        private long mPreviousUpdateTimestamp = 0L;

        private MapChangeCameraPositionListener() {
        }

        @Override
        public void onMapChanged(int change) {
            if (change >= 0 && change <= 4) {
                MapboxMap.this.mInvalidCameraPosition = true;
                long currentTime = SystemClock.elapsedRealtime();
                if (currentTime < this.mPreviousUpdateTimestamp) {
                    return;
                }
                MapboxMap.this.invalidateCameraPosition();
                this.mPreviousUpdateTimestamp = currentTime + 400L;
            }
        }
    }

    public static interface CancelableCallback {
        public void onCancel();

        public void onFinish();
    }

    public static interface OnMyBearingTrackingModeChangeListener {
        public void onMyBearingTrackingModeChange(int var1);
    }

    public static interface OnMyLocationTrackingModeChangeListener {
        public void onMyLocationTrackingModeChange(int var1);
    }

    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(@Nullable Location var1);
    }

    public static interface InfoWindowAdapter {
        @Nullable
        public View getInfoWindow(@NonNull Marker var1);
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public boolean onInfoWindowClick(@NonNull Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(@NonNull Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(@NonNull LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(@NonNull LatLng var1);
    }

    public static interface OnFpsChangedListener {
        public void onFpsChanged(double var1);
    }

    public static interface OnCameraChangeListener {
        public void onCameraChange(CameraPosition var1);
    }

    public static interface OnScrollListener {
        public void onScroll();
    }

    public static interface OnFlingListener {
        public void onFling();
    }
}

