/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.geometry;

import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.mapboxsdk.geometry.IProjectedMeters;

public class ProjectedMeters
implements IProjectedMeters,
Parcelable {
    public static final Parcelable.Creator<ProjectedMeters> CREATOR = new Parcelable.Creator<ProjectedMeters>(){

        public ProjectedMeters createFromParcel(Parcel in) {
            return new ProjectedMeters(in);
        }

        public ProjectedMeters[] newArray(int size) {
            return new ProjectedMeters[size];
        }
    };
    private double northing;
    private double easting;

    public ProjectedMeters(double northing, double easting) {
        this.northing = northing;
        this.easting = easting;
    }

    public ProjectedMeters(ProjectedMeters projectedMeters) {
        this.northing = projectedMeters.northing;
        this.easting = projectedMeters.easting;
    }

    private ProjectedMeters(Parcel in) {
        this.northing = in.readDouble();
        this.easting = in.readDouble();
    }

    @Override
    public double getNorthing() {
        return this.northing;
    }

    @Override
    public double getEasting() {
        return this.easting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectedMeters projectedMeters = (ProjectedMeters)o;
        return Double.compare(projectedMeters.easting, this.easting) == 0 && Double.compare(projectedMeters.northing, this.northing) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.easting);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.northing);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "ProjectedMeters [northing=" + this.northing + ", easting=" + this.easting + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeDouble(this.northing);
        out.writeDouble(this.easting);
    }
}

