/*
 * Decompiled with CFR 0.152.
 */
package com.almeros.android.multitouch.gesturedetectors;

import android.content.Context;
import android.view.MotionEvent;
import com.almeros.android.multitouch.gesturedetectors.TwoFingerGestureDetector;

public class RotateGestureDetector
extends TwoFingerGestureDetector {
    private final OnRotateGestureListener mListener;
    private boolean mSloppyGesture;

    public RotateGestureDetector(Context context, OnRotateGestureListener listener) {
        super(context);
        this.mListener = listener;
    }

    @Override
    protected void handleStartProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 5: {
                this.resetState();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                this.mTimeDelta = 0L;
                this.updateStateByEvent(event);
                this.mSloppyGesture = this.isSloppyGesture(event);
                if (this.mSloppyGesture) break;
                this.mGestureInProgress = this.mListener.onRotateBegin(this);
                break;
            }
            case 2: {
                if (!this.mSloppyGesture) break;
                this.mSloppyGesture = this.isSloppyGesture(event);
                if (this.mSloppyGesture) break;
                this.mGestureInProgress = this.mListener.onRotateBegin(this);
                break;
            }
            case 6: {
                if (this.mSloppyGesture) break;
            }
        }
    }

    @Override
    protected void handleInProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 6: {
                this.updateStateByEvent(event);
                if (!this.mSloppyGesture) {
                    this.mListener.onRotateEnd(this);
                }
                this.resetState();
                break;
            }
            case 3: {
                if (!this.mSloppyGesture) {
                    this.mListener.onRotateEnd(this);
                }
                this.resetState();
                break;
            }
            case 2: {
                boolean updatePrevious;
                this.updateStateByEvent(event);
                if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(updatePrevious = this.mListener.onRotate(this))) break;
                this.mPrevEvent.recycle();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
            }
        }
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.mSloppyGesture = false;
    }

    public float getRotationDegreesDelta() {
        double diffRadians = Math.atan2(this.mPrevFingerDiffY, this.mPrevFingerDiffX) - Math.atan2(this.mCurrFingerDiffY, this.mCurrFingerDiffX);
        return (float)(diffRadians * 180.0 / Math.PI);
    }

    public static class SimpleOnRotateGestureListener
    implements OnRotateGestureListener {
        @Override
        public boolean onRotate(RotateGestureDetector detector) {
            return false;
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector detector) {
            return true;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector detector) {
        }
    }

    public static interface OnRotateGestureListener {
        public boolean onRotate(RotateGestureDetector var1);

        public boolean onRotateBegin(RotateGestureDetector var1);

        public void onRotateEnd(RotateGestureDetector var1);
    }
}

