/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.widgets;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.LocationListener;
import com.mapbox.mapboxsdk.location.LocationServices;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import java.lang.ref.WeakReference;

public final class UserLocationView
extends View {
    private MapboxMap mMapboxMap;
    private Projection mProjection;
    private boolean mShowMarker;
    private boolean mShowDirection;
    private boolean mShowAccuracy;
    private boolean mStaleMarker;
    private PointF mMarkerScreenPoint;
    private Matrix mMarkerScreenMatrix;
    private Paint mAccuracyPaintFill;
    private Paint mAccuracyPaintStroke;
    private Path mAccuracyPath;
    private RectF mAccuracyBounds;
    private Drawable mUserLocationDrawable;
    private RectF mUserLocationDrawableBoundsF;
    private Rect mUserLocationDrawableBounds;
    private Drawable mUserLocationBearingDrawable;
    private RectF mUserLocationBearingDrawableBoundsF;
    private Rect mUserLocationBearingDrawableBounds;
    private Drawable mUserLocationStaleDrawable;
    private RectF mUserLocationStaleDrawableBoundsF;
    private Rect mUserLocationStaleDrawableBounds;
    private Rect mDirtyRect;
    private RectF mDirtyRectF;
    private LatLng mMarkerCoordinate;
    private ValueAnimator mMarkerCoordinateAnimator;
    private float mGpsMarkerDirection;
    private float mCompassMarkerDirection;
    private ObjectAnimator mMarkerDirectionAnimator;
    private float mMarkerAccuracy;
    private ObjectAnimator mMarkerAccuracyAnimator;
    private LatLng mCurrentMapViewCoordinate;
    private double mCurrentBearing;
    private boolean mPaused = false;
    private Location mUserLocation;
    private UserLocationListener mUserLocationListener;
    private MapboxMap.OnMyLocationChangeListener mOnMyLocationChangeListener;
    private int mMyLocationTrackingMode;
    private int mMyBearingTrackingMode;
    private MyBearingListener mBearingChangeListener;

    public UserLocationView(Context context) {
        super(context);
        this.initialize(context);
    }

    public UserLocationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public UserLocationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.setEnabled(false);
        this.setWillNotDraw(false);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.setLayoutParams(lp);
        this.mBearingChangeListener = new MyBearingListener(context);
        Resources resources = context.getResources();
        int accuracyColor = ContextCompat.getColor((Context)context, (int)R.color.my_location_ring);
        float density = resources.getDisplayMetrics().density;
        this.mMarkerCoordinate = new LatLng(0.0, 0.0);
        this.mMarkerScreenPoint = new PointF();
        this.mMarkerScreenMatrix = new Matrix();
        this.mAccuracyPaintFill = new Paint();
        this.mAccuracyPaintFill.setAntiAlias(true);
        this.mAccuracyPaintFill.setStyle(Paint.Style.FILL);
        this.mAccuracyPaintFill.setColor(accuracyColor);
        this.mAccuracyPaintFill.setAlpha(63);
        this.mAccuracyPaintStroke = new Paint();
        this.mAccuracyPaintStroke.setAntiAlias(true);
        this.mAccuracyPaintStroke.setStyle(Paint.Style.STROKE);
        this.mAccuracyPaintStroke.setStrokeWidth(0.5f * density);
        this.mAccuracyPaintStroke.setColor(accuracyColor);
        this.mAccuracyPaintStroke.setAlpha(127);
        this.mAccuracyPath = new Path();
        this.mAccuracyBounds = new RectF();
        this.mUserLocationDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.my_location);
        this.mUserLocationDrawableBounds = new Rect(-this.mUserLocationDrawable.getIntrinsicWidth() / 2, -this.mUserLocationDrawable.getIntrinsicHeight() / 2, this.mUserLocationDrawable.getIntrinsicWidth() / 2, this.mUserLocationDrawable.getIntrinsicHeight() / 2);
        this.mUserLocationDrawableBoundsF = new RectF((float)(-this.mUserLocationDrawable.getIntrinsicWidth() / 2), (float)(-this.mUserLocationDrawable.getIntrinsicHeight() / 2), (float)(this.mUserLocationDrawable.getIntrinsicWidth() / 2), (float)(this.mUserLocationDrawable.getIntrinsicHeight() / 2));
        this.mUserLocationDrawable.setBounds(this.mUserLocationDrawableBounds);
        this.mUserLocationBearingDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.my_location_bearing);
        this.mUserLocationBearingDrawableBounds = new Rect(-this.mUserLocationBearingDrawable.getIntrinsicWidth() / 2, -this.mUserLocationBearingDrawable.getIntrinsicHeight() / 2, this.mUserLocationBearingDrawable.getIntrinsicWidth() / 2, this.mUserLocationBearingDrawable.getIntrinsicHeight() / 2);
        this.mUserLocationBearingDrawableBoundsF = new RectF((float)(-this.mUserLocationBearingDrawable.getIntrinsicWidth() / 2), (float)(-this.mUserLocationBearingDrawable.getIntrinsicHeight() / 2), (float)(this.mUserLocationBearingDrawable.getIntrinsicWidth() / 2), (float)(this.mUserLocationBearingDrawable.getIntrinsicHeight() / 2));
        this.mUserLocationBearingDrawable.setBounds(this.mUserLocationBearingDrawableBounds);
        this.mUserLocationStaleDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.my_location_stale);
        this.mUserLocationStaleDrawableBounds = new Rect(-this.mUserLocationStaleDrawable.getIntrinsicWidth() / 2, -this.mUserLocationStaleDrawable.getIntrinsicHeight() / 2, this.mUserLocationStaleDrawable.getIntrinsicWidth() / 2, this.mUserLocationStaleDrawable.getIntrinsicHeight() / 2);
        this.mUserLocationStaleDrawableBoundsF = new RectF((float)(-this.mUserLocationStaleDrawable.getIntrinsicWidth() / 2), (float)(-this.mUserLocationStaleDrawable.getIntrinsicHeight() / 2), (float)(this.mUserLocationStaleDrawable.getIntrinsicWidth() / 2), (float)(this.mUserLocationStaleDrawable.getIntrinsicHeight() / 2));
        this.mUserLocationStaleDrawable.setBounds(this.mUserLocationStaleDrawableBounds);
    }

    public void setMapboxMap(MapboxMap mapboxMap) {
        this.mMapboxMap = mapboxMap;
        this.mProjection = mapboxMap.getProjection();
    }

    public void onStart() {
        if (this.mMyBearingTrackingMode == 4) {
            this.mBearingChangeListener.onStart(this.getContext());
        }
    }

    public void onStop() {
        this.mBearingChangeListener.onStop();
        this.cancelAnimations();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mShowMarker) {
            return;
        }
        canvas.concat(this.mMarkerScreenMatrix);
        Drawable dotDrawable = this.mShowDirection ? this.mUserLocationBearingDrawable : this.mUserLocationDrawable;
        dotDrawable = this.mStaleMarker ? this.mUserLocationStaleDrawable : dotDrawable;
        RectF dotBounds = this.mShowDirection ? this.mUserLocationBearingDrawableBoundsF : this.mUserLocationDrawableBoundsF;
        dotBounds = this.mStaleMarker ? this.mUserLocationStaleDrawableBoundsF : dotBounds;
        boolean willDraw = true;
        if (Build.VERSION.SDK_INT >= 16 || !canvas.isHardwareAccelerated()) {
            willDraw = this.mShowAccuracy && !this.mStaleMarker && !canvas.quickReject(this.mAccuracyPath, Canvas.EdgeType.AA);
        }
        if (willDraw |= !canvas.quickReject(dotBounds, Canvas.EdgeType.AA)) {
            if (this.mShowAccuracy && !this.mStaleMarker) {
                canvas.drawPath(this.mAccuracyPath, this.mAccuracyPaintFill);
                canvas.drawPath(this.mAccuracyPath, this.mAccuracyPaintStroke);
            }
            dotDrawable.draw(canvas);
        }
    }

    public void setMyLocationTrackingMode(int myLocationTrackingMode) {
        this.mMyLocationTrackingMode = myLocationTrackingMode;
        if (myLocationTrackingMode != 0 && this.mUserLocation != null) {
            this.mMarkerCoordinate = new LatLng(this.mUserLocation.getLatitude(), this.mUserLocation.getLongitude());
            this.mMapboxMap.moveCamera(CameraUpdateFactory.newLatLng(new LatLng(this.mUserLocation)));
            this.mMarkerScreenMatrix.reset();
            this.mMarkerScreenPoint = this.getMarkerScreenPoint();
            this.mMarkerScreenMatrix.setTranslate(this.mMarkerScreenPoint.x, this.mMarkerScreenPoint.y);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setVisibility(enabled ? 0 : 4);
        this.toggleGps(enabled);
    }

    public void update() {
        if (this.isEnabled() && this.mShowMarker) {
            this.setVisibility(0);
            this.mStaleMarker = this.isStale(this.mUserLocation);
            if (this.mMyLocationTrackingMode == 0) {
                this.mMarkerScreenPoint = this.getMarkerScreenPoint();
                this.mMarkerScreenMatrix.reset();
                this.mMarkerScreenMatrix.setTranslate(this.mMarkerScreenPoint.x, this.mMarkerScreenPoint.y);
            } else if (this.mMyLocationTrackingMode == 4) {
                double bearing = this.mShowDirection ? (this.mMyBearingTrackingMode == 4 ? (double)this.mBearingChangeListener.getCompassBearing() : (double)this.mUserLocation.getBearing()) : this.mMapboxMap.getCameraPosition().bearing;
                if (this.mCurrentMapViewCoordinate == null) {
                    this.mCurrentMapViewCoordinate = this.mMapboxMap.getCameraPosition().target;
                }
                if (!this.mCurrentMapViewCoordinate.equals(this.mMarkerCoordinate) || this.mCurrentBearing != bearing) {
                    CameraPosition cameraPosition = new CameraPosition.Builder().target(this.mMarkerCoordinate).bearing(bearing).build();
                    this.mMapboxMap.animateCamera(CameraUpdateFactory.newCameraPosition(cameraPosition), 300, null);
                    this.mMarkerScreenMatrix.reset();
                    this.mMarkerScreenPoint = this.getMarkerScreenPoint();
                    this.mMarkerScreenMatrix.setTranslate(this.mMarkerScreenPoint.x, this.mMarkerScreenPoint.y);
                    this.mCurrentMapViewCoordinate = this.mMarkerCoordinate;
                    this.mCurrentBearing = bearing;
                }
            }
            if (this.mShowDirection) {
                if (this.mMyBearingTrackingMode == 4 && this.mMyLocationTrackingMode == 0) {
                    this.mMarkerScreenMatrix.preRotate((float)((double)this.mCompassMarkerDirection + this.mMapboxMap.getCameraPosition().bearing));
                } else if (this.mMyBearingTrackingMode == 8) {
                    if (this.mMyLocationTrackingMode == 0) {
                        this.mMarkerScreenMatrix.preRotate((float)((double)this.mGpsMarkerDirection + this.mMapboxMap.getCameraPosition().bearing));
                    } else {
                        this.mMarkerScreenMatrix.preRotate(this.mGpsMarkerDirection);
                    }
                }
            }
            if (this.mShowAccuracy && !this.mStaleMarker) {
                this.mAccuracyPath.reset();
                this.mAccuracyPath.addCircle(0.0f, 0.0f, (float)((double)this.mMarkerAccuracy / this.mMapboxMap.getProjection().getMetersPerPixelAtLatitude(this.mMarkerCoordinate.getLatitude())), Path.Direction.CW);
                this.mAccuracyPath.computeBounds(this.mAccuracyBounds, false);
                this.mAccuracyBounds.inset(-1.0f, -1.0f);
            }
            if (this.mDirtyRect == null) {
                this.mDirtyRect = new Rect();
                this.mDirtyRectF = new RectF();
            } else {
                this.invalidate(this.mDirtyRect);
            }
            RectF dotBounds = this.mShowDirection ? this.mUserLocationBearingDrawableBoundsF : this.mUserLocationDrawableBoundsF;
            dotBounds = this.mStaleMarker ? this.mUserLocationStaleDrawableBoundsF : dotBounds;
            RectF largerBounds = this.mShowAccuracy && !this.mStaleMarker && this.mAccuracyBounds.contains(dotBounds) ? this.mAccuracyBounds : dotBounds;
            this.mMarkerScreenMatrix.mapRect(this.mDirtyRectF, largerBounds);
            this.mDirtyRectF.roundOut(this.mDirtyRect);
            this.invalidate(this.mDirtyRect);
        } else {
            this.setVisibility(4);
        }
    }

    public Location getLocation() {
        return this.mUserLocation;
    }

    private void toggleGps(boolean enableGps) {
        LocationServices locationServices = LocationServices.getLocationServices(this.getContext());
        if (enableGps) {
            Location lastLocation = locationServices.getLastLocation();
            if (lastLocation != null) {
                this.setLocation(lastLocation);
            }
            if (this.mUserLocationListener == null) {
                this.mUserLocationListener = new UserLocationListener(this);
            }
            locationServices.addLocationListener(this.mUserLocationListener);
        } else {
            this.setLocation(null);
            locationServices.removeLocationListener(this.mUserLocationListener);
        }
        locationServices.toggleGPS(enableGps);
    }

    public void setMyBearingTrackingMode(int myBearingTrackingMode) {
        this.mMyBearingTrackingMode = myBearingTrackingMode;
        if (myBearingTrackingMode == 4) {
            this.mShowAccuracy = false;
            this.mShowDirection = true;
            this.mBearingChangeListener.onStart(this.getContext());
        } else {
            this.mBearingChangeListener.onStop();
            this.mShowDirection = myBearingTrackingMode == 8 ? this.mUserLocation != null && this.mUserLocation.hasBearing() : false;
        }
        this.update();
    }

    private boolean isStale(Location location) {
        if (location != null && this.mMyBearingTrackingMode != 4) {
            long ageInNanos = Build.VERSION.SDK_INT >= 17 ? SystemClock.elapsedRealtimeNanos() - location.getElapsedRealtimeNanos() : (System.currentTimeMillis() - location.getTime()) * 1000L * 1000L;
            long oneMinuteInNanos = 60000000000L;
            return ageInNanos > 60000000000L;
        }
        return false;
    }

    private void setLocation(Location location) {
        if (location == null) {
            this.mShowMarker = false;
            this.mShowDirection = false;
            this.mShowAccuracy = false;
            this.cancelAnimations();
            this.mUserLocation = null;
            return;
        }
        if (this.mMarkerCoordinateAnimator != null) {
            this.mMarkerCoordinateAnimator.end();
            this.mMarkerCoordinateAnimator = null;
        }
        if (this.mMarkerDirectionAnimator != null) {
            this.mMarkerDirectionAnimator.end();
            this.mMarkerDirectionAnimator = null;
        }
        if (this.mMarkerAccuracyAnimator != null) {
            this.mMarkerAccuracyAnimator.end();
            this.mMarkerAccuracyAnimator = null;
        }
        this.mShowMarker = true;
        LatLng previousCoordinate = this.mUserLocation == null ? new LatLng(location) : new LatLng(this.mUserLocation);
        if (this.mMyLocationTrackingMode == 0) {
            this.mMarkerCoordinateAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mMarkerCoordinateAnimator.setDuration(1000L);
            this.mMarkerCoordinateAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new MarkerCoordinateAnimatorListener(previousCoordinate, new LatLng(location)));
            this.mMarkerCoordinateAnimator.start();
            this.mMarkerCoordinate = new LatLng(location);
        } else {
            this.mMarkerCoordinate = new LatLng(location);
        }
        if (this.mMyLocationTrackingMode == 0 && this.mMyBearingTrackingMode == 8) {
            this.mShowDirection = location.hasBearing();
            if (this.mShowDirection) {
                float newDir;
                float oldDir;
                float diff;
                if (this.mUserLocation != null && this.mUserLocation.hasBearing()) {
                    this.mGpsMarkerDirection = this.mUserLocation.getBearing();
                }
                if ((diff = (oldDir = this.mGpsMarkerDirection) - (newDir = location.getBearing())) > 180.0f) {
                    newDir += 360.0f;
                } else if (diff < -180.0f) {
                    newDir -= 360.0f;
                }
                this.mMarkerDirectionAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"direction", (float[])new float[]{oldDir, newDir});
                this.mMarkerDirectionAnimator.setDuration(1000L);
                this.mMarkerDirectionAnimator.start();
            }
        } else if (this.mMyLocationTrackingMode == 4 && this.mMyBearingTrackingMode == 8) {
            this.mShowDirection = true;
            this.mGpsMarkerDirection = 0.0f;
        }
        this.mShowAccuracy = location.hasAccuracy();
        if (this.mShowAccuracy) {
            if (this.mUserLocation != null && this.mUserLocation.hasAccuracy()) {
                this.mMarkerAccuracy = this.mUserLocation.getAccuracy();
            }
            this.mMarkerAccuracyAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"accuracy", (float[])new float[]{location.getAccuracy()});
            this.mMarkerAccuracyAnimator.setDuration(1000L);
            this.mMarkerAccuracyAnimator.start();
        }
        this.mUserLocation = location;
        this.updateOnNextFrame();
        if (this.mOnMyLocationChangeListener != null) {
            this.mOnMyLocationChangeListener.onMyLocationChange(location);
        }
    }

    private void setCompass(float bearing) {
        if (this.mMyLocationTrackingMode == 0) {
            this.mShowDirection = true;
            float oldDir = this.mCompassMarkerDirection;
            float newDir = bearing;
            float diff = oldDir - newDir;
            if (diff > 180.0f) {
                newDir += 360.0f;
            } else if (diff < -180.0f) {
                newDir -= 360.0f;
            }
            this.mMarkerDirectionAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"direction", (float[])new float[]{oldDir, newDir});
            this.mMarkerDirectionAnimator.setDuration(1000L);
            this.mMarkerDirectionAnimator.start();
            this.mCompassMarkerDirection = bearing;
        } else if (this.mMyLocationTrackingMode == 4) {
            this.cancelAnimations();
            if (this.mMyBearingTrackingMode == 4) {
                this.mShowDirection = true;
                this.mGpsMarkerDirection = 0.0f;
                this.mCompassMarkerDirection = 0.0f;
                this.update();
            }
        }
    }

    void updateOnNextFrame() {
        this.mMapboxMap.invalidate();
    }

    public void onPause() {
        this.mPaused = true;
        this.toggleGps(false);
    }

    public void onResume() {
        this.mPaused = false;
        if (this.isEnabled()) {
            this.toggleGps(true);
        }
    }

    public void setOnMyLocationChangeListener(@Nullable MapboxMap.OnMyLocationChangeListener listener) {
        this.mOnMyLocationChangeListener = listener;
    }

    public float getDirection() {
        if (this.mMyBearingTrackingMode == 4) {
            return this.mCompassMarkerDirection;
        }
        return this.mGpsMarkerDirection;
    }

    public void setDirection(float direction) {
        if (this.mMyBearingTrackingMode == 4) {
            this.mCompassMarkerDirection = direction % 360.0f;
        } else {
            this.mGpsMarkerDirection = direction % 360.0f;
        }
        this.updateOnNextFrame();
    }

    public float getAccuracy() {
        return this.mMarkerAccuracy;
    }

    public void setAccuracy(float accuracy) {
        this.mMarkerAccuracy = accuracy;
        this.updateOnNextFrame();
    }

    public void cancelAnimations() {
        if (this.mMarkerCoordinateAnimator != null) {
            this.mMarkerCoordinateAnimator.cancel();
            this.mMarkerCoordinateAnimator = null;
        }
        if (this.mMarkerDirectionAnimator != null) {
            this.mMarkerDirectionAnimator.cancel();
            this.mMarkerDirectionAnimator = null;
        }
        if (this.mMarkerAccuracyAnimator != null) {
            this.mMarkerAccuracyAnimator.cancel();
            this.mMarkerAccuracyAnimator = null;
        }
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    public PointF getMarkerScreenPoint() {
        if (this.mMyLocationTrackingMode == 0) {
            this.mMarkerScreenPoint = this.mProjection.toScreenLocation(this.mMarkerCoordinate);
        } else {
            int[] contentPadding = this.mMapboxMap.getPadding();
            this.mMarkerScreenPoint = new PointF((float)((this.getMeasuredWidth() + contentPadding[0] - contentPadding[2]) / 2), (float)((this.getMeasuredHeight() - contentPadding[3] + contentPadding[1]) / 2));
        }
        return this.mMarkerScreenPoint;
    }

    private class MarkerCoordinateAnimatorListener
    implements ValueAnimator.AnimatorUpdateListener {
        private double mFromLat;
        private double mFromLng;
        private double mToLat;
        private double mToLng;

        private MarkerCoordinateAnimatorListener(LatLng from, LatLng to) {
            this.mFromLat = from.getLatitude();
            this.mFromLng = from.getLongitude();
            this.mToLat = to.getLatitude();
            this.mToLng = to.getLongitude();
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float frac = animation.getAnimatedFraction();
            double latitude = this.mFromLat + (this.mToLat - this.mFromLat) * (double)frac;
            double longitude = this.mFromLng + (this.mToLng - this.mFromLng) * (double)frac;
            UserLocationView.this.mMarkerCoordinate.setLatitude(latitude);
            UserLocationView.this.mMarkerCoordinate.setLongitude(longitude);
            UserLocationView.this.updateOnNextFrame();
        }
    }

    private static class UserLocationListener
    implements LocationListener {
        private WeakReference<UserLocationView> mUserLocationView;

        public UserLocationListener(UserLocationView userLocationView) {
            this.mUserLocationView = new WeakReference<UserLocationView>(userLocationView);
        }

        @Override
        public void onLocationChanged(Location location) {
            UserLocationView locationView = (UserLocationView)((Object)this.mUserLocationView.get());
            if (locationView != null && !locationView.isPaused()) {
                locationView.setLocation(location);
            }
        }
    }

    private class MyBearingListener
    implements SensorEventListener {
        private SensorManager mSensorManager;
        private Sensor mAccelerometer;
        private Sensor mMagnetometer;
        private float[] mLastAccelerometer = new float[3];
        private float[] mLastMagnetometer = new float[3];
        private boolean mLastAccelerometerSet = false;
        private boolean mLastMagnetometerSet = false;
        private float[] mR = new float[9];
        private float[] mOrientation = new float[3];
        private float mCurrentDegree = 0.0f;
        private static final int UPDATE_RATE_MS = 300;
        private float mCompassBearing;
        private long mCompassUpdateNextTimestamp = 0L;

        public MyBearingListener(Context context) {
            this.mSensorManager = (SensorManager)context.getSystemService("sensor");
            this.mAccelerometer = this.mSensorManager.getDefaultSensor(1);
            this.mMagnetometer = this.mSensorManager.getDefaultSensor(2);
        }

        public void onStart(Context context) {
            this.mSensorManager.registerListener((SensorEventListener)this, this.mAccelerometer, 1);
            this.mSensorManager.registerListener((SensorEventListener)this, this.mMagnetometer, 1);
        }

        public void onStop() {
            this.mSensorManager.unregisterListener((SensorEventListener)this, this.mAccelerometer);
            this.mSensorManager.unregisterListener((SensorEventListener)this, this.mMagnetometer);
        }

        public float getCompassBearing() {
            return this.mCurrentDegree;
        }

        public void onSensorChanged(SensorEvent event) {
            if (UserLocationView.this.mPaused) {
                return;
            }
            long currentTime = SystemClock.elapsedRealtime();
            if (currentTime < this.mCompassUpdateNextTimestamp) {
                return;
            }
            if (event.sensor == this.mAccelerometer) {
                System.arraycopy(event.values, 0, this.mLastAccelerometer, 0, event.values.length);
                this.mLastAccelerometerSet = true;
            } else if (event.sensor == this.mMagnetometer) {
                System.arraycopy(event.values, 0, this.mLastMagnetometer, 0, event.values.length);
                this.mLastMagnetometerSet = true;
            }
            if (this.mLastAccelerometerSet && this.mLastMagnetometerSet) {
                SensorManager.getRotationMatrix((float[])this.mR, null, (float[])this.mLastAccelerometer, (float[])this.mLastMagnetometer);
                SensorManager.getOrientation((float[])this.mR, (float[])this.mOrientation);
                float azimuthInRadians = this.mOrientation[0];
                this.mCompassBearing = (float)(Math.toDegrees(azimuthInRadians) + 360.0) % 360.0f;
                if (this.mCompassBearing < 0.0f) {
                    this.mCompassBearing += 360.0f;
                }
                if (this.mCompassBearing > this.mCurrentDegree + 15.0f || this.mCompassBearing < this.mCurrentDegree - 15.0f) {
                    this.mCurrentDegree = this.mCompassBearing;
                    UserLocationView.this.setCompass(this.mCurrentDegree);
                }
            }
            this.mCompassUpdateNextTimestamp = currentTime + 300L;
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

