/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.exceptions.TooManyIconsException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class IconFactory {
    private static final String ICON_ID_PREFIX = "com.mapbox.icons.icon_";
    private Context mContext;
    private static IconFactory sInstance;
    private Icon mDefaultMarker;
    private BitmapFactory.Options mOptions;
    private int mNextId = 0;

    public static synchronized IconFactory getInstance(@NonNull Context context) {
        if (sInstance == null) {
            sInstance = new IconFactory(context.getApplicationContext());
        }
        return sInstance;
    }

    private IconFactory(@NonNull Context context) {
        this.mContext = context;
        DisplayMetrics realMetrics = null;
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (Build.VERSION.SDK_INT >= 17) {
            realMetrics = new DisplayMetrics();
            wm.getDefaultDisplay().getRealMetrics(realMetrics);
        }
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mOptions = new BitmapFactory.Options();
        this.mOptions.inScaled = true;
        this.mOptions.inDensity = 160;
        this.mOptions.inTargetDensity = metrics.densityDpi;
        if (realMetrics != null) {
            this.mOptions.inScreenDensity = realMetrics.densityDpi;
        }
    }

    public Icon fromBitmap(@NonNull Bitmap bitmap) {
        if (this.mNextId < 0) {
            throw new TooManyIconsException();
        }
        String id = ICON_ID_PREFIX + ++this.mNextId;
        return new Icon(id, bitmap);
    }

    public Icon fromDrawable(@NonNull Drawable drawable2) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        return this.fromDrawable(drawable2, width, height);
    }

    public Icon fromDrawable(@NonNull Drawable drawable2, int width, int height) {
        if (width < 0 || height < 0) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Rect temp = drawable2.getBounds();
        Rect bounds = new Rect(0, 0, width, height);
        drawable2.setBounds(bounds);
        drawable2.draw(canvas);
        drawable2.setBounds(temp);
        return this.fromBitmap(bitmap);
    }

    public Icon fromResource(@DrawableRes int resourceId) {
        Bitmap bitmap;
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)resourceId);
        if (drawable2 instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
            bitmap = bitmapDrawable.getBitmap();
        } else {
            bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        return this.fromBitmap(bitmap);
    }

    public Icon defaultMarker() {
        if (this.mDefaultMarker == null) {
            this.mDefaultMarker = this.fromResource(R.drawable.default_marker);
        }
        return this.mDefaultMarker;
    }

    private Icon fromInputStream(@NonNull InputStream is) {
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)this.mOptions);
        return this.fromBitmap(bitmap);
    }

    public Icon fromAsset(@NonNull String assetName) {
        InputStream is;
        try {
            is = this.mContext.getAssets().open(assetName);
        }
        catch (IOException e) {
            return null;
        }
        return this.fromInputStream(is);
    }

    public Icon fromPath(@NonNull String absolutePath) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)absolutePath, (BitmapFactory.Options)this.mOptions);
        return this.fromBitmap(bitmap);
    }

    public Icon fromFile(@NonNull String fileName) {
        FileInputStream is;
        try {
            is = this.mContext.openFileInput(fileName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return this.fromInputStream(is);
    }

    public static Icon recreate(@NonNull String iconId, @NonNull Bitmap bitmap) {
        return new Icon(iconId, bitmap);
    }
}

