/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import android.location.Location;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.location.LocationListener;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.api.LostApiClient;
import java.util.ArrayList;
import java.util.List;

public class LocationServices
implements com.mapzen.android.lost.api.LocationListener {
    private static LocationServices instance = null;
    private LostApiClient mLocationClient;
    private LocationRequest mLocationRequest;
    private Location lastLocation = null;
    private List<LocationListener> locationListeners = null;
    private boolean isGPSEnabled = false;

    private LocationServices(Context context) {
        this.mLocationClient = new LostApiClient.Builder(context).build();
        this.locationListeners = new ArrayList<LocationListener>();
    }

    public static LocationServices getLocationServices(@NonNull Context context) {
        if (instance == null) {
            if (context == null) {
                throw new NullPointerException("Context required for accessing LocationServices");
            }
            instance = new LocationServices(context.getApplicationContext());
        }
        return instance;
    }

    public void toggleGPS(boolean enableGPS) {
        if (enableGPS) {
            if (this.mLocationClient.isConnected()) {
                com.mapzen.android.lost.api.LocationServices.FusedLocationApi.removeLocationUpdates((com.mapzen.android.lost.api.LocationListener)this);
                this.mLocationClient.disconnect();
            }
            this.mLocationClient.connect();
            Location lastLocation = com.mapzen.android.lost.api.LocationServices.FusedLocationApi.getLastLocation();
            if (lastLocation != null) {
                this.lastLocation = lastLocation;
            }
            this.mLocationRequest = LocationRequest.create().setFastestInterval(1000L).setSmallestDisplacement(3.0f).setPriority(100);
            com.mapzen.android.lost.api.LocationServices.FusedLocationApi.requestLocationUpdates(this.mLocationRequest, (com.mapzen.android.lost.api.LocationListener)this);
        } else if (this.mLocationClient.isConnected()) {
            com.mapzen.android.lost.api.LocationServices.FusedLocationApi.removeLocationUpdates((com.mapzen.android.lost.api.LocationListener)this);
            this.mLocationClient.disconnect();
        }
        this.isGPSEnabled = enableGPS;
    }

    public boolean isGPSEnabled() {
        return this.isGPSEnabled;
    }

    public void onLocationChanged(Location location) {
        this.lastLocation = location;
        for (LocationListener listener : this.locationListeners) {
            listener.onLocationChanged(location);
        }
    }

    public Location getLastLocation() {
        return this.lastLocation;
    }

    public void addLocationListener(@NonNull LocationListener locationListener) {
        this.locationListeners.add(locationListener);
    }

    public boolean removeLocationListener(@NonNull LocationListener locationListener) {
        return this.locationListeners.remove(locationListener);
    }
}

