/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import com.mapbox.mapboxsdk.R;

final class InfoWindowTipView
extends View {
    private Paint mPaint;
    private Path mPath = new Path();
    private int mLineWidth;

    public InfoWindowTipView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mLineWidth = (int)context.getResources().getDimension(R.dimen.infowindow_line_width);
        this.mPaint = new Paint();
        this.mPaint.setColor(-1);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(0.0f);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int height = this.getMeasuredHeight();
        int width = this.getMeasuredWidth();
        this.mPath.rewind();
        this.mPaint.setColor(-1);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(0.0f);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPath.moveTo(0.0f, 0.0f);
        this.mPath.lineTo((float)width, 0.0f);
        this.mPath.lineTo((float)(width / 2), (float)height);
        this.mPath.lineTo(0.0f, 0.0f);
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPath.rewind();
        this.mPaint.setColor(Color.parseColor((String)"#C2C2C2"));
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth((float)this.mLineWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPath.moveTo(0.0f, 0.0f);
        this.mPath.lineTo((float)(width / 2), (float)height);
        this.mPath.lineTo((float)width, 0.0f);
        canvas.drawPath(this.mPath, this.mPaint);
    }
}

