/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.views.MapView;
import java.lang.ref.WeakReference;

final class CompassView
extends ImageView {
    public CompassView(Context context) {
        super(context);
        this.initialize(context);
    }

    public CompassView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public CompassView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.compass));
        this.setContentDescription(this.getResources().getString(R.string.compassContentDescription));
        float mScreenDensity = context.getResources().getDisplayMetrics().density;
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int)(48.0f * mScreenDensity), (int)(48.0f * mScreenDensity));
        this.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setVisibility(enabled ? 0 : 4);
    }

    public static class CompassClickListener
    implements View.OnClickListener {
        private WeakReference<MapView> mMapView;

        public CompassClickListener(MapView mapView) {
            this.mMapView = new WeakReference<MapView>(mapView);
        }

        public void onClick(View v) {
            MapView mapView = (MapView)((Object)this.mMapView.get());
            if (mapView != null) {
                mapView.resetNorth();
            }
        }
    }
}

