/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import java.util.ArrayList;
import java.util.List;

public final class PolygonOptions {
    private Polygon polygon = new Polygon();

    public PolygonOptions add(LatLng point) {
        this.polygon.addPoint(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    private PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> hole = new ArrayList<LatLng>();
        for (LatLng point : points) {
            hole.add(point);
        }
        this.polygon.addHole(hole);
        return this;
    }

    public PolygonOptions alpha(float alpha) {
        this.polygon.setAlpha(alpha);
        return this;
    }

    public float getAlpha() {
        return this.polygon.getAlpha();
    }

    public PolygonOptions fillColor(int color) {
        this.polygon.setFillColor(color);
        return this;
    }

    public int getFillColor() {
        return this.polygon.getFillColor();
    }

    private List<List<LatLng>> getHoles() {
        return this.polygon.getHoles();
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public int getStrokeColor() {
        return this.polygon.getStrokeColor();
    }

    private float getStrokeWidth() {
        return this.polygon.getStrokeWidth();
    }

    public PolygonOptions strokeColor(int color) {
        this.polygon.setStrokeColor(color);
        return this;
    }

    private PolygonOptions strokeWidth(float width) {
        this.polygon.setStrokeWidth(width);
        return this;
    }

    private PolygonOptions visible(boolean visible) {
        this.polygon.setVisible(visible);
        return this;
    }

    private boolean isVisible() {
        return this.polygon.isVisible();
    }

    public List<LatLng> getPoints() {
        return this.polygon.getPoints();
    }
}

