/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.renderer;

import android.graphics.Canvas;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.overlay.Overlay;
import com.mapbox.mapboxsdk.views.MapView;
import com.spatialdev.osm.model.JTSModel;
import com.spatialdev.osm.model.OSMElement;
import com.spatialdev.osm.model.OSMNode;
import com.spatialdev.osm.model.OSMWay;
import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.List;

public class OSMOverlay
extends Overlay {
    private static final int DEFAULT_OVERLAY_INDEX = 4;
    private JTSModel model;
    private Envelope envelope;

    public OSMOverlay(JTSModel model) {
        this.model = model;
        this.setOverlayIndex(4);
    }

    public void updateBoundingBox(BoundingBox bbox) {
        double x1 = bbox.getLonWest();
        double x2 = bbox.getLonEast();
        double y1 = bbox.getLatSouth();
        double y2 = bbox.getLatNorth();
        this.envelope = new Envelope(x1, x2, y1, y2);
    }

    @Override
    protected void draw(Canvas c, MapView mapView, boolean shadow) {
        if (shadow || this.envelope == null) {
            return;
        }
        ArrayList<OSMWay> polys = new ArrayList<OSMWay>();
        ArrayList<OSMWay> lines = new ArrayList<OSMWay>();
        ArrayList<OSMNode> points = new ArrayList<OSMNode>();
        List<OSMElement> viewPortElements = this.model.queryFromEnvelope(this.envelope);
        for (OSMElement el : viewPortElements) {
            if (el instanceof OSMWay) {
                OSMWay w = (OSMWay)el;
                if (w.isClosed()) {
                    polys.add(w);
                    continue;
                }
                lines.add(w);
                continue;
            }
            points.add((OSMNode)el);
        }
        for (OSMWay w : polys) {
            w.getOSMPath(mapView).draw(c);
        }
        for (OSMWay w : lines) {
            w.getOSMPath(mapView).draw(c);
        }
    }
}

