/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.util;

import com.mapbox.mapboxsdk.geometry.LatLng;

public class MathUtils {
    public static double getDistance(LatLng cluster, LatLng marker) {
        return Math.pow(marker.getLatitude() * 2.0 - cluster.getLatitude() * 2.0, 2.0) + Math.pow(marker.getLongitude() - cluster.getLongitude(), 2.0);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static double factorial(double n) {
        double fact = 1.0;
        int i = 1;
        while ((double)i <= n) {
            fact *= (double)i;
            ++i;
        }
        return fact;
    }
}

