/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider;

import android.content.Context;
import com.mapbox.mapboxsdk.tileprovider.IMapTileProviderCallback;
import com.mapbox.mapboxsdk.tileprovider.MapTileLayerArray;
import com.mapbox.mapboxsdk.tileprovider.modules.MapTileDownloader;
import com.mapbox.mapboxsdk.tileprovider.modules.MapTileModuleLayerBase;
import com.mapbox.mapboxsdk.tileprovider.tilesource.ITileLayer;
import com.mapbox.mapboxsdk.tileprovider.util.SimpleRegisterReceiver;
import com.mapbox.mapboxsdk.views.MapView;
import java.util.List;

public class MapTileLayerBasic
extends MapTileLayerArray
implements IMapTileProviderCallback {
    Context mContext;
    MapView mMapView;

    public MapTileLayerBasic(Context pContext, ITileLayer pTileSource, MapView mapView) {
        super(pContext, pTileSource, new SimpleRegisterReceiver(pContext));
        this.mContext = pContext;
        this.mMapView = mapView;
        this.setTileRequestCompleteHandler(this.mMapView.getTileRequestCompleteHandler());
        MapTileDownloader downloaderProvider = new MapTileDownloader(pTileSource, this.mTileCache, this.mNetworkAvailabilityCheck, this.mMapView);
        for (MapTileModuleLayerBase provider : this.mTileProviderList) {
            if (!provider.getClass().isInstance(MapTileDownloader.class)) continue;
            this.mTileProviderList.remove(provider);
        }
        this.addTileSource(pTileSource);
    }

    @Override
    public void setTileSource(ITileLayer aTileSource) {
        super.setTileSource(aTileSource);
        this.addTileSource(aTileSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTileSources(ITileLayer[] aTileSources) {
        super.setTileSource(null);
        List list = this.mTileProviderList;
        synchronized (list) {
            this.mTileProviderList.clear();
        }
        for (ITileLayer source : aTileSources) {
            this.addTileSource(source);
        }
    }

    public void addTileSource(ITileLayer pTileSource) {
        this.addTileSource(pTileSource, this.mTileProviderList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTileSource(ITileLayer pTileSource, int index) {
        if (pTileSource == null) {
            return;
        }
        MapTileDownloader downloaderProvider = new MapTileDownloader(pTileSource, this.mTileCache, this.mNetworkAvailabilityCheck, this.mMapView);
        if (this.hasNoSource()) {
            this.mCacheKey = pTileSource.getCacheKey();
        }
        List list = this.mTileProviderList;
        synchronized (list) {
            if (index < 0 || index > this.mTileProviderList.size()) {
                return;
            }
            this.mTileProviderList.add(index, downloaderProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTileSource(int index) {
        List list = this.mTileProviderList;
        synchronized (list) {
            if (index >= 0 & index < this.mTileProviderList.size()) {
                this.mTileProviderList.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTileSource(ITileLayer pTileSource) {
        List list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleLayerBase provider : this.mTileProviderList) {
                if (provider.getTileSource() != pTileSource) continue;
                this.mTileProviderList.remove(provider);
                return;
            }
        }
    }
}

