/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider;

import android.graphics.Rect;
import com.mapbox.mapboxsdk.constants.GeoConstants;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.tileprovider.constants.TileLayerConstants;

public class MapTile
implements GeoConstants,
MapboxConstants,
TileLayerConstants {
    public static final int MAPTILE_SUCCESS_ID = 0;
    public static final int MAPTILE_FAIL_ID = 1;
    private final int x;
    private final int y;
    private final int z;
    private final String path;
    private final String cacheKey;
    private final int code;
    private Rect mTileRect;
    private double tileSize = 256.0;
    private double originShift = 2.0037508342789244E7;
    private double initialResolution = 4.007501668557849E7 / this.tileSize;

    public MapTile(int az, int ax, int ay) {
        this("", az, ax, ay);
    }

    public MapTile(String aCacheKey, int az, int ax, int ay) {
        this.z = az;
        this.x = ax;
        this.y = ay;
        this.path = "" + this.z + '/' + this.x + '/' + this.y;
        this.cacheKey = aCacheKey + "/" + this.path;
        this.code = 17 * (37 + this.z) * (37 * this.x) * (37 + this.y);
    }

    public int getZ() {
        return this.z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String getPath() {
        return this.path;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MapTile)) {
            return false;
        }
        MapTile rhs = (MapTile)obj;
        return this.z == rhs.z && this.x == rhs.x && this.y == rhs.y;
    }

    public int hashCode() {
        return this.code;
    }

    public void setTileRect(Rect rect) {
        this.mTileRect = rect;
    }

    public final Rect getTileRect() {
        return this.mTileRect;
    }

    public BoundingBox getTileLatLonBounds() {
        double[] bounds = this.TileBounds(this.getX(), this.getY(), this.getZ());
        double[] minLatLon = this.MetersToLatLon(bounds[0], bounds[3]);
        double[] maxLatLon = this.MetersToLatLon(bounds[2], bounds[1]);
        return new BoundingBox(maxLatLon[0], maxLatLon[1], minLatLon[0], minLatLon[1]);
    }

    private double[] TileBounds(int tx, int ty, int zoom) {
        double[] wn = this.PixelsToMeters((double)tx * this.tileSize, (double)ty * this.tileSize, zoom);
        double[] es = this.PixelsToMeters((double)(tx + 1) * this.tileSize, (double)(ty + 1) * this.tileSize, zoom);
        return new double[]{wn[0], wn[1], es[0], es[1]};
    }

    private double[] PixelsToMeters(double px, double py, double zoom) {
        double res = this.Resolution(zoom);
        double mx = px * res - this.originShift;
        double my = py * res - this.originShift;
        return new double[]{mx, my};
    }

    private double[] MetersToLatLon(double mx, double my) {
        double lon = mx / this.originShift * 180.0;
        double lat = my / this.originShift * 180.0;
        lat = -57.29577951308232 * (2.0 * Math.atan(Math.exp(lat * Math.PI / 180.0)) - 1.5707963267948966);
        return new double[]{lat, lon};
    }

    private double Resolution(double zoom) {
        return this.initialResolution / Math.pow(2.0, zoom);
    }
}

