/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.OfflineDatabaseException;
import com.mapbox.mapboxsdk.offline.OfflineDatabaseManager;
import java.util.Date;

public class OfflineMapDatabase
implements MapboxConstants {
    private static final String TAG = "OfflineMapDatabase";
    private Context context;
    private SQLiteDatabase db;
    private String uniqueID;
    private String mapID;
    private boolean includesMetadata;
    private boolean includesMarkers;
    private MapboxConstants.RasterImageQuality imageQuality;
    private String path;
    private boolean invalid;
    private boolean initializedProperly = false;

    public OfflineMapDatabase(Context context) {
        this.context = context;
    }

    public OfflineMapDatabase(Context context, String mapID) {
        this.context = context;
        this.mapID = mapID;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public String getMapID() {
        return this.mapID;
    }

    public String getPath() {
        return this.path;
    }

    public MapboxConstants.RasterImageQuality getImageQuality() {
        return this.imageQuality;
    }

    public boolean initializeDatabase() {
        String uniqueID = this.sqliteMetadataForName("uniqueID");
        String mapID = this.sqliteMetadataForName("mapID");
        String includesMetadata = this.sqliteMetadataForName("includesMetadata");
        String includesMarkers = this.sqliteMetadataForName("includesMarkers");
        String imageQuality = this.sqliteMetadataForName("imageQuality");
        if (TextUtils.isEmpty((CharSequence)uniqueID)) {
            uniqueID = String.format(MAPBOX_LOCALE, "%s-%d", mapID, new Date().getTime() / 1000L);
        }
        if (!(TextUtils.isEmpty((CharSequence)mapID) || TextUtils.isEmpty((CharSequence)includesMetadata) || TextUtils.isEmpty((CharSequence)includesMarkers) || TextUtils.isEmpty((CharSequence)imageQuality))) {
            this.uniqueID = uniqueID;
            this.mapID = mapID;
            this.includesMetadata = "YES".equalsIgnoreCase(includesMetadata);
            this.includesMarkers = "YES".equalsIgnoreCase(includesMarkers);
            this.imageQuality = MapboxConstants.RasterImageQuality.getEnumForValue(Integer.parseInt(imageQuality));
            SQLiteDatabase db = this.database();
            this.path = db.getPath();
            this.initializedProperly = true;
        } else {
            Log.w((String)TAG, (String)"Invalid offline map database.  Can't be used.");
        }
        return this.initializedProperly;
    }

    public byte[] dataForURL(String url) throws OfflineDatabaseException {
        byte[] data = this.sqliteDataForURL(url);
        return data;
    }

    public void invalidate() {
        this.invalid = false;
    }

    public String sqliteMetadataForName(String name) {
        if (this.mapID == null) {
            return null;
        }
        SQLiteDatabase db = this.database();
        if (db == null) {
            return null;
        }
        String query = "SELECT value FROM metadata WHERE name=?;";
        String[] selectionArgs = new String[]{name};
        Cursor cursor = db.rawQuery(query, selectionArgs);
        if (cursor == null) {
            return null;
        }
        String res = null;
        if (cursor.moveToFirst()) {
            res = cursor.getString(cursor.getColumnIndex("value"));
        }
        cursor.close();
        return res;
    }

    public byte[] sqliteDataForURL(String url) {
        if (this.mapID == null) {
            return null;
        }
        SQLiteDatabase db = this.database();
        if (db == null) {
            return null;
        }
        String query = "SELECT data FROM resources WHERE url=?;";
        String[] selectionArgs = new String[]{url};
        Cursor cursor = db.rawQuery(query, selectionArgs);
        if (cursor == null) {
            return null;
        }
        byte[] res = null;
        if (cursor.moveToFirst()) {
            res = cursor.getBlob(cursor.getColumnIndex("data"));
        }
        cursor.close();
        return res;
    }

    private SQLiteDatabase database() {
        if (this.db == null) {
            this.db = OfflineDatabaseManager.getOfflineDatabaseManager(this.context).getOfflineDatabaseHandlerForMapId(this.mapID).getReadableDatabase();
        }
        if (!this.db.isOpen()) {
            this.db = null;
        }
        return this.db;
    }

    public void closeDatabase() {
        if (this.db != null && this.db.isOpen()) {
            this.db.close();
        }
        this.db = null;
    }
}

